/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.config;

import java.lang.reflect.Field;
import net.minecraftforge.common.Configuration;
import resonant.lib.config.Config;
import resonant.lib.config.ConfigScanner;

public final class ConfigHandler {
    public static void configure(Configuration config, String namespace) {
        config.load();
        for (Class clazz : ConfigScanner.instance().classes) {
            if (!clazz.getName().startsWith(namespace)) continue;
            for (Field field : clazz.getDeclaredFields()) {
                Config cfg = field.getAnnotation(Config.class);
                if (cfg == null) continue;
                ConfigHandler.handleField(field, cfg, config);
            }
        }
        config.save();
    }

    @Deprecated
    public static void handleClass(Class clazz, Configuration config) {
        config.load();
        for (Field field : clazz.getDeclaredFields()) {
            Config cfg = field.getAnnotation(Config.class);
            if (cfg == null) continue;
            ConfigHandler.handleField(field, cfg, config);
        }
        config.save();
    }

    private static void handleField(Field field, Config cfg, Configuration config) {
        try {
            String comment;
            field.setAccessible(true);
            String key = cfg.key().isEmpty() ? field.getName() : cfg.key();
            String string = comment = !cfg.comment().isEmpty() ? cfg.comment() : null;
            if (!field.getType().isArray()) {
                if (field.getType() == Integer.TYPE) {
                    int value = config.get(cfg.category(), key, field.getInt(null), comment).getInt(field.getInt(null));
                    field.setInt(null, value);
                } else if (field.getType() == Double.TYPE) {
                    double value = config.get(cfg.category(), key, field.getDouble(null), comment).getDouble(field.getDouble(null));
                    field.setDouble(null, value);
                } else if (field.getType() == Float.TYPE) {
                    float value = (float)config.get(cfg.category(), key, (double)field.getFloat(null), comment).getDouble(field.getDouble(null));
                    field.setFloat(null, value);
                } else if (field.getType() == String.class) {
                    String value = config.get(cfg.category(), key, (String)field.get(null), comment).getString();
                    field.set(null, value);
                } else if (field.getType() == Boolean.TYPE) {
                    boolean value = config.get(cfg.category(), key, field.getBoolean(null), comment).getBoolean(field.getBoolean(null));
                    field.setBoolean(null, value);
                } else if (field.getType() == Long.TYPE) {
                    long value = config.get(cfg.category(), key, (double)field.getLong(null), comment).getInt();
                    field.setLong(null, value);
                }
            } else if (field.getType().getComponentType() == String.class) {
                String[] values = config.get(cfg.category(), key, (String[])field.get(null), comment).getStringList();
                field.set(null, values);
            } else if (field.getType().getComponentType() == Integer.TYPE) {
                int[] values = config.get(cfg.category(), key, (int[])field.get(null), comment).getIntList();
                field.set(null, values);
            } else if (field.getType().getComponentType() == Boolean.TYPE) {
                boolean[] values = config.get(cfg.category(), key, (boolean[])field.get(null), comment).getBooleanList();
                field.set(null, values);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to configure: " + field.getName());
            e.printStackTrace();
        }
    }
}

