/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.content;

import cpw.mods.fml.client.registry.ClientRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import resonant.lib.References;
import resonant.lib.content.BlockInfo;
import resonant.lib.content.CommonRegistryProxy;
import resonant.lib.content.module.RenderTileDummy;

public class ClientRegistryProxy
extends CommonRegistryProxy {
    @Override
    public void registerBlock(Block block, Class<? extends ItemBlock> itemClass, String name, String modID) {
        super.registerBlock(block, itemClass, name, modID);
        BlockInfo blockInfo = block.getClass().getAnnotation(BlockInfo.class);
        if (blockInfo != null) {
            for (int i = 0; i < blockInfo.renderer().length; ++i) {
                try {
                    Class<?> tileClass = Class.forName(blockInfo.tileEntity()[i]);
                    Class<?> rendererClass = Class.forName(blockInfo.renderer()[i]);
                    ClientRegistry.bindTileEntitySpecialRenderer(tileClass, (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)rendererClass.newInstance()));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("[ClientContentRegistry]Failed to register block for: " + name);
                }
            }
        }
    }

    @Override
    public void registerTileEntity(String name, Class<? extends TileEntity> tileClass) {
        super.registerTileEntity(name, tileClass);
        TileEntitySpecialRenderer tileRenderer = null;
        try {
            String rendererName = tileClass.getName().replaceFirst("Tile", "Render");
            Class<?> renderClass = Class.forName(rendererName);
            tileRenderer = (TileEntitySpecialRenderer)renderClass.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            References.LOGGER.severe("[ClientContentRegistry]Failed to register TileEntity renderer for " + name);
            e.printStackTrace();
        }
        if (tileRenderer != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(tileClass, tileRenderer);
        }
    }

    @Override
    public void registerDummyRenderer(Class<? extends TileEntity> clazz) {
        if (!TileEntityRenderer.field_76963_a.field_76966_m.containsKey(clazz)) {
            ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)new RenderTileDummy());
        }
    }
}

