/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.content;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.Configuration;
import resonant.lib.content.BlockInfo;
import resonant.lib.content.CommonRegistryProxy;
import resonant.lib.content.IDManager;
import resonant.lib.content.module.BlockDummy;
import resonant.lib.content.module.TileBlock;
import resonant.lib.prefab.item.ItemBlockTooltip;
import resonant.lib.utility.LanguageUtility;

public class ContentRegistry {
    public final WeakHashMap<Block, String> blocks = new WeakHashMap();
    public final WeakHashMap<Item, String> items = new WeakHashMap();
    @SidedProxy(clientSide="resonant.lib.content.ClientRegistryProxy", serverSide="resonant.lib.content.CommonRegistryProxy")
    public static CommonRegistryProxy proxy;
    private final Configuration config;
    private final String modID;
    private IDManager idManager;
    private String modPrefix;
    private CreativeTabs defaultTab;
    private int packetID = 0;

    public ContentRegistry(Configuration config, IDManager idManager, String modID) {
        this.config = config;
        this.modID = modID;
        this.idManager = idManager;
    }

    public ContentRegistry setPrefix(String modPrefix) {
        this.modPrefix = modPrefix;
        return this;
    }

    public ContentRegistry setTab(CreativeTabs defaultTab) {
        this.defaultTab = defaultTab;
        return this;
    }

    public int getNextPacketID() {
        return ++this.packetID;
    }

    public Block newBlock(Class<? extends TileBlock> tileBlockClass) {
        try {
            TileBlock tileBlock = tileBlockClass.newInstance();
            String name = tileBlock.name;
            boolean canDisable = false;
            if (!canDisable || canDisable && this.config.get("enabled_list", "Enable " + name, true).getBoolean(true)) {
                BlockDummy block;
                int assignedID = this.idManager.getNextBlockID();
                int actualID = this.config.getBlock(name, assignedID).getInt(assignedID);
                tileBlock.block = block = new BlockDummy(actualID, this.modPrefix, this.defaultTab, tileBlock);
                this.blocks.put(block, name);
                proxy.registerBlock(block, tileBlock.itemBlock, name, this.modID);
                tileBlock.onInstantiate();
                if (tileBlock.tile() != null) {
                    proxy.registerTileEntity(name, ((Object)((Object)tileBlock.tile())).getClass());
                    if (!tileBlock.normalRender) {
                        proxy.registerDummyRenderer(((Object)((Object)tileBlock.tile())).getClass());
                    }
                }
                return block;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("TileBlock [" + tileBlockClass.getSimpleName() + "] failed to be created:", e);
        }
        return null;
    }

    public Block createBlock(Class<? extends Block> blockClass) {
        return this.createBlock(blockClass, ItemBlockTooltip.class);
    }

    public Block createTile(Class<? extends Block> blockClass, Class<? extends TileEntity> tileClass) {
        return this.createBlock(blockClass, ItemBlockTooltip.class, tileClass);
    }

    public Block createBlock(Class<? extends Block> blockClass, Class<? extends ItemBlock> itemClass) {
        return this.createBlock(blockClass, itemClass, null);
    }

    public Block createBlock(Class<? extends Block> blockClass, Class<? extends ItemBlock> itemClass, Class<? extends TileEntity> tileClass) {
        return this.createBlock(LanguageUtility.decapitalizeFirst(blockClass.getSimpleName().replace("Block", "")), blockClass, itemClass, tileClass);
    }

    public Block createBlock(String name, Class<? extends Block> blockClass, Class<? extends ItemBlock> itemClass, Class<? extends TileEntity> tileClass) {
        return this.createBlock(name, blockClass, itemClass, tileClass, false);
    }

    public Block createBlock(String name, Class<? extends Block> blockClass, Class<? extends ItemBlock> itemClass, Class<? extends TileEntity> tileClass, boolean canDisable) {
        Block block = null;
        if (blockClass != null && (!canDisable || canDisable && this.config.get("Enabled_List", "Enabled " + name, true).getBoolean(true))) {
            try {
                int assignedID = this.idManager.getNextBlockID();
                int actualID = this.config.getBlock(name, assignedID).getInt(assignedID);
                block = blockClass.getConstructor(Integer.TYPE).newInstance(actualID);
                if (block != null) {
                    if (this.modPrefix != null) {
                        block.func_71864_b(this.modPrefix + name);
                        if (ReflectionHelper.getPrivateValue(Block.class, (Object)block, (String[])new String[]{"textureName", "field_111026_f"}) == null) {
                            block.func_111022_d(this.modPrefix + name);
                        }
                    }
                    if (this.defaultTab != null) {
                        block.func_71849_a(this.defaultTab);
                    }
                    this.blocks.put(block, name);
                    proxy.registerBlock(block, itemClass, name, this.modID);
                    this.finishCreation(block, tileClass);
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Block [" + name + "] failed to be created:", e);
            }
        }
        return block;
    }

    public void finishCreation(Block block, Class<? extends TileEntity> tileClass) throws ClassNotFoundException {
        BlockInfo blockInfo = block.getClass().getAnnotation(BlockInfo.class);
        if (blockInfo != null) {
            for (String string : blockInfo.tileEntity()) {
                Class<?> clazz = Class.forName(string);
                proxy.registerTileEntity(clazz.getName(), clazz);
            }
        }
        if (tileClass != null) {
            proxy.registerTileEntity(block.func_71917_a(), tileClass);
        }
    }

    public Block getBlock(String blockName) {
        for (Map.Entry<Block, String> entry : this.blocks.entrySet()) {
            String name = entry.getKey().func_71917_a().replace("tile.", "");
            if (!name.equalsIgnoreCase(blockName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Item createItem(Class<? extends Item> clazz) {
        return this.createItem(LanguageUtility.decapitalizeFirst(clazz.getSimpleName().replace("Item", "")), clazz, true);
    }

    public Item createItem(String name, Class<? extends Item> clazz) {
        return this.createItem(name, clazz, false);
    }

    public Item createItem(String name, Class<? extends Item> clazz, boolean canDisable) {
        Item item = null;
        if (clazz != null && (!canDisable || canDisable && this.config.get("Enabled_List", "Enabled_" + name, true).getBoolean(true))) {
            try {
                int assignedID = this.idManager.getNextItemID(this.config, name);
                item = clazz.getConstructor(Integer.TYPE).newInstance(assignedID);
                if (item != null) {
                    if (this.modPrefix != null) {
                        item.func_77655_b(this.modPrefix + name);
                        if (ReflectionHelper.getPrivateValue(Item.class, (Object)item, (String[])new String[]{"iconString", "field_111218_cA"}) == null) {
                            item.func_111206_d(this.modPrefix + name);
                        }
                    }
                    if (this.defaultTab != null) {
                        item.func_77637_a(this.defaultTab);
                    }
                    this.items.put(item, name);
                    GameRegistry.registerItem((Item)item, (String)name, (String)this.modID);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Item [" + name + "] failed to be created: " + e.getLocalizedMessage(), e.fillInStackTrace());
            }
        }
        return item;
    }
}

