/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.content.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import resonant.lib.content.module.TileBlock;
import resonant.lib.prefab.vector.Cuboid;
import resonant.lib.render.block.BlockRenderingHandler;
import resonant.lib.utility.inventory.InventoryUtility;
import universalelectricity.api.vector.Vector3;

public class BlockDummy
extends Block
implements ITileEntityProvider {
    public final TileBlock dummyTile;

    public BlockDummy(int id, String modPrefix, CreativeTabs defaultTab, TileBlock dummyTile) {
        super(id, dummyTile.material);
        this.dummyTile = dummyTile;
        dummyTile.domain = modPrefix;
        this.func_71864_b(modPrefix + dummyTile.name);
        this.func_111022_d(modPrefix + dummyTile.textureName);
        if (dummyTile.creativeTab != null) {
            this.func_71849_a(dummyTile.creativeTab);
        } else {
            this.func_71849_a(defaultTab);
        }
        dummyTile.bounds.setBounds(this);
        BlockDummy.field_71970_n[id] = this.func_71926_d();
        BlockDummy.field_71971_o[id] = this.func_71926_d() ? 255 : 0;
        this.func_71848_c(dummyTile.blockHardness);
        this.func_71894_b(dummyTile.blockResistance);
        this.func_71907_b(dummyTile.tickRandomly);
    }

    public void inject(IBlockAccess access, int x, int y, int z) {
        if (access instanceof World) {
            this.dummyTile.field_70331_k = (World)access;
        }
        this.dummyTile.access = access;
        this.dummyTile.field_70329_l = x;
        this.dummyTile.field_70330_m = y;
        this.dummyTile.field_70327_n = z;
        TileEntity tile = access.func_72796_p(x, y, z);
        if (tile instanceof TileBlock) {
            ((TileBlock)tile).block = this;
        }
    }

    public void eject() {
        this.dummyTile.field_70331_k = null;
        this.dummyTile.field_70329_l = 0;
        this.dummyTile.field_70330_m = 0;
        this.dummyTile.field_70327_n = 0;
    }

    public TileBlock getTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileBlock) {
            return (TileBlock)tile;
        }
        return this.dummyTile;
    }

    public boolean hasTileEntity(int metadata) {
        return this.dummyTile.tile() != null;
    }

    public TileEntity func_72274_a(World world) {
        try {
            return (TileEntity)((Object)((Object)this.dummyTile.tile())).getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void func_71892_f(World world, int x, int y, int z) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onFillRain();
        this.eject();
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).click(player);
        this.eject();
    }

    public void func_71861_g(World world, int x, int y, int z) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onAdded();
        this.eject();
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onPlaced(entityLiving, itemStack);
        this.eject();
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onRemove(par5, par6);
        this.eject();
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return this.dummyTile.quantityDropped(meta, fortune);
    }

    public void func_71863_a(World world, int x, int y, int z, int side) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onNeighborChanged();
        this.eject();
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        this.inject((IBlockAccess)world, x, y, z);
        boolean value = this.getTile((IBlockAccess)world, x, y, z).activate(player, side, new Vector3((double)hitX, (double)hitY, (double)hitZ));
        this.eject();
        return value;
    }

    public void func_71847_b(World world, int x, int y, int z, Random par5Random) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).func_70316_g();
        this.eject();
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).collide(entity);
        this.eject();
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.inject((IBlockAccess)world, x, y, z);
        Iterable<Cuboid> bounds = this.getTile((IBlockAccess)world, x, y, z).getCollisionBoxes(aabb != null ? new Cuboid(aabb).translate(new Vector3((double)x, (double)y, (double)z).invert()) : null, entity);
        if (bounds != null) {
            for (Cuboid cuboid : bounds) {
                list.add(cuboid.clone().translate(new Vector3((double)x, (double)y, (double)z)).toAABB());
            }
        }
        this.eject();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        this.inject((IBlockAccess)world, x, y, z);
        Cuboid value = this.getTile((IBlockAccess)world, x, y, z).getSelectBounds().clone().translate(new Vector3((double)x, (double)y, (double)z));
        this.eject();
        return value.toAABB();
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        this.inject((IBlockAccess)world, x, y, z);
        Cuboid value = this.getTile((IBlockAccess)world, x, y, z).getCollisionBounds().clone().translate(new Vector3((double)x, (double)y, (double)z));
        this.eject();
        return value.toAABB();
    }

    public boolean func_71877_c(IBlockAccess access, int x, int y, int z, int side) {
        return this.dummyTile.shouldSideBeRendered(access, x, y, z, side);
    }

    public boolean func_71924_d(IBlockAccess access, int x, int y, int z, int side) {
        this.inject(access, x, y, z);
        boolean value = this.getTile(access, x, y, z).isSolid(access, side);
        this.eject();
        return value;
    }

    public int getLightValue(IBlockAccess access, int x, int y, int z) {
        int value = 0;
        if (access != null) {
            this.inject(access, x, y, z);
            value = this.getTile(access, x, y, z).getLightValue(access);
            this.eject();
        }
        return value;
    }

    public boolean func_96468_q_() {
        return this.dummyTile instanceof TileBlock.IComparatorInputOverride;
    }

    public boolean func_71926_d() {
        if (this.dummyTile == null) {
            return true;
        }
        return this.dummyTile.isOpaqueCube;
    }

    public boolean func_71886_c() {
        return this.dummyTile.normalRender;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return BlockRenderingHandler.ID;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess access, int x, int y, int z, int side) {
        this.inject(access, x, y, z);
        Icon value = this.getTile(access, x, y, z).getIcon(access, side);
        this.eject();
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return this.dummyTile.getIcon(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.dummyTile.registerIcons(iconRegister);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        this.inject((IBlockAccess)world, x, y, z);
        ItemStack value = this.getTile((IBlockAccess)world, x, y, z).getPickBlock(target);
        this.eject();
        return value;
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        this.inject((IBlockAccess)world, x, y, z);
        ArrayList value = this.getTile((IBlockAccess)world, x, y, z).getDrops(metadata, fortune);
        this.eject();
        return value != null ? value : new ArrayList();
    }

    protected void func_71929_a(World world, int x, int y, int z, ItemStack itemStack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            InventoryUtility.dropItemStack(world, new Vector3((double)x, (double)y, (double)z), itemStack);
        }
    }

    public void func_71879_a(int id, CreativeTabs creativeTab, List list) {
        this.dummyTile.getSubBlocks(id, creativeTab, list);
    }

    public boolean func_71853_i() {
        return this.dummyTile.canProvidePower;
    }

    public int func_71865_a(IBlockAccess access, int x, int y, int z, int side) {
        this.inject(access, x, y, z);
        int value = this.getTile(access, x, y, z).getWeakRedstonePower(access, side);
        this.eject();
        return value;
    }

    public int func_71855_c(IBlockAccess access, int x, int y, int z, int side) {
        this.inject(access, x, y, z);
        int value = this.getTile(access, x, y, z).getStrongRedstonePower(access, side);
        this.eject();
        return value;
    }

    public int func_71856_s_() {
        return this.dummyTile.getRenderBlockPass();
    }

    public int func_71859_p_(World world) {
        return this.dummyTile.tickRate(world);
    }
}

