/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.grid;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class Grid<N> {
    protected final Set<N> nodes = Collections.newSetFromMap(new WeakHashMap());
    private final Class<? extends N> nodeType;

    public Grid(Class<? extends N> type) {
        this.nodeType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(N node) {
        Set<N> set = this.nodes;
        synchronized (set) {
            this.nodes.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(N node) {
        Set<N> set = this.nodes;
        synchronized (set) {
            this.nodes.remove(node);
        }
    }

    public Set<N> getNodes() {
        return this.nodes;
    }

    public void reconstruct() {
        Iterator<N> it = new HashSet<N>(this.nodes).iterator();
        while (it.hasNext()) {
            N node = it.next();
            if (this.isValidNode(node)) {
                this.reconstructNode(node);
                continue;
            }
            it.remove();
        }
    }

    public boolean isValidNode(Object node) {
        return this.nodeType.isAssignableFrom(node.getClass());
    }

    protected void reconstructNode(N node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deconstruct() {
        Set<N> set = this.nodes;
        synchronized (set) {
            this.nodes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized N getFirstNode() {
        Set<N> set = this.nodes;
        synchronized (set) {
            Iterator<N> i$ = this.nodes.iterator();
            if (i$.hasNext()) {
                N node = i$.next();
                return node;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.hashCode() + ", Nodes: " + this.nodes.size() + "]";
    }
}

