/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.multiblock;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import resonant.core.ResonantEngine;
import resonant.lib.References;
import resonant.lib.multiblock.IMultiBlock;
import resonant.lib.multiblock.TileMultiBlockPart;
import resonant.lib.network.PacketTile;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class BlockMultiBlockPart
extends BlockContainer {
    public String field_111026_f = null;
    public PacketTile packetType;

    public BlockMultiBlockPart() {
        this(References.CONFIGURATION.get("block", "Multiblock", ResonantEngine.idManager.getNextBlockID()).getInt());
    }

    public BlockMultiBlockPart(int id) {
        super(id, UniversalElectricity.machine);
        this.func_71848_c(0.8f);
        this.func_71864_b("multiBlock");
    }

    public BlockMultiBlockPart setPacketType(PacketTile packetType) {
        this.packetType = packetType;
        return this;
    }

    public BlockMultiBlockPart setTextureName(String name) {
        this.field_111026_f = name;
        return this;
    }

    public void createMultiBlockStructure(IMultiBlock tile) {
        Vector3[] positions;
        TileEntity tileEntity = (TileEntity)tile;
        for (Vector3 position : positions = tile.getMultiBlockVectors()) {
            this.makeFakeBlock(tileEntity.field_70331_k, new Vector3(tileEntity).translate((IVector3)position), new Vector3(tileEntity));
        }
    }

    public void destroyMultiBlockStructure(IMultiBlock tile) {
        Vector3[] positions;
        TileEntity tileEntity = (TileEntity)tile;
        for (Vector3 position : positions = tile.getMultiBlockVectors()) {
            new Vector3(tileEntity).translate((IVector3)position).setBlock(tileEntity.field_70331_k, 0);
        }
        new Vector3(tileEntity).setBlock(tileEntity.field_70331_k, 0);
    }

    public void makeFakeBlock(World worldObj, Vector3 position, Vector3 mainBlock) {
        worldObj.func_94575_c(position.intX(), position.intY(), position.intZ(), this.field_71990_ca);
        ((TileMultiBlockPart)worldObj.func_72796_p(position.intX(), position.intY(), position.intZ())).setMainBlock(mainBlock);
    }

    public Icon func_71895_b(IBlockAccess blockAccess, int x, int y, int z, int par5) {
        try {
            Vector3 main = ((TileMultiBlockPart)blockAccess.func_72796_p(x, y, z)).getMainBlock();
            Block block = Block.field_71973_m[main.getBlockID(blockAccess)];
            if (block != null) {
                return block.func_71895_b(blockAccess, main.intX(), main.intY(), main.intZ(), par5);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        if (this.field_111026_f != null) {
            this.field_94336_cN = iconRegister.func_94245_a(this.field_111026_f);
        } else {
            super.func_94332_a(iconRegister);
        }
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileMultiBlockPart) {
            ((TileMultiBlockPart)tileEntity).onBlockRemoval(this);
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public boolean func_71903_a(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        TileMultiBlockPart tileEntity = (TileMultiBlockPart)par1World.func_72796_p(x, y, z);
        return tileEntity.onBlockActivated(par1World, x, y, z, par5EntityPlayer);
    }

    public int func_71925_a(Random par1Random) {
        return 0;
    }

    public int func_71857_b() {
        return -1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public TileEntity func_72274_a(World var1) {
        return new TileMultiBlockPart();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World par1World, int x, int y, int z) {
        int mainBlockID;
        TileEntity tileEntity = par1World.func_72796_p(x, y, z);
        Vector3 mainBlockPosition = ((TileMultiBlockPart)tileEntity).getMainBlock();
        if (mainBlockPosition != null && (mainBlockID = par1World.func_72798_a(mainBlockPosition.intX(), mainBlockPosition.intY(), mainBlockPosition.intZ())) > 0) {
            return Block.field_71973_m[mainBlockID].getPickBlock(target, par1World, mainBlockPosition.intX(), mainBlockPosition.intY(), mainBlockPosition.intZ());
        }
        return null;
    }
}

