/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInput;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidTank;
import resonant.lib.References;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonant.lib.network.PacketType;
import resonant.lib.network.Synced;
import resonant.lib.utility.nbt.ISaveObj;
import universalelectricity.api.vector.Vector3;

public class PacketAnnotation
extends PacketType {
    static int maxID = 0;
    protected static final BiMap<Class, Integer> classPacketIDMap = HashBiMap.create();
    protected static final HashMap<Integer, HashMap<Integer, PacketSet>> packetSetIDMap = new HashMap();

    public static void register(Class<? extends TileEntity> clazz) {
        PacketAnnotation.constructPacketSets(clazz);
    }

    public PacketAnnotation(String channel) {
        super(channel);
    }

    public static void constructPacketSets(Class clazz) {
        if (classPacketIDMap.containsKey(clazz)) {
            return;
        }
        int classID = ++maxID;
        classPacketIDMap.put(clazz, (Object)classID);
        HashMap<Integer, PacketSet> packetSets = new HashMap<Integer, PacketSet>();
        while (clazz != null) {
            PacketSet packetSet;
            Annotation sync;
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Synced.class)) continue;
                sync = field.getAnnotation(Synced.class);
                for (int packetID : sync.value()) {
                    packetSet = packetSets.containsKey(packetID) ? (PacketSet)packetSets.get(packetID) : new PacketSet(packetID);
                    packetSet.syncFields.add(field);
                    packetSets.put(packetID, packetSet);
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (accessibleObject.isAnnotationPresent(Synced.SyncedInput.class)) {
                    sync = ((Method)accessibleObject).getAnnotation(Synced.SyncedInput.class);
                    for (int packetID : sync.value()) {
                        packetSet = packetSets.containsKey(packetID) ? (PacketSet)packetSets.get(packetID) : new PacketSet(packetID);
                        packetSet.syncInputs.add((Method)accessibleObject);
                        packetSets.put(packetID, packetSet);
                    }
                }
                if (!accessibleObject.isAnnotationPresent(Synced.SyncedOutput.class)) continue;
                sync = ((Method)accessibleObject).getAnnotation(Synced.SyncedOutput.class);
                for (int packetID : sync.value()) {
                    packetSet = packetSets.containsKey(packetID) ? (PacketSet)packetSets.get(packetID) : new PacketSet(packetID);
                    packetSet.syncOutputs.add((Method)accessibleObject);
                    packetSets.put(packetID, packetSet);
                }
            }
            clazz = clazz.getSuperclass();
        }
        packetSetIDMap.put(classID, packetSets);
    }

    public void sync(Object obj, int packetSetID) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            PacketDispatcher.sendPacketToAllPlayers((Packet)this.getPacket(obj, packetSetID));
        } else {
            PacketDispatcher.sendPacketToServer((Packet)this.getPacket(obj, packetSetID));
        }
    }

    public Packet getPacket(Object obj) {
        return this.getPacket(obj, 0);
    }

    public Packet getPacket(Object obj, int packetSetID) {
        PacketSet packetSet;
        PacketAnnotation.constructPacketSets(obj.getClass());
        int classID = (Integer)classPacketIDMap.get(obj.getClass());
        if (packetSetIDMap.size() > classID && (packetSet = packetSetIDMap.get(classID).get(packetSetID)) != null) {
            List args = packetSet.getPacketArray(obj);
            args.add(0, classID);
            args.add(1, packetSetID);
            if (obj instanceof TileEntity) {
                args.add(2, ((TileEntity)obj).field_70329_l);
                args.add(3, ((TileEntity)obj).field_70330_m);
                args.add(4, ((TileEntity)obj).field_70327_n);
            }
            return super.getPacket(args.toArray());
        }
        return null;
    }

    @Override
    public void receivePacket(ByteArrayDataInput data, EntityPlayer player) {
        int classID = data.readInt();
        int packetSetID = data.readInt();
        try {
            if (TileEntity.class.isAssignableFrom((Class)classPacketIDMap.inverse().get((Object)classID))) {
                int z;
                int y;
                int x = data.readInt();
                TileEntity tile = player.field_70170_p.func_72796_p(x, y = data.readInt(), z = data.readInt());
                if (tile != null) {
                    packetSetIDMap.get(classID).get(packetSetID).read(tile, data);
                    if (tile instanceof IPacketReceiver) {
                        ((IPacketReceiver)tile).onReceivePacket(data, player, x, y, z);
                    }
                }
            } else {
                References.LOGGER.severe("Resonant Engine annotation packet failed to be read.");
            }
        }
        catch (Exception e) {
            References.LOGGER.severe("Resonant Engine packet failed with CLASS ID: " + classID);
            e.printStackTrace();
        }
    }

    public static class PacketSet {
        public final int id;
        public final List<Field> syncFields = new ArrayList<Field>();
        public final List<Method> syncInputs = new ArrayList<Method>();
        public final List<Method> syncOutputs = new ArrayList<Method>();

        public PacketSet(int id) {
            this.id = id;
        }

        public List getPacketArray(Object obj) {
            ArrayList<Object> args = new ArrayList<Object>();
            try {
                for (Field f : this.syncFields) {
                    f.setAccessible(true);
                    Class<?> type = f.getType();
                    Object syncObj = f.get(obj);
                    if (!type.isPrimitive()) {
                        if (syncObj == null) {
                            args.add(false);
                            continue;
                        }
                        args.add(true);
                        args.add(syncObj);
                        continue;
                    }
                    args.add(syncObj);
                }
                for (Method m : this.syncOutputs) {
                    m.setAccessible(true);
                    NBTTagCompound nbt = new NBTTagCompound();
                    m.invoke(obj, nbt);
                    args.add(nbt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return args;
        }

        public void read(Object obj, ByteArrayDataInput data) {
            try {
                for (Field f : this.syncFields) {
                    f.setAccessible(true);
                    Class<?> type = f.getType();
                    Object result = null;
                    if (type.isPrimitive()) {
                        if (type == Integer.class || type == Integer.TYPE) {
                            result = data.readInt();
                        } else if (type == Float.class || type == Float.TYPE) {
                            result = Float.valueOf(data.readFloat());
                        } else if (type == Double.class || type == Double.TYPE) {
                            result = data.readDouble();
                        } else if (type == Byte.class || type == Byte.TYPE) {
                            result = data.readByte();
                        } else if (type == Boolean.class || type == Boolean.TYPE) {
                            result = data.readBoolean();
                        } else if (type == Short.class || type == Short.TYPE) {
                            result = data.readShort();
                        } else if (type == Long.class || type == Long.TYPE) {
                            result = data.readLong();
                        }
                        if (result == null) {
                            References.LOGGER.severe("Calclavia packet read a null field for " + obj.getClass().getSimpleName());
                        }
                    } else if (data.readBoolean()) {
                        if (type == String.class) {
                            result = data.readUTF();
                        } else if (type == Vector3.class) {
                            result = new Vector3(data.readDouble(), data.readDouble(), data.readDouble());
                        } else if (type == NBTTagCompound.class) {
                            result = PacketHandler.readNBTTagCompound((DataInput)data);
                        } else if (type == FluidTank.class) {
                            result = new FluidTank(data.readInt()).readFromNBT(PacketHandler.readNBTTagCompound((DataInput)data));
                        } else if (ISaveObj.class.isAssignableFrom(type)) {
                            result = f.get(obj);
                            ((ISaveObj)result).load(PacketHandler.readNBTTagCompound((DataInput)data));
                        }
                    } else {
                        result = null;
                    }
                    f.set(obj, result);
                }
                for (Method m : this.syncInputs) {
                    m.setAccessible(true);
                    m.invoke(obj, PacketHandler.readNBTTagCompound((DataInput)data));
                }
            }
            catch (Exception e) {
                References.LOGGER.severe("Resonant Engine annotation packet failed for " + obj.getClass().getSimpleName());
                e.printStackTrace();
            }
        }
    }
}

