/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.block;

import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.blocks.IRotatableBlock;
import resonant.lib.prefab.block.BlockTile;

public abstract class BlockRotatable
extends BlockTile
implements IRotatableBlock {
    protected byte rotationMask = Byte.parseByte("111100", 2);
    protected boolean isFlipPlacement = false;

    public BlockRotatable(int id, Material material) {
        super(id, material);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        world.func_72921_c(x, y, z, this.determineOrientation(world, x, y, z, entityLiving), 3);
    }

    public int determineOrientation(World world, int x, int y, int z, EntityLivingBase entityLiving) {
        int returnSide;
        int playerSide;
        if (MathHelper.func_76135_e((float)((float)entityLiving.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entityLiving.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entityLiving.field_70163_u + 1.82 - (double)entityLiving.field_70129_M;
            if (this.canRotate(1) && d0 - (double)y > 2.0) {
                return 1;
            }
            if (this.canRotate(0) && (double)y - d0 > 0.0) {
                return 0;
            }
        }
        int n = (playerSide = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 && this.canRotate(2) ? 2 : (playerSide == 1 && this.canRotate(5) ? 5 : (playerSide == 2 && this.canRotate(3) ? 3 : (returnSide = playerSide == 3 && this.canRotate(4) ? 4 : 0)));
        if (this.isFlipPlacement) {
            return ForgeDirection.getOrientation((int)returnSide).getOpposite().ordinal();
        }
        return returnSide;
    }

    public boolean canRotate(int ord) {
        return (this.rotationMask & 1 << ord) != 0;
    }

    @Override
    public boolean onSneakUseWrench(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        return this.doRotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side));
    }

    @Override
    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        return this.onSneakUseWrench(world, x, y, z, par5EntityPlayer, side, hitX, hitY, hitZ);
    }

    public boolean doRotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int currentRotMeta = worldObj.func_72805_g(x, y, z);
        ForgeDirection orientation = ForgeDirection.getOrientation((int)currentRotMeta);
        ForgeDirection rotated = orientation.getRotation(axis);
        int rmeta = rotated.ordinal();
        int rmetaBit = 1 << rmeta;
        if ((rmetaBit & this.rotationMask) == rmetaBit && this.canRotate(rmeta)) {
            worldObj.func_72921_c(x, y, z, rmeta, 3);
            return true;
        }
        return false;
    }

    @Override
    public ForgeDirection getDirection(World world, int x, int y, int z) {
        return ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z));
    }

    @Override
    public void setDirection(World world, int x, int y, int z, ForgeDirection direction) {
        world.func_72921_c(x, y, z, direction.ordinal(), 3);
    }
}

