/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.damage;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import resonant.api.armor.IInsulatedArmor;
import resonant.lib.prefab.CustomDamageSource;
import resonant.lib.prefab.potion.CustomPotionEffect;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.electricity.IElectricalNetwork;

public class ElectricalDamage
extends CustomDamageSource {
    public ElectricalDamage(Object source) {
        super("electrocution");
        this.setDamageBypassesArmor();
        this.func_76351_m();
    }

    public static void handleElectrocution(Entity entity, IElectricalNetwork network) {
        ElectricalDamage.handleElectrocution(entity, null, network);
    }

    public static void handleElectrocution(Entity entity, Object source, IElectricalNetwork network) {
        ElectricalDamage.handleElectrocution(entity, source, network, 1.0f);
    }

    public static void handleElectrocution(Entity entity, Object source, IElectricalNetwork network, float percent) {
        if (network != null && network.getRequest() > 0L && network.getBuffer() > 0L && network.getVoltage() != 0L) {
            ElectricalDamage.electrocuteEntity(entity, source, network.getVoltage(), percent);
            network.setBuffer(Math.max(0L, network.getBuffer() - network.getVoltage() * 10L));
        }
    }

    public static float electrocuteEntity(Entity entity, Object source, long voltage, float percent) {
        if (entity instanceof EntityLivingBase) {
            float damage = (float)Math.abs(voltage / UniversalElectricity.DEFAULT_VOLTAGE) * percent;
            ElectricalDamage sourceDamage = new ElectricalDamage(source);
            if ((damage = ElectricalDamage.handleArmorReduction(entity, sourceDamage, voltage, damage)) > 0.0f) {
                entity.func_70097_a((DamageSource)sourceDamage, Math.min(damage, 15.0f));
                if (entity instanceof EntityLivingBase && damage >= 2.0f) {
                    ((EntityLivingBase)entity).func_70690_d((PotionEffect)new CustomPotionEffect(Potion.field_76431_k.field_76415_H, (int)(voltage / 120L * 20L), 1));
                    ((EntityLivingBase)entity).func_70690_d((PotionEffect)new CustomPotionEffect(Potion.field_76437_t.field_76415_H, (int)(voltage / 120L * 20L), 1));
                    ((EntityLivingBase)entity).func_70690_d((PotionEffect)new CustomPotionEffect(Potion.field_76419_f.field_76415_H, (int)(voltage / 120L * 20L), 1));
                }
            }
            return damage >= 0.0f ? damage : 0.0f;
        }
        return 0.0f;
    }

    public static float handleArmorReduction(Entity entity, DamageSource source, long voltage, float damage) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            float averageDamage = 0.0f;
            float appliedDamage = damage;
            boolean fullSuit = true;
            boolean hadArmor = false;
            for (int armorSlot = 0; armorSlot < entityPlayer.field_71071_by.field_70460_b.length; ++armorSlot) {
                if (entityPlayer.field_71071_by.field_70460_b[armorSlot] == null) continue;
                if (entityPlayer.field_71071_by.field_70460_b[armorSlot].func_77973_b() instanceof IInsulatedArmor) {
                    IInsulatedArmor insulatedArmor = (IInsulatedArmor)entityPlayer.field_71071_by.field_70460_b[armorSlot].func_77973_b();
                    float d = insulatedArmor.onEletricalDamage(entityPlayer.field_71071_by.field_70460_b[armorSlot], (EntityLivingBase)entity, source, voltage, damage);
                    hadArmor = true;
                    if (insulatedArmor.areAllPartsNeeded(entityPlayer.field_71071_by.field_70460_b[armorSlot], (EntityLivingBase)entity, source, "Electrical", voltage)) {
                        averageDamage += d;
                        if (armorSlot <= 0 || insulatedArmor.isPartOfSet(entityPlayer.field_71071_by.field_70460_b[armorSlot], entityPlayer.field_71071_by.field_70460_b[armorSlot - 1])) continue;
                        fullSuit = false;
                        continue;
                    }
                    appliedDamage = d;
                    fullSuit = false;
                    continue;
                }
                fullSuit = false;
            }
            if (fullSuit && hadArmor) {
                return averageDamage > 0.0f ? averageDamage / 4.0f : 0.0f;
            }
            return appliedDamage;
        }
        return damage;
    }
}

