/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.terminal;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.DataInput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import resonant.api.IPlayerUsing;
import resonant.api.IScroll;
import resonant.api.ITerminal;
import resonant.lib.network.IPacketReceiverWithID;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.terminal.CommandRegistry;
import resonant.lib.prefab.tile.TileAdvanced;

public abstract class TileTerminal
extends TileAdvanced
implements ITerminal,
IScroll,
IPacketReceiverWithID,
IPlayerUsing {
    public final HashSet<EntityPlayer> playersUsing = new HashSet();
    private final List<String> terminalOutput = new ArrayList<String>();
    public static final int SCROLL_SIZE = 15;
    private int scroll = 0;
    protected static final int COMMAND_PACKET_ID = 0;
    protected static final int TERMINAL_PACKET_ID = 1;
    protected static final int NBT_PACKET_ID = 2;

    public abstract Packet getTerminalPacket();

    public abstract Packet getCommandPacket(String var1, String var2);

    public void sendTerminalOutputToClients() {
        Packet packet = this.getTerminalPacket();
        for (EntityPlayer player : this.getPlayersUsing()) {
            PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
        }
    }

    public void sendCommandToServer(EntityPlayer entityPlayer, String cmdInput) {
        PacketDispatcher.sendPacketToServer((Packet)this.getCommandPacket(entityPlayer.field_71092_bJ, cmdInput));
    }

    public ArrayList getPacketData(int type) {
        ArrayList<Object> data = new ArrayList<Object>();
        switch (type) {
            case 2: {
                NBTTagCompound nbt = new NBTTagCompound();
                this.func_70310_b(nbt);
                data.add(nbt);
                break;
            }
            case 1: {
                data.add(this.getTerminalOuput().size());
                data.addAll(this.getTerminalOuput());
            }
        }
        return data;
    }

    @Override
    public boolean onReceivePacket(int id, ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            switch (id) {
                case 2: {
                    this.func_70307_a(PacketHandler.readNBTTagCompound((DataInput)data));
                    return true;
                }
                case 1: {
                    int size = data.readInt();
                    ArrayList<String> oldTerminalOutput = new ArrayList<String>(this.terminalOutput);
                    this.terminalOutput.clear();
                    for (int i = 0; i < size; ++i) {
                        this.terminalOutput.add(data.readUTF());
                    }
                    if (!this.terminalOutput.equals(oldTerminalOutput) && this.terminalOutput.size() != oldTerminalOutput.size()) {
                        this.setScroll(this.getTerminalOuput().size() - 15);
                    }
                    return true;
                }
                case 0: {
                    CommandRegistry.onCommand(this.field_70331_k.func_72924_a(data.readUTF()), this, data.readUTF());
                    this.sendTerminalOutputToClients();
                    return true;
                }
            }
        }
        catch (Exception e) {
            System.out.println("[CalclaviaCore]Terminal-Prefab: Failed to read packet");
            e.printStackTrace();
            return true;
        }
        return false;
    }

    @Override
    public List<String> getTerminalOuput() {
        return this.terminalOutput;
    }

    @Override
    public boolean addToConsole(String msg) {
        if (!this.field_70331_k.field_72995_K) {
            boolean usedLines = false;
            msg.trim();
            if (msg.length() > 23) {
                msg = msg.substring(0, 22);
            }
            this.getTerminalOuput().add(msg);
            this.sendTerminalOutputToClients();
            return true;
        }
        return false;
    }

    @Override
    public void addToConsole(List<String> output_list) {
        if (output_list != null && !output_list.isEmpty()) {
            for (String string : output_list) {
                this.addToConsole(string);
            }
        }
    }

    @Override
    public void scroll(int amount) {
        this.setScroll(this.scroll + amount);
    }

    @Override
    public void setScroll(int length) {
        this.scroll = Math.max(Math.min(length, this.getTerminalOuput().size()), 0);
    }

    @Override
    public int getScroll() {
        return this.scroll;
    }

    @Override
    public boolean canUse(String node, EntityPlayer player) {
        return true;
    }

    @Override
    public HashSet<EntityPlayer> getPlayersUsing() {
        return this.playersUsing;
    }
}

