/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.tile;

import java.util.EnumSet;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IIO;
import resonant.lib.content.module.TileBase;

public abstract class TileIO
extends TileBase
implements IIO {
    protected short ioMap = (short)364;
    protected boolean saveIOMap = false;

    public TileIO(Material material) {
        super(material);
    }

    @Override
    public EnumSet<ForgeDirection> getInputDirections() {
        EnumSet<ForgeDirection> dirs = EnumSet.noneOf(ForgeDirection.class);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getIO(direction) != 1) continue;
            dirs.add(direction);
        }
        return dirs;
    }

    @Override
    public EnumSet<ForgeDirection> getOutputDirections() {
        EnumSet<ForgeDirection> dirs = EnumSet.noneOf(ForgeDirection.class);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getIO(direction) != 2) continue;
            dirs.add(direction);
        }
        return dirs;
    }

    @Override
    public void setIO(ForgeDirection dir, int type) {
        String currentIO = this.getIOMapBase3();
        StringBuilder str = new StringBuilder(currentIO);
        str.setCharAt(dir.ordinal(), Integer.toString(type).charAt(0));
        this.ioMap = Short.parseShort(str.toString(), 3);
    }

    @Override
    public int getIO(ForgeDirection dir) {
        String currentIO = this.getIOMapBase3();
        return Integer.parseInt("" + currentIO.charAt(dir.ordinal()));
    }

    public String getIOMapBase3() {
        String currentIO = Integer.toString(this.ioMap, 3);
        while (currentIO.length() < 6) {
            currentIO = "0" + currentIO;
        }
        return currentIO;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        if (this.saveIOMap && nbt.func_74764_b("ioMap")) {
            this.ioMap = nbt.func_74765_d("ioMap");
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (this.saveIOMap) {
            nbt.func_74777_a("ioMap", this.ioMap);
        }
    }
}

