/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.turbine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.HashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.lib.References;
import resonant.lib.multiblock.IMultiBlockStructure;
import resonant.lib.network.Synced;
import resonant.lib.prefab.tile.TileElectrical;
import resonant.lib.prefab.turbine.TurbineMultiBlockHandler;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.Vector3;

public abstract class TileTurbine
extends TileElectrical
implements IMultiBlockStructure<TileTurbine>,
IFluidHandler {
    protected final long energyPerSteam = 2647L;
    protected final FluidTank tank = new FluidTank(100000);
    protected final long defaultTorque = 5000L;
    protected long torque = 5000L;
    public int multiBlockRadius = 1;
    public long power = 0L;
    public float rotation = 0.0f;
    @Synced
    public int tier = 0;
    protected long maxPower;
    protected float prevAngularVelocity = 0.0f;
    @Synced(value={1})
    protected float angularVelocity = 0.0f;
    private TurbineMultiBlockHandler multiBlock;

    public TileTurbine() {
        this.setEnergyHandler(new EnergyStorageHandler(this.maxPower * 20L));
    }

    @Override
    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.func_70322_n());
    }

    @Override
    public void initiate() {
        super.initiate();
        this.setEnergyHandler(new EnergyStorageHandler(this.maxPower * 20L));
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.getMultiBlock().update();
        if (this.getMultiBlock().isPrimary()) {
            if (!this.field_70331_k.field_72995_K) {
                if (this.tank.getFluidAmount() > 0 && this.power < this.maxPower) {
                    this.power += (long)this.tank.drain((int)((int)Math.ceil((double)Math.min((double)((double)this.tank.getFluidAmount() * 0.1), (double)((double)(this.getMaxPower() / 2647L))))), (boolean)true).amount * 2647L;
                }
                this.angularVelocity = (float)((double)(this.power * 4L) / (double)this.torque);
                if (!this.field_70331_k.field_72995_K && this.ticks % 3L == 0L && this.prevAngularVelocity != this.angularVelocity) {
                    this.sendPowerUpdate();
                    this.prevAngularVelocity = this.angularVelocity;
                }
                if (this.power > 0L) {
                    this.onProduce();
                }
            }
            if (this.angularVelocity != 0.0f) {
                this.playSound();
                this.rotation = (float)((double)(this.rotation + this.angularVelocity / 20.0f) % (Math.PI * 2));
            }
        } else if (this.tank.getFluidAmount() > 0) {
            ((TileTurbine)this.getMultiBlock().get()).tank.fill(this.tank.drain(((TileTurbine)this.getMultiBlock().get()).tank.fill(this.tank.getFluid(), false), true), true);
        }
        if (!this.field_70331_k.field_72995_K) {
            this.power = 0L;
        }
    }

    protected long getMaxPower() {
        if (this.getMultiBlock().isConstructed()) {
            return this.maxPower * (long)this.getArea();
        }
        return this.maxPower;
    }

    public int getArea() {
        return (int)(((double)this.multiBlockRadius + 0.5) * 2.0 * (((double)this.multiBlockRadius + 0.5) * 2.0));
    }

    public void onProduce() {
    }

    public void playSound() {
    }

    @Override
    public Packet func_70319_e() {
        return References.PACKET_ANNOTATION.getPacket((Object)this);
    }

    public void sendPowerUpdate() {
        if (!this.world().field_72995_K) {
            References.PACKET_ANNOTATION.sync(this, 1);
        }
    }

    @Override
    public boolean canConnect(ForgeDirection direction, Object obj) {
        return this.getMultiBlock().isPrimary() && direction == ForgeDirection.UP;
    }

    @Override
    @Synced.SyncedInput
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.tank.readFromNBT(nbt);
        this.multiBlockRadius = nbt.func_74762_e("multiBlockRadius");
        this.getMultiBlock().load(nbt);
    }

    @Override
    @Synced.SyncedOutput
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.tank.writeToNBT(nbt);
        nbt.func_74768_a("multiBlockRadius", this.multiBlockRadius);
        this.getMultiBlock().save(nbt);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && this.canFill(from, resource.getFluid())) {
            return ((TileTurbine)this.getMultiBlock().get()).tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && fluid.getName().equals("steam");
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)(this.field_70329_l - this.multiBlockRadius), (double)(this.field_70330_m - this.multiBlockRadius), (double)(this.field_70327_n - this.multiBlockRadius), (double)(this.field_70329_l + 1 + this.multiBlockRadius), (double)(this.field_70330_m + 1 + this.multiBlockRadius), (double)(this.field_70327_n + 1 + this.multiBlockRadius));
    }

    @Override
    public EnumSet<ForgeDirection> getInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public EnumSet<ForgeDirection> getOutputDirections() {
        return EnumSet.of(ForgeDirection.UP);
    }

    @Override
    public Vector3[] getMultiBlockVectors() {
        HashSet<Vector3> vectors = new HashSet<Vector3>();
        ForgeDirection dir = this.getDirection();
        int xMulti = dir.offsetX != 0 ? 0 : 1;
        int yMulti = dir.offsetY != 0 ? 0 : 1;
        int zMulti = dir.offsetZ != 0 ? 0 : 1;
        for (int x = -this.multiBlockRadius; x <= this.multiBlockRadius; ++x) {
            for (int y = -this.multiBlockRadius; y <= this.multiBlockRadius; ++y) {
                for (int z = -this.multiBlockRadius; z <= this.multiBlockRadius; ++z) {
                    vectors.add(new Vector3((double)(x * xMulti), (double)(y * yMulti), (double)(z * zMulti)));
                }
            }
        }
        return vectors.toArray(new Vector3[0]);
    }

    @Override
    public Vector3 getPosition() {
        return new Vector3((TileEntity)this);
    }

    public TurbineMultiBlockHandler getMultiBlock() {
        if (this.multiBlock == null) {
            this.multiBlock = new TurbineMultiBlockHandler(this);
        }
        return this.multiBlock;
    }

    @Override
    public void onMultiBlockChanged() {
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o() != null ? this.func_70311_o().field_71990_ca : 0);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }
}

