/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.recipe;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.Configuration;

public class RecipeUtility {
    public static List<IRecipe> getRecipesByOutput(ItemStack output) {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        for (Object obj : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(obj instanceof IRecipe) || !ItemStack.func_77989_b((ItemStack)((IRecipe)obj).func_77571_b(), (ItemStack)output)) continue;
            list.add((IRecipe)obj);
        }
        return list;
    }

    public static boolean replaceRecipe(IRecipe recipe, IRecipe newRecipe) {
        for (Object obj : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(obj instanceof IRecipe) || !((IRecipe)obj).equals(recipe) && obj != recipe) continue;
            CraftingManager.func_77594_a().func_77592_b().remove(obj);
            CraftingManager.func_77594_a().func_77592_b().add(newRecipe);
            return true;
        }
        return false;
    }

    public static boolean replaceRecipe(ItemStack recipe, IRecipe newRecipe) {
        if (RecipeUtility.removeRecipe(recipe)) {
            CraftingManager.func_77594_a().func_77592_b().add(newRecipe);
            return true;
        }
        return false;
    }

    public static boolean removeRecipe(IRecipe recipe) {
        for (Object obj : CraftingManager.func_77594_a().func_77592_b()) {
            if (obj == null || !(obj instanceof IRecipe) || !((IRecipe)obj).equals(recipe) && obj != recipe) continue;
            CraftingManager.func_77594_a().func_77592_b().remove(obj);
            return true;
        }
        return false;
    }

    public static boolean removeRecipe(ItemStack stack) {
        for (Object obj : CraftingManager.func_77594_a().func_77592_b()) {
            if (obj == null || !(obj instanceof IRecipe) || ((IRecipe)obj).func_77571_b() == null || !((IRecipe)obj).func_77571_b().func_77969_a(stack)) continue;
            CraftingManager.func_77594_a().func_77592_b().remove(obj);
            return true;
        }
        return false;
    }

    public static boolean removeRecipes(ItemStack ... itemStacks) {
        boolean didRemove = false;
        Iterator itr = CraftingManager.func_77594_a().func_77592_b().iterator();
        block0: while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj == null || !(obj instanceof IRecipe) || ((IRecipe)obj).func_77571_b() == null) continue;
            for (ItemStack itemStack : itemStacks) {
                if (!((IRecipe)obj).func_77571_b().func_77969_a(itemStack)) continue;
                itr.remove();
                didRemove = true;
                continue block0;
            }
        }
        return didRemove;
    }

    public static void addRecipe(IRecipe recipe, String name, Configuration configuration, boolean defaultBoolean) {
        if (configuration != null) {
            configuration.load();
            if (configuration.get("Crafting", "Allow " + name + " Crafting", defaultBoolean).getBoolean(defaultBoolean)) {
                GameRegistry.addRecipe((IRecipe)recipe);
            }
            configuration.save();
        }
    }

    public static void addRecipe(IRecipe recipe, Configuration config, boolean defaultBoolean) {
        RecipeUtility.addRecipe(recipe, recipe.func_77571_b().func_77977_a(), config, defaultBoolean);
    }

    public static void addShaplessRecipe(ItemStack itemStack, Object[] items, String name, Configuration configuration, boolean defaultBoolean) {
        if (configuration != null) {
            configuration.load();
            if (configuration.get("Crafting", "Allow " + name + " Crafting", defaultBoolean).getBoolean(defaultBoolean)) {
                CraftingManager.func_77594_a().func_77596_b(itemStack, items);
            }
            configuration.save();
        }
    }

    public static void addShaplessRecipe(ItemStack itemStack, Object[] items, Configuration config, boolean defaultBoolean) {
        RecipeUtility.addShaplessRecipe(itemStack, items, itemStack.func_77973_b().func_77658_a(), config, defaultBoolean);
    }
}

