/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.render.block;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import resonant.api.items.ISimpleItemRenderer;
import resonant.lib.content.module.BlockDummy;
import resonant.lib.content.module.TileBlock;
import resonant.lib.render.RenderUtility;
import universalelectricity.api.vector.Vector3;

public class BlockRenderingHandler
implements ISimpleBlockRenderingHandler {
    public static final BlockRenderingHandler INSTANCE = new BlockRenderingHandler();
    public static final int ID = RenderingRegistry.getNextAvailableRenderId();
    public static final Map<Block, TileEntity> inventoryTileEntities = Maps.newIdentityHashMap();

    public TileEntity getTileEntityForBlock(Block block) {
        TileEntity te = inventoryTileEntities.get(block);
        if (te == null) {
            te = block.createTileEntity(Minecraft.func_71410_x().field_71439_g.func_130014_f_(), 0);
            inventoryTileEntities.put(block, te);
        }
        return te;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        TileBlock tile;
        if (block instanceof BlockDummy && (tile = ((BlockDummy)block).dummyTile) != null) {
            boolean didRender = true;
            GL11.glEnable((int)32826);
            GL11.glPushAttrib((int)262144);
            GL11.glPushMatrix();
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            if (tile.getRenderer() != null) {
                if (!tile.getRenderer().renderItem(new ItemStack(block, 1, metadata)) && !tile.getRenderer().renderDynamic(new Vector3(), true, 0.0f)) {
                    if (!tile.customItemRender) {
                        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                        RenderUtility.renderNormalBlockAsItem(block, metadata, renderer);
                    } else {
                        didRender = false;
                    }
                }
            } else if (!tile.customItemRender) {
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                RenderUtility.renderNormalBlockAsItem(block, metadata, renderer);
            } else {
                didRender = false;
            }
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            if (didRender) {
                return;
            }
        }
        TileEntity renderTile = null;
        if (block.hasTileEntity(metadata)) {
            renderTile = this.getTileEntityForBlock(block);
        }
        GL11.glEnable((int)32826);
        if (renderTile != null) {
            GL11.glPushAttrib((int)262144);
            GL11.glPushMatrix();
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            TileEntitySpecialRenderer tesr = TileEntityRenderer.field_76963_a.func_76956_b(renderTile);
            try {
                if (tesr instanceof ISimpleItemRenderer) {
                    ((ISimpleItemRenderer)tesr).renderInventoryItem(new ItemStack(block, 1, metadata));
                } else if (tesr != null) {
                    tesr.func_76894_a(renderTile, 0.0, 0.0, 0.0, 0.0f);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }

    public boolean renderWorldBlock(IBlockAccess access, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (block instanceof BlockDummy) {
            BlockDummy dummy = (BlockDummy)block;
            dummy.inject(access, x, y, z);
            TileBlock tileBlock = dummy.getTile(access, x, y, z);
            if (tileBlock != null) {
                tileBlock.access = access;
                if (tileBlock.getRenderer() != null) {
                    if (!tileBlock.getRenderer().renderStatic(renderer, new Vector3((double)x, (double)y, (double)z))) {
                        renderer.func_78570_q(block, x, y, z);
                    }
                } else if (tileBlock.normalRender || tileBlock.forceStandardRender) {
                    renderer.func_78570_q(block, x, y, z);
                }
            }
            return true;
        }
        return false;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return ID;
    }
}

