/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.science.units;

public enum ImperialUnits {
    thou("thou", "th", 0.0f),
    inch("inch", "in", 0.0f),
    foot("foot", "ft", 1.0f),
    yard("yard", "yd", 3.0f),
    chain("chain", "ch", 66.0f),
    furlong("furlong", "fur", 660.0f),
    mile("mile", "mi", 5280.0f),
    league("league", "lea", 15840.0f),
    fathom("fathom", "ftm", 6.08f),
    cable("cable", "", 608.0f),
    nautical("nautical mile", "", 6080.0f),
    link("link", "", 0.0f),
    rod("rod", "", 16.0f);

    public String name;
    public String symbol;
    float toFeet;
    public static final ImperialUnits[] mainUnits;

    private ImperialUnits(String name, String symbol, float toFeet) {
        this.name = name;
        this.symbol = symbol;
        this.toFeet = toFeet;
    }

    public static float convert(ImperialUnits a, ImperialUnits b, float value) {
        value *= a.toFeet;
        return value /= b.toFeet;
    }

    public float convert(ImperialUnits unit, float value) {
        return ImperialUnits.convert(this, unit, value);
    }

    static {
        mainUnits = new ImperialUnits[]{inch, foot, yard, mile};
    }
}

