/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.science.units;

import java.util.ArrayList;
import java.util.List;
import resonant.lib.science.units.ImperialUnits;
import resonant.lib.science.units.MetricUnit;
import resonant.lib.type.Pair;

public class UnitHelper {
    public static final float FEET_TO_METERS = 0.3048f;
    public static final float METERS_TO_FEET = 3.28084f;
    public static List<Character> numbers = new ArrayList<Character>();

    public float convert(ImperialUnits a, MetricUnit b, float value) {
        return b.convert(MetricUnit.BASE, a.convert(ImperialUnits.foot, value) * 0.3048f);
    }

    public float convert(MetricUnit a, ImperialUnits b, float value) {
        return b.convert(ImperialUnits.foot, a.convert(MetricUnit.BASE, value) * 3.28084f);
    }

    public Pair<Object, Float> parseString(String input) {
        Pair<Object, Float> def = null;
        if (input != null && !input.isEmpty()) {
            char c;
            String editedString = input;
            char[] chars = input.toCharArray();
            Object unitEnumValue = null;
            String numberAsString = "";
            float number = 0.0f;
            String units = "";
            int toPowerOf = 1;
            int timeTenToPowerOF = 1;
            for (int i = 0; i < chars.length && numbers.contains(Character.valueOf(c = chars[i])); ++i) {
                numberAsString = numberAsString + c;
            }
            try {
                number = Float.parseFloat(numberAsString);
            }
            catch (Exception e) {
                // empty catch block
            }
            editedString.replaceAll("[0-9]", "");
            chars = editedString.toCharArray();
            if (chars != null) {
                if (chars.length >= 5 && chars[0] == 'x' && chars[1] == '1' && chars[2] == '0' && chars[3] == '^' && numbers.contains(Character.valueOf(chars[4]))) {
                    timeTenToPowerOF = Integer.parseInt("" + chars[4], 1);
                    editedString = editedString.substring(5);
                } else if (chars.length >= 2 && chars[0] == '^' && numbers.contains(Character.valueOf(chars[1]))) {
                    toPowerOf = Integer.parseInt("" + chars[1], 1);
                    editedString = editedString.substring(2);
                }
            }
            return new Pair<Object, Float>(unitEnumValue, Float.valueOf(number));
        }
        return def;
    }

    public static int tryToParseInt(Object var, int suggestValue) {
        if (var instanceof String) {
            try {
                return Integer.parseInt((String)var);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (var instanceof Integer || var instanceof Float || var instanceof Double || var instanceof Long) {
            return (Integer)var;
        }
        return suggestValue;
    }

    public static int tryToParseInt(Object var) {
        return UnitHelper.tryToParseInt(var, 0);
    }

    public static Double tryToParseDouble(Object var, double suggestValue) {
        if (var instanceof String) {
            try {
                return Double.parseDouble((String)var);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (var instanceof Integer || var instanceof Float || var instanceof Double) {
            return (Double)var;
        }
        return suggestValue;
    }

    public static Double tryToParseDouble(Object var) {
        return UnitHelper.tryToParseDouble(var, 0.0);
    }

    public static Float tryToParseFloat(Object var, float suggestValue) {
        if (var instanceof String) {
            try {
                return Float.valueOf(Float.parseFloat((String)var));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (var instanceof Integer || var instanceof Float || var instanceof Double) {
            return (Float)var;
        }
        return Float.valueOf(suggestValue);
    }

    public static Float tryToParseFloat(Object var) {
        return UnitHelper.tryToParseFloat(var, 0.0f);
    }

    static {
        numbers.add(Character.valueOf('0'));
        numbers.add(Character.valueOf('1'));
        numbers.add(Character.valueOf('2'));
        numbers.add(Character.valueOf('3'));
        numbers.add(Character.valueOf('4'));
        numbers.add(Character.valueOf('5'));
        numbers.add(Character.valueOf('6'));
        numbers.add(Character.valueOf('7'));
        numbers.add(Character.valueOf('8'));
        numbers.add(Character.valueOf('9'));
    }
}

