/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.thermal;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import resonant.lib.type.Pair;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.IVectorWorld;

public class HeatingDictionary {
    private static HashMap<Block, Float> blockToHeatMap = new HashMap();
    private static HashMap<Integer, Float> idToHeatMap = new HashMap();
    private static HashMap<Pair<Integer, Integer>, Float> idMetaToHeatMap = new HashMap();
    private static HashMap<Material, Float> materialToHeatMap = new HashMap();

    public static void register(Block block, float f) {
        if (block != null && f > 0.0f) {
            blockToHeatMap.put(block, Float.valueOf(f));
        }
    }

    public static void register(int id, float f) {
        if (Block.field_71973_m[id] != null && f > 0.0f) {
            idToHeatMap.put(id, Float.valueOf(f));
        }
    }

    public static void register(int id, int meta, float f) {
        if (Block.field_71973_m[id] != null && f > 0.0f) {
            idMetaToHeatMap.put(new Pair<Integer, Integer>(id, meta), Float.valueOf(f));
        }
    }

    public static void register(Material m, float f) {
        if (m != null && f > 0.0f) {
            materialToHeatMap.put(m, Float.valueOf(f));
        }
    }

    public static float getSpecificHeat(IVectorWorld vec) {
        return HeatingDictionary.getSpecificHeat(vec.world(), (int)vec.x(), (int)vec.y(), (int)vec.z());
    }

    public static float getSpecificHeat(World world, IVector3 vec) {
        return HeatingDictionary.getSpecificHeat(world, (int)vec.x(), (int)vec.y(), (int)vec.z());
    }

    public static float getSpecificHeat(World world, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        int meta = world.func_72805_g(x, y, z);
        if (block != null) {
            if (blockToHeatMap.containsKey(block)) {
                return blockToHeatMap.get(block).floatValue();
            }
            if (idToHeatMap.containsKey(block.field_71990_ca)) {
                return idToHeatMap.get(block.field_71990_ca).floatValue();
            }
            if (idMetaToHeatMap.containsKey(new Pair<Integer, Integer>(block.field_71990_ca, meta))) {
                return idMetaToHeatMap.get(new Pair<Integer, Integer>(block.field_71990_ca, meta)).floatValue();
            }
            if (materialToHeatMap.containsKey(block.field_72018_cp)) {
                return materialToHeatMap.get(block.field_72018_cp).floatValue();
            }
        }
        return 5.0f;
    }

    static {
        HeatingDictionary.register(Material.field_76243_f, 0.45f);
        HeatingDictionary.register(Material.field_76249_a, 1.0f);
        HeatingDictionary.register(Material.field_76247_b, 0.84f);
        HeatingDictionary.register(Material.field_76248_c, 0.9f);
        HeatingDictionary.register(Material.field_76245_d, 0.84f);
        HeatingDictionary.register(Material.field_76246_e, 0.8f);
        HeatingDictionary.register(Material.field_82717_g, 0.5f);
        HeatingDictionary.register(Material.field_76244_g, 1.0f);
        HeatingDictionary.register(Material.field_76256_h, 0.84f);
        HeatingDictionary.register(Material.field_76257_i, 0.84f);
        HeatingDictionary.register(Material.field_76254_j, 0.84f);
        HeatingDictionary.register(Material.field_76255_k, 0.84f);
        HeatingDictionary.register(Material.field_76252_l, 0.84f);
        HeatingDictionary.register(Material.field_76253_m, 2.0f);
        HeatingDictionary.register(Material.field_76250_n, 1.0f);
        HeatingDictionary.register(Material.field_76251_o, 1.0f);
        HeatingDictionary.register(Material.field_76265_p, 1.0f);
        HeatingDictionary.register(Material.field_111018_r, 2.0f);
        HeatingDictionary.register(Material.field_76264_q, 0.84f);
        HeatingDictionary.register(Material.field_76263_r, 0.9f);
        HeatingDictionary.register(Material.field_76262_s, 2.0f);
        HeatingDictionary.register(Material.field_76261_t, 0.84f);
        HeatingDictionary.register(Material.field_76260_u, 1.0f);
        HeatingDictionary.register(Material.field_76259_v, 1.0f);
        HeatingDictionary.register(Material.field_76258_w, 1.0f);
        HeatingDictionary.register(Material.field_76268_x, 0.84f);
        HeatingDictionary.register(Material.field_76267_y, 0.92f);
        HeatingDictionary.register(Material.field_76266_z, 0.84f);
        HeatingDictionary.register(Material.field_76236_A, 0.84f);
        HeatingDictionary.register(Material.field_76237_B, 1.0f);
        HeatingDictionary.register(Material.field_76238_C, 2.0f);
        HeatingDictionary.register(Material.field_76232_D, 0.84f);
        HeatingDictionary.register(Material.field_76233_E, 0.9f);
    }
}

