/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.thermal;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import resonant.api.IReactor;
import resonant.core.ResonantEngine;
import resonant.lib.thermal.EventThermal;
import resonant.lib.thermal.ThermalPhysics;
import universalelectricity.api.net.IUpdate;
import universalelectricity.api.vector.VectorWorld;

public class ThermalGrid
implements IUpdate {
    private final float spread = 0.14285715f;
    private final float loss = 0.1f;
    private static final HashMap<VectorWorld, Float> thermalSource = new HashMap();
    private int tick = 0;
    private final float deltaTime = 0.05f;

    public static float getDefaultTemperature(VectorWorld position) {
        return ThermalPhysics.getTemperatureForCoordinate(position.world, position.intX(), position.intZ());
    }

    public static void addTemperature(VectorWorld position, float deltaTemperature) {
        float defaultTemperature = ThermalGrid.getDefaultTemperature(position);
        float original = thermalSource.containsKey(position) ? thermalSource.get(position).floatValue() : defaultTemperature;
        float newTemperature = original + deltaTemperature;
        if ((double)Math.abs(newTemperature - defaultTemperature) > 0.4) {
            thermalSource.put(position, Float.valueOf(original + deltaTemperature));
        } else {
            thermalSource.remove(position);
        }
    }

    public static float getTemperature(VectorWorld position) {
        if (thermalSource.containsKey(position)) {
            return thermalSource.get(position).floatValue();
        }
        return ThermalPhysics.getTemperatureForCoordinate(position.world, position.intX(), position.intZ());
    }

    public void update() {
        for (Map.Entry<VectorWorld, Float> entry : new HashMap<VectorWorld, Float>(thermalSource).entrySet()) {
            VectorWorld pos = entry.getKey();
            float currentTemperature = ThermalGrid.getTemperature(pos);
            if (currentTemperature < 0.0f) {
                thermalSource.remove(pos);
                continue;
            }
            float deltaFromEquilibrium = ThermalGrid.getDefaultTemperature(pos) - currentTemperature;
            TileEntity possibleReactor = pos.getTileEntity();
            boolean isReactor = false;
            isReactor = possibleReactor != null && possibleReactor instanceof IReactor;
            EventThermal.EventThermalUpdate evt = new EventThermal.EventThermalUpdate(pos, currentTemperature, deltaFromEquilibrium, 0.05f, isReactor);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            float loss = evt.heatLoss;
            ThermalGrid.addTemperature(pos, (float)(deltaFromEquilibrium > 0.0f ? 1 : -1) * Math.min(Math.abs(deltaFromEquilibrium), Math.abs(loss)));
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                VectorWorld adjacent = (VectorWorld)pos.clone().translate(dir);
                float deltaTemperature = ThermalGrid.getTemperature(pos) - ThermalGrid.getTemperature(adjacent);
                Material adjacentMat = adjacent.world.func_72803_f(adjacent.intX(), adjacent.intY(), adjacent.intZ());
                float spread = (adjacentMat.func_76220_a() ? this.spread : this.spread / 2.0f) * 0.05f;
                if (!(deltaTemperature > 0.0f)) continue;
                ThermalGrid.addTemperature(adjacent, deltaTemperature * spread);
                ThermalGrid.addTemperature(pos, -deltaTemperature * spread);
            }
        }
    }

    public boolean canUpdate() {
        return !ResonantEngine.proxy.isPaused();
    }

    public boolean continueUpdate() {
        return true;
    }
}

