/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.utility;

import com.google.common.base.CaseFormat;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;

public class LanguageUtility {
    public static int loadLanguages(String languagePath, String[] languageSupported) {
        int languages = 0;
        for (String language : languageSupported) {
            LanguageRegistry.instance().loadLocalization(languagePath + language + ".properties", language, false);
            if (LanguageRegistry.instance().getStringLocalization("children", language) != "") {
                try {
                    String[] children;
                    for (String child : children = LanguageRegistry.instance().getStringLocalization("children", language).split(",")) {
                        if (child == "" && child == null) continue;
                        LanguageRegistry.instance().loadLocalization(languagePath + language + ".properties", child, false);
                        ++languages;
                    }
                }
                catch (Exception e) {
                    FMLLog.severe((String)"Failed to load a child language file.", (Object[])new Object[0]);
                    e.printStackTrace();
                }
            }
            ++languages;
        }
        return languages;
    }

    public static String getLocal(String key) {
        String text = null;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            text = LanguageRegistry.instance().getStringLocalization(key);
        }
        if (text == null || text == "") {
            text = LanguageRegistry.instance().getStringLocalization(key, "en_US");
        }
        return text;
    }

    public static List<String> splitStringPerWord(String string, int wordsPerLine) {
        String[] words = string.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        int lineCount = 0;
        while ((double)lineCount < Math.ceil((float)words.length / (float)wordsPerLine)) {
            String stringInLine = "";
            for (int i = lineCount * wordsPerLine; i < Math.min(wordsPerLine + lineCount * wordsPerLine, words.length); ++i) {
                stringInLine = stringInLine + words[i] + " ";
            }
            lines.add(stringInLine.trim());
            ++lineCount;
        }
        return lines;
    }

    public static List<Integer> decodeIDSplitByComma(String string) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        if (string != null) {
            for (String IDString : string.split(",")) {
                if (IDString == null || IDString.isEmpty()) continue;
                try {
                    int contentID = Integer.parseInt(IDString);
                    intList.add(contentID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return intList;
    }

    public static String capitalizeFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String decapitalizeFirst(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String toCamelCase(String s) {
        return LanguageUtility.decapitalizeFirst(LanguageUtility.toPascalCase(s));
    }

    public static String toPascalCase(String s) {
        String[] parts = s.split("_");
        String camelCaseString = "";
        for (String part : parts) {
            camelCaseString = camelCaseString + LanguageUtility.toProperCase(part);
        }
        return camelCaseString;
    }

    public static String camelToLowerUnderscore(String s) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, s);
    }

    public static String underscoreToCamel(String s) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, s);
    }

    public static String toProperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }
}

