/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.utility.inventory;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import resonant.lib.recipe.RecipeUtility;
import resonant.lib.type.Pair;
import resonant.lib.utility.inventory.InventoryUtility;

public class AutoCraftingManager {
    static boolean doDebug = false;
    TileEntity craftingEntity;
    IInventory craftingInv;

    public AutoCraftingManager(IAutoCrafter entity) {
        this.craftingEntity = (TileEntity)entity;
        if (entity instanceof IInventory) {
            this.craftingInv = (IInventory)entity;
        }
    }

    public AutoCraftingManager(IAutoCrafter entity, IInventory inv) {
        this(entity);
        if (inv != null) {
            this.craftingInv = inv;
        }
    }

    public void printDebug(String pre, String msg) {
        if (doDebug) {
            System.out.println("[AutoCrafter]: " + pre + " > " + msg);
        }
    }

    public static void printRecipe(Object[] objects) {
        for (Object obj : objects) {
            System.out.println(obj);
        }
    }

    public static void printRecipes(ItemStack stack) {
        List<IRecipe> recipes = RecipeUtility.getRecipesByOutput(stack);
        for (IRecipe recipe : recipes) {
            ShapedOreRecipe oreRecipe;
            if (recipe.func_77571_b() == null || !AutoCraftingManager.areStacksEqual(recipe.func_77571_b(), stack)) continue;
            if (recipe instanceof ShapedRecipes) {
                AutoCraftingManager.printRecipe(((ShapedRecipes)recipe).field_77574_d);
                continue;
            }
            if (recipe instanceof ShapelessRecipes) {
                AutoCraftingManager.printRecipe(((ShapelessRecipes)recipe).field_77579_b.toArray(new Object[1]));
                continue;
            }
            if (recipe instanceof ShapedOreRecipe) {
                oreRecipe = (ShapedOreRecipe)recipe;
                AutoCraftingManager.printRecipe((Object[])ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)oreRecipe, (String[])new String[]{"input"}));
                continue;
            }
            if (!(recipe instanceof ShapelessOreRecipe)) continue;
            oreRecipe = (ShapelessOreRecipe)recipe;
            ArrayList oreRecipeInput = (ArrayList)ReflectionHelper.getPrivateValue(ShapelessOreRecipe.class, (Object)oreRecipe, (String[])new String[]{"input"});
            for (Object obj : oreRecipeInput) {
                System.out.println(obj);
            }
        }
    }

    public Pair<ItemStack, ItemStack[]> getIdealRecipe(ItemStack outputItem) {
        this.printDebug("IdealRecipe", outputItem.toString());
        for (IRecipe object : RecipeUtility.getRecipesByOutput(outputItem)) {
            ArrayList<ItemStack> hasResources;
            Object oreRecipeInput;
            ShapedOreRecipe oreRecipe;
            if (!AutoCraftingManager.areStacksEqual(outputItem, object.func_77571_b())) continue;
            this.printDebug("IdealRecipe", "Output Match Found");
            if (object instanceof ShapedRecipes) {
                if (this.hasResource(((ShapedRecipes)object).field_77574_d) == null) continue;
                this.printDebug("IdealRecipe", "Shaped Recipe Found");
                return new Pair<ItemStack, ItemStack[]>(object.func_77571_b().func_77946_l(), ((ShapedRecipes)object).field_77574_d);
            }
            if (object instanceof ShapelessRecipes) {
                if (this.hasResource(((ShapelessRecipes)object).field_77579_b.toArray(new ItemStack[1])) == null) continue;
                this.printDebug("IdealRecipe", "Shapeless Recipe Found");
                return new Pair<ItemStack, ItemStack[]>(object.func_77571_b().func_77946_l(), ((ShapelessRecipes)object).field_77579_b.toArray(new ItemStack[1]));
            }
            if (object instanceof ShapedOreRecipe) {
                oreRecipe = (ShapedOreRecipe)object;
                oreRecipeInput = (Object[])ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)oreRecipe, (String[])new String[]{"input"});
                hasResources = this.hasResource((Object[])oreRecipeInput);
                if (hasResources == null) continue;
                this.printDebug("IdealRecipe", "ShapedOre Recipe Found");
                return new Pair<ItemStack, ItemStack[]>(object.func_77571_b().func_77946_l(), hasResources.toArray(new ItemStack[1]));
            }
            if (!(object instanceof ShapelessOreRecipe)) continue;
            oreRecipe = (ShapelessOreRecipe)object;
            oreRecipeInput = (ArrayList)ReflectionHelper.getPrivateValue(ShapelessOreRecipe.class, (Object)oreRecipe, (String[])new String[]{"input"});
            hasResources = this.hasResource(((ArrayList)oreRecipeInput).toArray());
            if (hasResources == null) continue;
            this.printDebug("IdealRecipe", "ShapelessOre Recipe Found");
            return new Pair<ItemStack, ItemStack[]>(object.func_77571_b().func_77946_l(), hasResources.toArray(new ItemStack[1]));
        }
        return null;
    }

    public static ItemStack[] getReverseRecipe(ItemStack outputItem, int outputSize) {
        for (Object object : CraftingManager.func_77594_a().func_77592_b()) {
            ShapedOreRecipe oreRecipe;
            if (!(object instanceof IRecipe) || ((IRecipe)object).func_77571_b() == null || !((IRecipe)object).func_77571_b().func_77969_a(outputItem) || outputSize != -1 && ((IRecipe)object).func_77571_b().field_77994_a != outputItem.field_77994_a) continue;
            if (object instanceof ShapedRecipes) {
                return (ItemStack[])((ShapedRecipes)object).field_77574_d.clone();
            }
            if (object instanceof ShapelessRecipes) {
                return (ItemStack[])((ShapelessRecipes)object).field_77579_b.toArray(new ItemStack[9]).clone();
            }
            if (object instanceof ShapedOreRecipe) {
                oreRecipe = (ShapedOreRecipe)object;
                Object[] recipeItems = (Object[])ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)oreRecipe, (String[])new String[]{"input"});
                if (recipeItems == null) continue;
                ItemStack[] actualResources = new ItemStack[recipeItems.length];
                block1: for (int i = 0; i < recipeItems.length; ++i) {
                    if (recipeItems[i] instanceof ItemStack) {
                        actualResources[i] = ((ItemStack)recipeItems[i]).func_77946_l();
                        continue;
                    }
                    if (!(recipeItems[i] instanceof ArrayList)) continue;
                    Object[] ingredientsArray = ((ArrayList)recipeItems[i]).toArray();
                    for (int x = 0; x < ingredientsArray.length; ++x) {
                        if (ingredientsArray[x] == null || !(ingredientsArray[x] instanceof ItemStack)) continue;
                        actualResources[i] = ((ItemStack)ingredientsArray[x]).func_77946_l();
                        continue block1;
                    }
                }
                return actualResources;
            }
            if (!(object instanceof ShapelessOreRecipe)) continue;
            oreRecipe = (ShapelessOreRecipe)object;
            return (ItemStack[])((ArrayList)ReflectionHelper.getPrivateValue(ShapelessOreRecipe.class, (Object)oreRecipe, (String[])new String[]{"input"})).toArray(new ItemStack[9]).clone();
        }
        return null;
    }

    public ItemStack[] getInvItems(IInventory inv, int ... slots) {
        ItemStack[] containingItems = new ItemStack[slots.length];
        for (int slot = 0; slot < slots.length; ++slot) {
            if (inv.func_70301_a(slots[slot]) == null) continue;
            containingItems[slot] = inv.func_70301_a(slots[slot]).func_77946_l();
        }
        return containingItems;
    }

    public ArrayList<ItemStack> hasResource(Object[] recipeItems) {
        try {
            ItemStack[] containingItems = this.getInvItems(this.craftingInv, ((IAutoCrafter)this.craftingEntity).getCraftingInv());
            this.printDebug("ResourceChecker", "Looking for items");
            for (int i = 0; i < recipeItems.length && doDebug; ++i) {
                this.printDebug("ResourceChecker", "Looking for " + recipeItems.toString());
            }
            ArrayList<ItemStack> actualResources = new ArrayList<ItemStack>();
            int itemMatch = 0;
            int itemInList = 0;
            block3: for (Object obj : recipeItems) {
                ++itemInList;
                if (obj instanceof ItemStack) {
                    ItemStack recipeItem = (ItemStack)obj;
                    actualResources.add(recipeItem.func_77946_l());
                    if (recipeItem == null) continue;
                    this.printDebug("ResourceChecker", "Item0" + itemInList + " = " + recipeItem.toString());
                    int match = this.doesItemExist(recipeItem, containingItems);
                    if (match < 0) continue;
                    containingItems[match] = InventoryUtility.decrStackSize(containingItems[match], recipeItem.field_77994_a);
                    this.printDebug("ResourceChecker", "Match found @" + match);
                    ++itemMatch;
                    continue;
                }
                if (obj instanceof ArrayList) {
                    ArrayList ingredientsList = (ArrayList)obj;
                    Object[] ingredientsArray = ingredientsList.toArray();
                    this.printDebug("ResourceChecker", "Obj0" + itemInList + " = " + obj.toString());
                    for (int x = 0; x < ingredientsArray.length; ++x) {
                        int match;
                        if (ingredientsArray[x] == null || !(ingredientsArray[x] instanceof ItemStack)) continue;
                        ItemStack recipeItem = (ItemStack)ingredientsArray[x];
                        actualResources.add(recipeItem.func_77946_l());
                        if (recipeItem == null || (match = this.doesItemExist(recipeItem, containingItems)) < 0) continue;
                        containingItems[match] = InventoryUtility.decrStackSize(containingItems[match], recipeItem.field_77994_a);
                        this.printDebug("ResourceChecker", "Match found @" + match);
                        ++itemMatch;
                        continue block3;
                    }
                    continue;
                }
                this.printDebug("ResourceChecker", "Item0" + itemInList + " = null");
            }
            boolean resourcesFound = itemMatch >= actualResources.size();
            this.printDebug("ResourceChecker", actualResources.size() + " items needed and " + itemMatch + " valid matches found");
            this.printDebug("ResourceChecker", "has all resources been found? /n A: " + resourcesFound);
            return resourcesFound ? actualResources : null;
        }
        catch (Exception e) {
            System.out.println("Failed to find recipes in the imprinter.");
            e.printStackTrace();
            return null;
        }
    }

    private int doesItemExist(ItemStack recipeItem, ItemStack[] containingItems) {
        if (recipeItem == null || recipeItem.field_77993_c == 0 || recipeItem.field_77994_a <= 0) {
            return -1;
        }
        this.printDebug("ResourceChecker", "Checking inv for item " + recipeItem.toString());
        for (int i = 0; i < containingItems.length; ++i) {
            ItemStack checkStack = containingItems[i];
            if (checkStack == null) continue;
            this.printDebug("ResourceChecker", " -----Item in slot0" + i + " = " + checkStack.toString());
            if (!AutoCraftingManager.areStacksEqual(recipeItem, checkStack)) continue;
            this.printDebug("ResourceChecker", "Found matching item " + checkStack.toString());
            return i;
        }
        return -2;
    }

    public static boolean areStacksEqual(ItemStack recipeItem, ItemStack checkStack) {
        if (recipeItem == null || checkStack == null) {
            return false;
        }
        if (recipeItem.field_77993_c < Block.field_71973_m.length && recipeItem.func_77960_j() == Short.MAX_VALUE) {
            return recipeItem.field_77993_c == checkStack.field_77993_c;
        }
        if (recipeItem.func_77984_f()) {
            return !recipeItem.func_77951_h() && recipeItem.field_77993_c == checkStack.field_77993_c;
        }
        return recipeItem.func_77969_a(checkStack);
    }

    public static ItemStack consumeItem(ItemStack itemStack, int amount) {
        ItemStack containerStack;
        if (itemStack == null) {
            return null;
        }
        ItemStack stack = itemStack.func_77946_l();
        if (stack.func_77973_b() instanceof ItemBucket && stack.field_77993_c != Item.field_77788_aw.field_77779_bT) {
            return new ItemStack(Item.field_77788_aw, 1);
        }
        if (stack.func_77973_b().func_77634_r() && (containerStack = stack.func_77973_b().getContainerItemStack(stack)) != null && !stack.func_77973_b().func_77630_h(stack)) {
            return containerStack;
        }
        return InventoryUtility.decrStackSize(stack, amount);
    }

    public boolean consumeItems(ItemStack ... requiredItems) {
        return this.consumeItems(true, requiredItems);
    }

    public boolean consumeItems(boolean doConsume, ItemStack ... requiredItems) {
        if (requiredItems != null) {
            int count = 0;
            for (ItemStack searchStack : requiredItems) {
                if (searchStack == null) continue;
                int[] invSlots = ((IAutoCrafter)this.craftingEntity).getCraftingInv();
                for (int i = 0; i < invSlots.length; ++i) {
                    ItemStack checkStack = this.craftingInv.func_70301_a(invSlots[i]);
                    if (checkStack == null || !AutoCraftingManager.areStacksEqual(searchStack, checkStack)) continue;
                    if (doConsume) {
                        this.craftingInv.func_70299_a(invSlots[i], AutoCraftingManager.consumeItem(checkStack, 1));
                    }
                    ++count;
                }
            }
            return count >= requiredItems.length;
        }
        return false;
    }

    public static interface IAutoCrafter {
        public int[] getCraftingInv();
    }
}

