/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import resonant.api.IMechanicalNode;
import resonant.core.content.debug.BlockCreativeBuilder;
import resonant.lib.content.ContentRegistry;
import resonant.lib.grid.NodeRegistry;
import resonant.lib.network.PacketAnnotation;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.item.ItemBlockMetadata;
import resonant.lib.recipe.UniversalRecipe;
import resonant.lib.schematic.Schematic;
import resonantinduction.core.Settings;
import resonantinduction.core.TabRI;
import resonantinduction.mechanical.CommonProxy;
import resonantinduction.mechanical.MicroblockHighlightHandler;
import resonantinduction.mechanical.MultipartMechanical;
import resonantinduction.mechanical.belt.BlockConveyorBelt;
import resonantinduction.mechanical.belt.TileConveyorBelt;
import resonantinduction.mechanical.energy.grid.MechanicalNode;
import resonantinduction.mechanical.energy.turbine.BlockWaterTurbine;
import resonantinduction.mechanical.energy.turbine.BlockWindTurbine;
import resonantinduction.mechanical.energy.turbine.SchematicWaterTurbine;
import resonantinduction.mechanical.energy.turbine.SchematicWindTurbine;
import resonantinduction.mechanical.energy.turbine.TileWaterTurbine;
import resonantinduction.mechanical.energy.turbine.TileWindTurbine;
import resonantinduction.mechanical.fluid.pipe.EnumPipeMaterial;
import resonantinduction.mechanical.fluid.pipe.ItemPipe;
import resonantinduction.mechanical.fluid.transport.TilePump;
import resonantinduction.mechanical.gear.ItemGear;
import resonantinduction.mechanical.gearshaft.ItemGearShaft;
import resonantinduction.mechanical.logistic.belt.BlockDetector;
import resonantinduction.mechanical.logistic.belt.BlockManipulator;
import resonantinduction.mechanical.logistic.belt.TileDetector;
import resonantinduction.mechanical.logistic.belt.TileManipulator;
import resonantinduction.mechanical.logistic.belt.TileSorter;
import resonantinduction.mechanical.process.crusher.TileMechanicalPiston;
import resonantinduction.mechanical.process.edit.TileBreaker;
import resonantinduction.mechanical.process.edit.TilePlacer;
import resonantinduction.mechanical.process.grinder.TileGrindingWheel;
import resonantinduction.mechanical.process.purifier.TileMixer;

@Mod(modid="ResonantInduction|Mechanical", name="Resonant Induction Mechanical", version="0.3.1", dependencies="before:ThermalExpansion;required-after:ResonantInduction|Core;after:ResonantInduction|Archaic")
@NetworkMod(channels={"resonindc"}, clientSideRequired=true, serverSideRequired=false, packetHandler=PacketHandler.class)
public class Mechanical {
    public static final String ID = "ResonantInduction|Mechanical";
    public static final String NAME = "Resonant Induction Mechanical";
    @Mod.Instance(value="ResonantInduction|Mechanical")
    public static Mechanical INSTANCE;
    @SidedProxy(clientSide="resonantinduction.mechanical.ClientProxy", serverSide="resonantinduction.mechanical.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Metadata(value="ResonantInduction|Mechanical")
    public static ModMetadata metadata;
    public static final ContentRegistry contentRegistry;
    public static Item itemGear;
    public static Item itemGearShaft;
    public static Block blockWindTurbine;
    public static Block blockWaterTurbine;
    public static Block blockConveyorBelt;
    public static Block blockManipulator;
    public static Block blockDetector;
    public static Block blockSorter;
    public static Block blockReleaseValve;
    public static Block blockPump;
    public static Item itemPipe;
    public static Block blockGrinderWheel;
    public static Block blockMixer;
    public static Block blockMechanicalPiston;
    public static Block blockTileBreaker;
    public static Block blockTilePlacer;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new MicroblockHighlightHandler());
        BlockCreativeBuilder.register((Schematic)new SchematicWindTurbine());
        BlockCreativeBuilder.register((Schematic)new SchematicWaterTurbine());
        NodeRegistry.register(IMechanicalNode.class, MechanicalNode.class);
        Settings.CONFIGURATION.load();
        itemGear = contentRegistry.createItem(ItemGear.class);
        itemGearShaft = contentRegistry.createItem(ItemGearShaft.class);
        blockWindTurbine = contentRegistry.createBlock(BlockWindTurbine.class, ItemBlockMetadata.class, TileWindTurbine.class);
        blockWaterTurbine = contentRegistry.createBlock(BlockWaterTurbine.class, ItemBlockMetadata.class, TileWaterTurbine.class);
        blockConveyorBelt = contentRegistry.createTile(BlockConveyorBelt.class, TileConveyorBelt.class);
        blockManipulator = contentRegistry.createTile(BlockManipulator.class, TileManipulator.class);
        blockDetector = contentRegistry.createTile(BlockDetector.class, TileDetector.class);
        blockSorter = contentRegistry.newBlock(TileSorter.class);
        blockPump = contentRegistry.newBlock(TilePump.class);
        itemPipe = contentRegistry.createItem(ItemPipe.class);
        blockGrinderWheel = contentRegistry.newBlock(TileGrindingWheel.class);
        blockMixer = contentRegistry.newBlock(TileMixer.class);
        blockMechanicalPiston = contentRegistry.newBlock(TileMechanicalPiston.class);
        OreDictionary.registerOre((String)"gear", (Item)itemGear);
        blockTileBreaker = contentRegistry.newBlock(TileBreaker.class);
        blockTilePlacer = contentRegistry.newBlock(TilePlacer.class);
        proxy.preInit();
        Settings.CONFIGURATION.save();
        TabRI.ITEMSTACK = new ItemStack(blockGrinderWheel);
        PacketAnnotation.register(TileWindTurbine.class);
        PacketAnnotation.register(TileWaterTurbine.class);
        PacketAnnotation.register(TileSorter.class);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        MultipartMechanical.INSTANCE = new MultipartMechanical();
        Settings.setModMetadata((ModMetadata)metadata, (String)ID, (String)NAME, (String)"ResonantInduction|Core");
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemGear, 1, 0), new Object[]{"SWS", "W W", "SWS", Character.valueOf('W'), "plankWood", Character.valueOf('S'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemGear, 1, 1), new Object[]{" W ", "WGW", " W ", Character.valueOf('G'), new ItemStack(itemGear, 1, 0), Character.valueOf('W'), Block.field_71978_w}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemGear, 1, 2), new Object[]{" W ", "WGW", " W ", Character.valueOf('G'), new ItemStack(itemGear, 1, 1), Character.valueOf('W'), Item.field_77703_o}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemGearShaft, 1, 0), new Object[]{"S", "S", "S", Character.valueOf('S'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemGearShaft, 1, 1), new Object[]{"S", "G", "S", Character.valueOf('G'), new ItemStack(itemGearShaft, 1, 0), Character.valueOf('S'), Block.field_71978_w}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemGearShaft, 1, 2), new Object[]{"S", "G", "S", Character.valueOf('G'), new ItemStack(itemGearShaft, 1, 1), Character.valueOf('S'), Item.field_77703_o}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockConveyorBelt, 4), new Object[]{"III", "GGG", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('G'), itemGear}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockManipulator, new Object[]{"SSS", "SRS", "SCS", Character.valueOf('S'), Item.field_77703_o, Character.valueOf('C'), blockConveyorBelt, Character.valueOf('R'), Block.field_94341_cq}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockDetector, new Object[]{"SWS", "SRS", "SWS", Character.valueOf('S'), Item.field_77703_o, Character.valueOf('W'), UniversalRecipe.WIRE.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockSorter, new Object[]{"SSS", "SPS", "SRS", Character.valueOf('P'), Block.field_71956_V, Character.valueOf('S'), Item.field_77703_o, Character.valueOf('R'), Block.field_94341_cq}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockWindTurbine, 1, 0), new Object[]{"CWC", "WGW", "CWC", Character.valueOf('G'), itemGear, Character.valueOf('C'), Block.field_72101_ab, Character.valueOf('W'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockWindTurbine, 1, 1), new Object[]{"CWC", "WGW", "CWC", Character.valueOf('G'), new ItemStack(blockWindTurbine, 1, 0), Character.valueOf('C'), Block.field_71981_t, Character.valueOf('W'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockWindTurbine, 1, 2), new Object[]{"CWC", "WGW", "CWC", Character.valueOf('G'), new ItemStack(blockWindTurbine, 1, 1), Character.valueOf('C'), Item.field_77703_o, Character.valueOf('W'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockWaterTurbine, 1, 0), new Object[]{"SWS", "WGW", "SWS", Character.valueOf('G'), itemGear, Character.valueOf('W'), "plankWood", Character.valueOf('S'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockWaterTurbine, 1, 1), new Object[]{"SWS", "WGW", "SWS", Character.valueOf('G'), new ItemStack(blockWaterTurbine, 1, 0), Character.valueOf('W'), Block.field_71981_t, Character.valueOf('S'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockWaterTurbine, 1, 2), new Object[]{"SWS", "WGW", "SWS", Character.valueOf('G'), new ItemStack(blockWaterTurbine, 1, 1), Character.valueOf('W'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('S'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockPump, new Object[]{"PPP", "GGG", "PPP", Character.valueOf('P'), itemPipe, Character.valueOf('G'), new ItemStack(itemGear, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemPipe, 3, EnumPipeMaterial.CERAMIC.ordinal()), new Object[]{"BBB", "   ", "BBB", Character.valueOf('B'), Item.field_77772_aH}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemPipe, 3, EnumPipeMaterial.BRONZE.ordinal()), new Object[]{"BBB", "   ", "BBB", Character.valueOf('B'), "ingotBronze"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemPipe, 3, EnumPipeMaterial.PLASTIC.ordinal()), new Object[]{"BBB", "   ", "BBB", Character.valueOf('B'), UniversalRecipe.RUBBER.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemPipe, 3, EnumPipeMaterial.IRON.ordinal()), new Object[]{"BBB", "   ", "BBB", Character.valueOf('B'), Item.field_77703_o}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemPipe, 3, EnumPipeMaterial.STEEL.ordinal()), new Object[]{"BBB", "   ", "BBB", Character.valueOf('B'), "ingotSteel"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemPipe, 3, EnumPipeMaterial.FIBERGLASS.ordinal()), new Object[]{"BBB", "   ", "BBB", Character.valueOf('B'), Item.field_77702_n}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockMechanicalPiston, new Object[]{"SGS", "SPS", "SRS", Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('S'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), new ItemStack(itemGear, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockGrinderWheel, new Object[]{"III", "LGL", "III", Character.valueOf('I'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('L'), "logWood", Character.valueOf('G'), itemGear}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockMixer, new Object[]{"IGI", "IGI", "IGI", Character.valueOf('I'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('G'), itemGear}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockTileBreaker, new Object[]{"CGC", "CPC", "CDC", Character.valueOf('C'), Block.field_71978_w, Character.valueOf('G'), itemGear, Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('D'), Item.field_77674_B}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockTilePlacer, new Object[]{"CGC", "CSC", "CRC", Character.valueOf('C'), Block.field_71978_w, Character.valueOf('G'), itemGear, Character.valueOf('S'), Item.field_77703_o, Character.valueOf('R'), Block.field_94341_cq}));
    }

    static {
        contentRegistry = new ContentRegistry(Settings.CONFIGURATION, Settings.idManager, ID).setPrefix("resonantinduction:").setTab((CreativeTabs)TabRI.DEFAULT);
    }
}

