/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.belt;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.prefab.block.BlockTile;
import resonant.lib.render.block.BlockRenderingHandler;
import resonantinduction.mechanical.belt.TileConveyorBelt;
import universalelectricity.api.UniversalElectricity;

public class BlockConveyorBelt
extends BlockTile {
    public BlockConveyorBelt(int id) {
        super(id, UniversalElectricity.machine);
        this.func_111022_d("resonantinduction:material_metal_side");
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3f, 1.0f);
    }

    public void func_71861_g(World world, int x, int y, int z) {
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        if (world.func_72796_p(x, y, z) instanceof TileConveyorBelt) {
            TileConveyorBelt tileEntity = (TileConveyorBelt)world.func_72796_p(x, y, z);
            if (tileEntity.getBeltType() == TileConveyorBelt.BeltType.SLANT_UP || tileEntity.getBeltType() == TileConveyorBelt.BeltType.SLANT_DOWN) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.96f, 1.0f);
                return;
            }
            if (tileEntity.getBeltType() == TileConveyorBelt.BeltType.RAISED) {
                this.func_71905_a(0.0f, 0.68f, 0.0f, 1.0f, 0.96f, 1.0f);
                return;
            }
        }
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3f, 1.0f);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        TileEntity t = world.func_72796_p(x, y, z);
        if (t != null && t instanceof TileConveyorBelt) {
            TileConveyorBelt tileEntity = (TileConveyorBelt)t;
            if (tileEntity.getBeltType() == TileConveyorBelt.BeltType.SLANT_UP || tileEntity.getBeltType() == TileConveyorBelt.BeltType.SLANT_DOWN) {
                return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0);
            }
            if (tileEntity.getBeltType() == TileConveyorBelt.BeltType.RAISED) {
                return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + (double)0.68f, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + (double)0.98f, (double)z + this.field_72019_cm);
            }
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + this.field_72022_cl, (double)z + this.field_72019_cm);
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB boundBox, List boxList, Entity entity) {
        AxisAlignedBB newBounds;
        TileEntity t = world.func_72796_p(x, y, z);
        if (t != null && t instanceof TileConveyorBelt) {
            TileConveyorBelt tile = (TileConveyorBelt)t;
            if (tile.getBeltType() == TileConveyorBelt.BeltType.SLANT_UP || tile.getBeltType() == TileConveyorBelt.BeltType.SLANT_DOWN) {
                AxisAlignedBB boundBottom = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)y + 0.3, (double)(z + 1));
                AxisAlignedBB boundTop = null;
                ForgeDirection direction = tile.getDirection();
                if (tile.getBeltType() != TileConveyorBelt.BeltType.NORMAL) {
                    AxisAlignedBB newBounds2 = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)y + 0.1, (double)(z + 1));
                    if (newBounds2 != null && boundBox.func_72326_a(newBounds2)) {
                        boxList.add(newBounds2);
                    }
                    return;
                }
                if (tile.getBeltType() == TileConveyorBelt.BeltType.SLANT_UP) {
                    if (direction.offsetX > 0) {
                        boundTop = AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + (float)direction.offsetX / 2.0f), (double)y, (double)z, (double)(x + 1), (double)y + 0.8, (double)(z + 1));
                    } else if (direction.offsetX < 0) {
                        boundTop = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)((float)x + (float)direction.offsetX / -2.0f), (double)y + 0.8, (double)(z + 1));
                    } else if (direction.offsetZ > 0) {
                        boundTop = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)((float)z + (float)direction.offsetZ / 2.0f), (double)(x + 1), (double)y + 0.8, (double)(z + 1));
                    } else if (direction.offsetZ < 0) {
                        boundTop = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)y + 0.8, (double)((float)z + (float)direction.offsetZ / -2.0f));
                    }
                } else if (tile.getBeltType() == TileConveyorBelt.BeltType.SLANT_DOWN) {
                    if (direction.offsetX > 0) {
                        boundTop = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)((float)x + (float)direction.offsetX / 2.0f), (double)y + 0.8, (double)(z + 1));
                    } else if (direction.offsetX < 0) {
                        boundTop = AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + (float)direction.offsetX / -2.0f), (double)y, (double)z, (double)(x + 1), (double)y + 0.8, (double)(z + 1));
                    } else if (direction.offsetZ > 0) {
                        boundTop = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)y + 0.8, (double)((float)z + (float)direction.offsetZ / 2.0f));
                    } else if (direction.offsetZ < 0) {
                        boundTop = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)((float)z + (float)direction.offsetZ / -2.0f), (double)(x + 1), (double)y + 0.8, (double)(z + 1));
                    }
                }
                if (boundBox.func_72326_a(boundBottom)) {
                    boxList.add(boundBottom);
                }
                if (boundTop != null && boundBox.func_72326_a(boundTop)) {
                    boxList.add(boundTop);
                }
                return;
            }
            if (tile.getBeltType() == TileConveyorBelt.BeltType.RAISED) {
                AxisAlignedBB newBounds3 = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y + 0.68, (double)z, (double)(x + 1), (double)y + 0.98, (double)(z + 1));
                if (newBounds3 != null && boundBox.func_72326_a(newBounds3)) {
                    boxList.add(newBounds3);
                }
                return;
            }
        }
        if ((newBounds = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)y + 0.1, (double)(z + 1))) != null && boundBox.func_72326_a(newBounds)) {
            boxList.add(newBounds);
        }
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack stack) {
        super.func_71860_a(world, x, y, z, entityLiving, stack);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 2;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 4;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 5;
            }
        }
        world.func_72921_c(x, y, z, change, 3);
    }

    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int original = world.func_72805_g(x, y, z);
        int change = 2;
        switch (original) {
            case 2: {
                change = 4;
                break;
            }
            case 3: {
                change = 5;
                break;
            }
            case 4: {
                change = 3;
                break;
            }
            case 5: {
                change = 2;
            }
        }
        world.func_72921_c(x, y, z, change, 3);
        return true;
    }

    public boolean onSneakUseWrench(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileConveyorBelt tileEntity = (TileConveyorBelt)world.func_72796_p(x, y, z);
        int slantOrdinal = tileEntity.getBeltType().ordinal() + 1;
        if (slantOrdinal >= TileConveyorBelt.BeltType.values().length) {
            slantOrdinal = 0;
        }
        tileEntity.setBeltType(TileConveyorBelt.BeltType.values()[slantOrdinal]);
        return true;
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileConveyorBelt) {
            double maxSpeed;
            TileConveyorBelt tile = (TileConveyorBelt)tileEntity;
            if (tile.ignoreList.contains(entity)) {
                return;
            }
            if (!world.func_72864_z(x, y, z) && (maxSpeed = (double)0.1f) > 0.0) {
                TileConveyorBelt.BeltType slantType = tile.getBeltType();
                ForgeDirection direction = tile.getDirection();
                if (slantType != TileConveyorBelt.BeltType.NORMAL) {
                    entity.field_70122_E = false;
                }
                if (slantType == TileConveyorBelt.BeltType.SLANT_UP) {
                    entity.field_70181_x = maxSpeed * 3.0;
                } else if (slantType == TileConveyorBelt.BeltType.SLANT_DOWN) {
                    entity.field_70181_x = -maxSpeed;
                }
                if (direction.offsetX != 0) {
                    entity.field_70159_w = (double)direction.offsetX * maxSpeed;
                    entity.field_70179_y /= 2.0;
                }
                if (direction.offsetZ != 0) {
                    entity.field_70179_y = (double)direction.offsetZ * maxSpeed;
                    entity.field_70159_w /= 2.0;
                }
                if (entity instanceof EntityItem) {
                    double difference;
                    if (direction.offsetX != 0) {
                        difference = (double)z + 0.5 - entity.field_70161_v;
                        entity.field_70179_y += difference * 0.1;
                    } else if (direction.offsetZ != 0) {
                        difference = (double)x + 0.5 - entity.field_70165_t;
                        entity.field_70159_w += difference * 0.1;
                    }
                    ((EntityItem)entity).field_70292_b = 0;
                    boolean foundSneaking = false;
                    for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1)))) {
                        if (!player.func_70093_af()) continue;
                        foundSneaking = true;
                    }
                    ((EntityItem)entity).field_70293_c = foundSneaking ? 0 : 20;
                    entity.field_70122_E = false;
                }
            }
        }
    }

    public TileEntity func_72274_a(World world) {
        return new TileConveyorBelt();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return BlockRenderingHandler.ID;
    }

    public boolean func_71926_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71886_c() {
        return false;
    }

    public int func_71899_b(int par1) {
        return 0;
    }
}

