/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.energy.grid;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.TFacePart;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.grid.INode;
import resonant.api.grid.INodeProvider;
import resonantinduction.mechanical.energy.grid.MechanicalNode;
import universalelectricity.api.vector.Vector3;

public abstract class PartMechanical
extends JCuboidPart
implements JNormalOcclusion,
TFacePart,
INodeProvider {
    public MechanicalNode node;
    protected double prevAngularVelocity;
    int ticks = 0;
    boolean markPacketUpdate = false;
    public ForgeDirection placementSide = ForgeDirection.UNKNOWN;
    public int tier;

    public void preparePlacement(int side, int itemDamage) {
        this.placementSide = ForgeDirection.getOrientation((int)((byte)side));
        this.tier = itemDamage;
    }

    public void update() {
        ++this.ticks;
        if (!this.world().field_72995_K) {
            this.checkClientUpdate();
        }
        super.update();
    }

    public void checkClientUpdate() {
        if (Math.abs(this.prevAngularVelocity - this.node.angularVelocity) > (double)0.001f || this.prevAngularVelocity != this.node.angularVelocity && (this.prevAngularVelocity == 0.0 || this.node.angularVelocity == 0.0)) {
            this.prevAngularVelocity = this.node.angularVelocity;
            this.markPacketUpdate = true;
        }
        if (this.markPacketUpdate && this.ticks % 10 == 0) {
            this.sendRotationPacket();
            this.markPacketUpdate = false;
        }
    }

    public INode getNode(Class<? extends INode> nodeType, ForgeDirection from) {
        if (nodeType.isAssignableFrom(((Object)((Object)this.node)).getClass())) {
            return this.node;
        }
        return null;
    }

    public void onWorldJoin() {
        this.node.reconstruct();
    }

    public void onWorldSeparate() {
        this.node.deconstruct();
    }

    public void sendRotationPacket() {
        if (this.world() != null && !this.world().field_72995_K) {
            this.getWriteStream().writeByte(1).writeDouble(this.node.angularVelocity);
        }
    }

    public void read(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    public void read(MCDataInput packet, int packetID) {
        switch (packetID) {
            case 0: {
                this.load(packet.readNBTTagCompound());
                break;
            }
            case 1: {
                this.node.angularVelocity = packet.readDouble();
            }
        }
    }

    public void readDesc(MCDataInput packet) {
        packet.readByte();
        this.load(packet.readNBTTagCompound());
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(0);
        NBTTagCompound nbt = new NBTTagCompound();
        this.save(nbt);
        packet.writeNBTTagCompound(nbt);
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public boolean solid(int arg0) {
        return true;
    }

    public void load(NBTTagCompound nbt) {
        this.placementSide = ForgeDirection.getOrientation((int)nbt.func_74771_c("side"));
        this.tier = nbt.func_74771_c("tier");
        this.node.load(nbt);
    }

    public void save(NBTTagCompound nbt) {
        nbt.func_74774_a("side", (byte)this.placementSide.ordinal());
        nbt.func_74774_a("tier", (byte)this.tier);
        this.node.save(nbt);
    }

    protected abstract ItemStack getItem();

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getItem());
        return drops;
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    public Vector3 getPosition() {
        return new Vector3((double)this.x(), (double)this.y(), (double)this.z());
    }
}

