/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.energy.turbine;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import resonantinduction.core.resource.ItemHandCrank;
import resonantinduction.mechanical.energy.turbine.BlockTurbineBase;
import resonantinduction.mechanical.energy.turbine.TileMechanicalTurbine;
import resonantinduction.mechanical.energy.turbine.TileTurbineBase;

public class BlockMechanicalTurbine
extends BlockTurbineBase {
    int dropDamage = 0;

    public BlockMechanicalTurbine(int id) {
        super(id, Material.field_76243_f);
        this.func_111022_d("resonantinduction:material_wood_surface");
        this.rotationMask = Byte.parseByte("111111", 2);
    }

    public int func_71873_h(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTurbineBase) {
            return ((TileTurbineBase)tile).tier;
        }
        return 0;
    }

    public int func_71899_b(int par1) {
        return this.dropDamage;
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        this.dropDamage = this.func_71873_h(world, x, y, z);
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_71860_a(world, x, y, z, entityLiving, itemStack);
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileMechanicalTurbine) {
            ((TileMechanicalTurbine)tileEntity).tier = itemStack.func_77960_j();
        }
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemHandCrank && (tileEntity = world.func_72796_p(x, y, z)) instanceof TileTurbineBase) {
            if (!world.field_72995_K) {
                TileMechanicalTurbine tile = (TileMechanicalTurbine)tileEntity;
                tile.mechanicalNode.torque = -tile.mechanicalNode.torque;
                tile.mechanicalNode.angularVelocity = -tile.mechanicalNode.angularVelocity;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileTurbineBase) {
            if (!world.field_72995_K) {
                TileTurbineBase tile = (TileTurbineBase)tileEntity;
                if (tile.getMultiBlock().isConstructed()) {
                    tile.getMultiBlock().deconstruct();
                    ++tile.multiBlockRadius;
                    if (!tile.getMultiBlock().construct()) {
                        tile.multiBlockRadius = 1;
                    }
                    return true;
                }
                if (!tile.getMultiBlock().construct()) {
                    tile.multiBlockRadius = 1;
                    tile.getMultiBlock().construct();
                }
            }
            return true;
        }
        return false;
    }

    public boolean onSneakUseWrench(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileTurbineBase) {
            HashSet<TileTurbineBase> toFlip = new HashSet<TileTurbineBase>();
            if (!((TileTurbineBase)tileEntity).getMultiBlock().isConstructed()) {
                toFlip.add((TileTurbineBase)tileEntity);
            } else {
                Set str = ((TileTurbineBase)((TileTurbineBase)tileEntity).getMultiBlock().getPrimary()).getMultiBlock().getStructure();
                if (str != null) {
                    toFlip.addAll(str);
                }
            }
            for (TileTurbineBase turbine : toFlip) {
                if (side == turbine.getDirection().ordinal()) {
                    world.func_72921_c(turbine.field_70329_l, turbine.field_70330_m, turbine.field_70327_n, side ^ 1, 3);
                    continue;
                }
                world.func_72921_c(turbine.field_70329_l, turbine.field_70330_m, turbine.field_70327_n, side, 3);
            }
        }
        return true;
    }
}

