/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.energy.turbine;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IMechanicalNode;
import resonant.api.grid.INode;
import resonant.api.grid.INodeProvider;
import resonant.lib.network.Synced;
import resonantinduction.mechanical.energy.grid.MechanicalNode;
import resonantinduction.mechanical.energy.turbine.TileTurbineBase;

public class TileMechanicalTurbine
extends TileTurbineBase
implements INodeProvider {
    protected MechanicalNode mechanicalNode = new TurbineNode(this);
    @Synced(value={1})
    protected double renderAngularVelocity;
    protected double renderAngle;
    protected double prevAngularVelocity;

    @Override
    public void initiate() {
        this.mechanicalNode.reconstruct();
        super.initiate();
    }

    public void func_70313_j() {
        this.mechanicalNode.deconstruct();
        super.func_70313_j();
    }

    @Override
    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            this.renderAngularVelocity = this.mechanicalNode.angularVelocity;
            if (this.renderAngularVelocity != this.prevAngularVelocity) {
                this.prevAngularVelocity = this.renderAngularVelocity;
                this.sendPowerUpdate();
            }
        } else {
            this.renderAngle = (this.renderAngle + this.renderAngularVelocity / 20.0) % (Math.PI * 2);
            this.onProduce();
        }
        super.func_70316_g();
    }

    @Override
    public void onProduce() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.mechanicalNode.torque < 0.0) {
                this.torque = -Math.abs(this.torque);
            }
            if (this.mechanicalNode.angularVelocity < 0.0) {
                this.angularVelocity = -Math.abs(this.angularVelocity);
            }
            this.mechanicalNode.apply((Object)this, ((double)this.torque - this.mechanicalNode.getTorque()) / 10.0, ((double)this.angularVelocity - this.mechanicalNode.getAngularVelocity()) / 10.0);
        }
    }

    public INode getNode(Class<? extends INode> nodeType, ForgeDirection from) {
        if (nodeType.isAssignableFrom(((Object)((Object)this.mechanicalNode)).getClass())) {
            return ((TileMechanicalTurbine)this.getMultiBlock().get()).mechanicalNode;
        }
        return null;
    }

    @Override
    @Synced.SyncedInput
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.tier = nbt.func_74762_e("tier");
        this.mechanicalNode.load(nbt);
    }

    @Override
    @Synced.SyncedOutput
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("tier", this.tier);
        this.mechanicalNode.save(nbt);
    }

    protected class TurbineNode
    extends MechanicalNode {
        public TurbineNode(INodeProvider parent) {
            super(parent);
        }

        @Override
        public boolean canConnect(ForgeDirection from, Object source) {
            TileEntity sourceTile;
            if (source instanceof MechanicalNode && !(source instanceof TileMechanicalTurbine) && (sourceTile = this.position().translate(from).getTileEntity((IBlockAccess)TileMechanicalTurbine.this.getWorld())) instanceof INodeProvider) {
                MechanicalNode sourceInstance = (MechanicalNode)((INodeProvider)sourceTile).getNode(MechanicalNode.class, from.getOpposite());
                return sourceInstance == source && from == TileMechanicalTurbine.this.getDirection().getOpposite();
            }
            return false;
        }

        @Override
        public boolean inverseRotation(ForgeDirection dir, IMechanicalNode with) {
            return dir == TileMechanicalTurbine.this.getDirection().getOpposite();
        }

        @Override
        public float getRatio(ForgeDirection dir, IMechanicalNode with) {
            return TileMechanicalTurbine.this.getMultiBlock().isConstructed() ? (float)TileMechanicalTurbine.this.multiBlockRadius - 0.5f : 0.5f;
        }
    }
}

