/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.energy.turbine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.References;
import resonant.lib.content.module.TileBase;
import resonant.lib.multiblock.IMultiBlockStructure;
import resonant.lib.network.Synced;
import resonantinduction.mechanical.energy.turbine.TurbineMBlockHandler;
import universalelectricity.api.vector.Vector3;

public abstract class TileTurbineBase
extends TileBase
implements IMultiBlockStructure<TileTurbineBase> {
    public int multiBlockRadius = 1;
    protected long maxPower;
    public long power = 0L;
    public float rotation = 0.0f;
    protected final long defaultTorque = 5000L;
    protected long torque = 5000L;
    protected float prevAngularVelocity = 0.0f;
    @Synced(value={1})
    protected float angularVelocity = 0.0f;
    @Synced
    public int tier = 0;
    private TurbineMBlockHandler multiBlock;

    public TileTurbineBase() {
        super(Material.field_76245_d);
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.func_70322_n());
    }

    public void initiate() {
        super.initiate();
    }

    public void func_70316_g() {
        super.func_70316_g();
        this.getMultiBlock().update();
        if (this.getMultiBlock().isPrimary()) {
            if (!this.field_70331_k.field_72995_K) {
                this.angularVelocity = (float)((double)this.power / (double)this.torque);
                if (!this.field_70331_k.field_72995_K && this.ticks % 3L == 0L && this.prevAngularVelocity != this.angularVelocity) {
                    this.sendPowerUpdate();
                    this.prevAngularVelocity = this.angularVelocity;
                }
                if (this.power > 0L) {
                    this.onProduce();
                }
            }
            if (this.angularVelocity != 0.0f) {
                this.playSound();
                this.rotation = (float)((double)(this.rotation + this.angularVelocity / 20.0f) % (Math.PI * 2));
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            this.power = 0L;
        }
    }

    protected long getMaxPower() {
        if (this.getMultiBlock().isConstructed()) {
            return this.maxPower * (long)this.getArea();
        }
        return this.maxPower;
    }

    public int getArea() {
        return (int)(((double)this.multiBlockRadius + 0.5) * 2.0 * (((double)this.multiBlockRadius + 0.5) * 2.0));
    }

    public void onProduce() {
    }

    public void playSound() {
    }

    public Packet func_70319_e() {
        return References.PACKET_ANNOTATION.getPacket((Object)this);
    }

    public void sendPowerUpdate() {
        References.PACKET_ANNOTATION.sync((Object)this, 1);
    }

    @Synced.SyncedInput
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.multiBlockRadius = nbt.func_74762_e("multiBlockRadius");
        this.getMultiBlock().load(nbt);
    }

    @Synced.SyncedOutput
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("multiBlockRadius", this.multiBlockRadius);
        this.getMultiBlock().save(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)(this.field_70329_l - this.multiBlockRadius), (double)(this.field_70330_m - this.multiBlockRadius), (double)(this.field_70327_n - this.multiBlockRadius), (double)(this.field_70329_l + 1 + this.multiBlockRadius), (double)(this.field_70330_m + 1 + this.multiBlockRadius), (double)(this.field_70327_n + 1 + this.multiBlockRadius));
    }

    public Vector3[] getMultiBlockVectors() {
        HashSet<Vector3> vectors = new HashSet<Vector3>();
        ForgeDirection dir = this.getDirection();
        int xMulti = dir.offsetX != 0 ? 0 : 1;
        int yMulti = dir.offsetY != 0 ? 0 : 1;
        int zMulti = dir.offsetZ != 0 ? 0 : 1;
        for (int x = -this.multiBlockRadius; x <= this.multiBlockRadius; ++x) {
            for (int y = -this.multiBlockRadius; y <= this.multiBlockRadius; ++y) {
                for (int z = -this.multiBlockRadius; z <= this.multiBlockRadius; ++z) {
                    vectors.add(new Vector3((double)(x * xMulti), (double)(y * yMulti), (double)(z * zMulti)));
                }
            }
        }
        return vectors.toArray(new Vector3[0]);
    }

    public Vector3 getPosition() {
        return new Vector3((TileEntity)this);
    }

    public TurbineMBlockHandler getMultiBlock() {
        if (this.multiBlock == null) {
            this.multiBlock = new TurbineMBlockHandler(this);
        }
        return this.multiBlock;
    }

    public void onMultiBlockChanged() {
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o() != null ? this.func_70311_o().field_71990_ca : 0);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public World getWorld() {
        return this.field_70331_k;
    }
}

