/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.energy.turbine;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenPlains;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.core.Settings;
import resonantinduction.mechanical.energy.turbine.TileMechanicalTurbine;
import resonantinduction.mechanical.energy.turbine.TileTurbineBase;
import universalelectricity.api.vector.Vector3;

public class TileWindTurbine
extends TileMechanicalTurbine {
    private final byte[] openBlockCache = new byte[224];
    private int checkCount = 0;
    private float efficiency = 0.0f;
    private long windPower = 0L;

    @Override
    public void func_70316_g() {
        if (this.tier == 0 && this.getDirection().offsetY == 0 && this.field_70331_k.func_72896_J() && this.field_70331_k.func_72911_I() && (double)this.field_70331_k.field_73012_v.nextFloat() < 8.0E-8) {
            InventoryUtility.dropItemStack((World)this.field_70331_k, (Vector3)new Vector3((TileEntity)this), (ItemStack)new ItemStack(Block.field_72101_ab, 1 + this.field_70331_k.field_73012_v.nextInt(2)));
            InventoryUtility.dropItemStack((World)this.field_70331_k, (Vector3)new Vector3((TileEntity)this), (ItemStack)new ItemStack(Item.field_77669_D, 3 + this.field_70331_k.field_73012_v.nextInt(8)));
            this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return;
        }
        if (!this.getMultiBlock().isPrimary()) {
            return;
        }
        if (this.getDirection().offsetY == 0) {
            this.maxPower = 3000L;
            if (this.ticks % 20L == 0L && !this.field_70331_k.field_72995_K) {
                this.computePower();
            }
            ((TileTurbineBase)this.getMultiBlock().get()).power += this.windPower;
        } else {
            this.maxPower = 10000L;
        }
        this.torque = this.getMultiBlock().isConstructed() ? (long)(5000.0 / (9.0 / (double)this.multiBlockRadius)) : 416L;
        super.func_70316_g();
    }

    private void computePower() {
        int openAirBlocks;
        ForgeDirection checkDir;
        int checkSize = 10;
        int height = this.field_70330_m + this.checkCount / 28;
        int deviation = this.checkCount % 7;
        Vector3 check = new Vector3((TileEntity)this);
        switch (this.checkCount / 7 % 4) {
            case 0: {
                checkDir = ForgeDirection.NORTH;
                check = new Vector3((double)(this.field_70329_l - 3 + deviation), (double)height, (double)(this.field_70327_n - 4));
                break;
            }
            case 1: {
                checkDir = ForgeDirection.WEST;
                check = new Vector3((double)(this.field_70329_l - 4), (double)height, (double)(this.field_70327_n - 3 + deviation));
                break;
            }
            case 2: {
                checkDir = ForgeDirection.SOUTH;
                check = new Vector3((double)(this.field_70329_l - 3 + deviation), (double)height, (double)(this.field_70327_n + 4));
                break;
            }
            default: {
                checkDir = ForgeDirection.EAST;
                check = new Vector3((double)(this.field_70329_l + 4), (double)height, (double)(this.field_70327_n - 3 + deviation));
            }
        }
        for (openAirBlocks = 0; openAirBlocks < checkSize && this.field_70331_k.func_72799_c(check.intX(), check.intY(), check.intZ()); openAirBlocks = (int)((byte)(openAirBlocks + 1))) {
            check.translate(checkDir);
        }
        this.efficiency = this.efficiency - (float)this.openBlockCache[this.checkCount] + (float)openAirBlocks;
        this.openBlockCache[this.checkCount] = openAirBlocks;
        this.checkCount = (this.checkCount + 1) % (this.openBlockCache.length - 1);
        float multiblockMultiplier = ((float)this.multiBlockRadius + 0.5f) * 2.0f;
        float materialMultiplier = this.tier == 0 ? 1.1f : (this.tier == 1 ? 0.9f : 1.0f);
        BiomeGenBase biome = this.field_70331_k.func_72807_a(this.field_70329_l, this.field_70327_n);
        boolean hasBonus = biome instanceof BiomeGenOcean || biome instanceof BiomeGenPlains || biome == BiomeGenBase.field_76781_i;
        float windSpeed = this.field_70331_k.field_73012_v.nextFloat() / 8.0f + (float)this.field_70330_m / 256.0f * (hasBonus ? 1.2f : 1.0f) + this.field_70331_k.func_72867_j(1.5f);
        this.windPower = (long)Math.min(materialMultiplier * multiblockMultiplier * windSpeed * this.efficiency * (float)Settings.WIND_POWER_RATIO, (float)(this.maxPower * (long)Settings.WIND_POWER_RATIO));
    }
}

