/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.gear;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IMechanicalNode;
import resonant.api.grid.INodeProvider;
import resonantinduction.mechanical.energy.grid.MechanicalNode;
import resonantinduction.mechanical.gear.PartGear;
import resonantinduction.mechanical.gear.PartGearShaft;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class GearNode
extends MechanicalNode {
    public GearNode(PartGear parent) {
        super(parent);
    }

    protected PartGear gear() {
        return (PartGear)this.parent;
    }

    @Override
    public void onUpdate() {
        if (!this.gear().getMultiBlock().isPrimary()) {
            this.torque = 0.0;
            this.angularVelocity = 0.0;
        } else if (this.gear().tier == 10) {
            this.torque = 100.0;
            this.angularVelocity = 100.0;
        }
    }

    @Override
    public double getTorqueLoad() {
        switch (this.gear().tier) {
            default: {
                return 0.3;
            }
            case 1: {
                return 0.2;
            }
            case 2: {
                return 0.1;
            }
            case 10: 
        }
        return 0.0;
    }

    @Override
    public double getAngularVelocityLoad() {
        switch (this.gear().tier) {
            default: {
                return 0.03;
            }
            case 1: {
                return 0.02;
            }
            case 2: {
                return 0.01;
            }
            case 10: 
        }
        return 0.0;
    }

    @Override
    public void doRecache() {
        MechanicalNode instance;
        this.connections.clear();
        if (!this.gear().getMultiBlock().isPrimary() || this.world() == null) {
            return;
        }
        TileEntity tileBehind = new Vector3((TileEntity)this.gear().tile()).translate(this.gear().placementSide).getTileEntity((IBlockAccess)this.world());
        if (tileBehind instanceof INodeProvider && (instance = (MechanicalNode)((INodeProvider)tileBehind).getNode(MechanicalNode.class, this.gear().placementSide.getOpposite())) != null && instance != this && !(instance.parent instanceof PartGearShaft) && instance.canConnect(this.gear().placementSide.getOpposite(), (Object)this)) {
            this.connections.put(instance, this.gear().placementSide);
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection checkDir = ForgeDirection.getOrientation((int)i);
            TileMultipart tile = this.gear().tile();
            if (this.gear().getMultiBlock().isConstructed() && checkDir != this.gear().placementSide && checkDir != this.gear().placementSide.getOpposite()) {
                tile = new Vector3((TileEntity)this.gear().tile()).translate(checkDir).getTileEntity((IBlockAccess)this.world());
            }
            if (!(tile instanceof INodeProvider)) continue;
            MechanicalNode instance2 = (MechanicalNode)((INodeProvider)tile).getNode(MechanicalNode.class, checkDir == this.gear().placementSide.getOpposite() ? ForgeDirection.UNKNOWN : checkDir);
            if (this.connections.containsValue(checkDir) || instance2 == this || checkDir == this.gear().placementSide || instance2 == null || !instance2.canConnect(checkDir.getOpposite(), (Object)this)) continue;
            this.connections.put(instance2, checkDir);
        }
        int displaceCheck = 1;
        if (this.gear().getMultiBlock().isPrimary() && this.gear().getMultiBlock().isConstructed()) {
            displaceCheck = 2;
        }
        for (int i = 0; i < 4; ++i) {
            MechanicalNode instance3;
            ForgeDirection checkDir = ForgeDirection.getOrientation((int)Rotation.rotateSide((int)this.gear().placementSide.ordinal(), (int)i));
            TileEntity checkTile = new Vector3((TileEntity)this.gear().tile()).translate(checkDir, (double)displaceCheck).getTileEntity((IBlockAccess)this.world());
            if (this.connections.containsValue(checkDir) || !(checkTile instanceof INodeProvider) || (instance3 = (MechanicalNode)((INodeProvider)checkTile).getNode(MechanicalNode.class, this.gear().placementSide)) == null || instance3 == this || !instance3.canConnect(checkDir.getOpposite(), (Object)this) || instance3.parent instanceof PartGearShaft) continue;
            this.connections.put(instance3, checkDir);
        }
    }

    @Override
    public boolean canConnect(ForgeDirection from, Object with) {
        if (!this.gear().getMultiBlock().isPrimary()) {
            return false;
        }
        if (with instanceof MechanicalNode) {
            INodeProvider parent = ((MechanicalNode)((Object)with)).parent;
            if (from == this.gear().placementSide.getOpposite()) {
                TileEntity sourceTile;
                if (parent instanceof PartGear || parent instanceof PartGearShaft) {
                    if (parent instanceof PartGearShaft) {
                        PartGearShaft shaft = (PartGearShaft)parent;
                        return shaft.tile().partMap(from.getOpposite().ordinal()) == this.gear() && Math.abs(shaft.placementSide.offsetX) == Math.abs(this.gear().placementSide.offsetX) && Math.abs(shaft.placementSide.offsetY) == Math.abs(this.gear().placementSide.offsetY) && Math.abs(shaft.placementSide.offsetZ) == Math.abs(this.gear().placementSide.offsetZ);
                    }
                    if (parent instanceof PartGear) {
                        if (((PartGear)parent).tile() == this.gear().tile() && !this.gear().getMultiBlock().isConstructed()) {
                            return true;
                        }
                        if (((PartGear)parent).placementSide != this.gear().placementSide) {
                            TMultiPart checkPart;
                            TMultiPart part = this.gear().tile().partMap(((PartGear)parent).placementSide.ordinal());
                            if (part instanceof PartGear) {
                                PartGear sourceGear = (PartGear)part;
                                if (sourceGear.isCenterMultiBlock() && !sourceGear.getMultiBlock().isPrimary()) {
                                    return true;
                                }
                            } else if (this.gear().getMultiBlock().isConstructed() && (checkPart = ((PartGear)parent).tile().partMap(this.gear().placementSide.ordinal())) instanceof PartGear) {
                                ForgeDirection requiredDirection = ((PartGear)checkPart).getPosition().subtract((IVector3)this.position()).toForgeDirection();
                                return ((PartGear)checkPart).isCenterMultiBlock() && ((PartGear)parent).placementSide == requiredDirection;
                            }
                        }
                    }
                }
                if ((sourceTile = this.position().translate(from.getOpposite()).getTileEntity((IBlockAccess)this.world())) instanceof INodeProvider) {
                    MechanicalNode sourceInstance = (MechanicalNode)((INodeProvider)sourceTile).getNode(MechanicalNode.class, from);
                    return sourceInstance == with;
                }
            } else if (from == this.gear().placementSide) {
                TileEntity sourceTile = this.position().translate(from).getTileEntity((IBlockAccess)this.world());
                if (sourceTile instanceof INodeProvider) {
                    MechanicalNode sourceInstance = (MechanicalNode)((INodeProvider)sourceTile).getNode(MechanicalNode.class, from.getOpposite());
                    return sourceInstance == with;
                }
            } else {
                TileEntity destinationTile = ((MechanicalNode)((Object)with)).position().translate(from.getOpposite()).getTileEntity((IBlockAccess)this.world());
                if (destinationTile instanceof INodeProvider && destinationTile instanceof TileMultipart) {
                    TMultiPart destinationPart = ((TileMultipart)destinationTile).partMap(this.gear().placementSide.ordinal());
                    if (destinationPart instanceof PartGear) {
                        if (this.gear() != destinationPart) {
                            return ((PartGear)destinationPart).isCenterMultiBlock();
                        }
                        return true;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public float getRatio(ForgeDirection dir, IMechanicalNode with) {
        boolean caseZ;
        Vector3 deltaPos = with.position().subtract((IVector3)this.position());
        boolean caseX = this.gear().placementSide.offsetX != 0 && deltaPos.y == 0.0 && deltaPos.z == 0.0;
        boolean caseY = this.gear().placementSide.offsetY != 0 && deltaPos.x == 0.0 && deltaPos.z == 0.0;
        boolean bl = caseZ = this.gear().placementSide.offsetZ != 0 && deltaPos.x == 0.0 && deltaPos.y == 0.0;
        if (caseX || caseY || caseZ) {
            return super.getRatio(dir, with);
        }
        return this.gear().getMultiBlock().isConstructed() ? 1.5f : super.getRatio(dir, with);
    }
}

