/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.gear;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.PartMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import resonantinduction.mechanical.Mechanical;
import resonantinduction.mechanical.energy.grid.PartMechanical;
import resonantinduction.mechanical.gearshaft.GearShaftNode;
import resonantinduction.mechanical.gearshaft.RenderGearShaft;

public class PartGearShaft
extends PartMechanical {
    public static IndexedCuboid6[] sides = new IndexedCuboid6[7];

    public PartGearShaft() {
        this.node = new GearShaftNode(this);
    }

    @Override
    public void preparePlacement(int side, int itemDamage) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)((byte)(side ^ 1)));
        this.placementSide = ForgeDirection.getOrientation((int)(dir.ordinal() % 2 != 0 ? dir.ordinal() - 1 : dir.ordinal()));
        this.tier = itemDamage;
    }

    @Override
    protected ItemStack getItem() {
        return new ItemStack(Mechanical.itemGearShaft, 1, this.tier);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            RenderGearShaft.INSTANCE.renderDynamic(this, pos.x, pos.y, pos.z, frame);
        }
    }

    public String getType() {
        return "resonant_induction_gear_shaft";
    }

    public int getSlotMask() {
        return PartMap.CENTER.mask;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return this.getCollisionBoxes();
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        HashSet<Cuboid6> collisionBoxes = new HashSet<Cuboid6>();
        collisionBoxes.addAll((Collection)this.getSubParts());
        return collisionBoxes;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        HashSet<IndexedCuboid6> subParts = new HashSet<IndexedCuboid6>();
        IndexedCuboid6[] currentSides = sides;
        if (this.tile() != null) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (side != this.placementSide && side != this.placementSide.getOpposite()) continue;
                subParts.add(currentSides[side.ordinal()]);
            }
        }
        subParts.add(currentSides[6]);
        return subParts;
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    }

    static {
        PartGearShaft.sides[0] = new IndexedCuboid6((Object)0, new Cuboid6(0.36, 0.0, 0.36, 0.64, 0.36, 0.64));
        PartGearShaft.sides[1] = new IndexedCuboid6((Object)1, new Cuboid6(0.36, 0.64, 0.36, 0.64, 1.0, 0.64));
        PartGearShaft.sides[2] = new IndexedCuboid6((Object)2, new Cuboid6(0.36, 0.36, 0.0, 0.64, 0.64, 0.36));
        PartGearShaft.sides[3] = new IndexedCuboid6((Object)3, new Cuboid6(0.36, 0.36, 0.64, 0.64, 0.64, 1.0));
        PartGearShaft.sides[4] = new IndexedCuboid6((Object)4, new Cuboid6(0.0, 0.36, 0.36, 0.36, 0.64, 0.64));
        PartGearShaft.sides[5] = new IndexedCuboid6((Object)5, new Cuboid6(0.64, 0.36, 0.36, 1.0, 0.64, 0.64));
        PartGearShaft.sides[6] = new IndexedCuboid6((Object)6, new Cuboid6(0.36, 0.36, 0.36, 0.64, 0.64, 0.64));
    }
}

