/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.logistic.belt;

import com.google.common.io.ByteArrayDataInput;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IManipulator;
import resonant.api.IRotatable;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.utility.inventory.InternalInventoryHandler;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.prefab.imprint.ItemImprint;
import resonantinduction.core.prefab.imprint.TileFilterable;
import universalelectricity.api.vector.Vector3;

public class TileManipulator
extends TileFilterable
implements IRotatable,
IManipulator,
IPacketReceiver {
    private boolean selfPulse = false;
    private boolean isOutput = false;
    private boolean isRedstonePowered = false;
    private InternalInventoryHandler invExtractionHelper;

    public TileManipulator() {
        this.isOpaqueCube = false;
        this.normalRender = false;
        this.customItemRender = true;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.isFunctioning()) {
            if (!this.isOutput) {
                this.enject();
            } else {
                this.isRedstonePowered = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                if (this.isSelfPulse() && this.ticks % 10L == 0L) {
                    this.isRedstonePowered = true;
                }
                if (this.isRedstonePowered) {
                    this.inject();
                }
            }
        }
    }

    public void enject() {
        Vector3 inputPosition = new Vector3((TileEntity)this);
        Vector3 outputUp = new Vector3((TileEntity)this);
        outputUp.translate(ForgeDirection.UP);
        Vector3 outputDown = new Vector3((TileEntity)this);
        outputDown.translate(ForgeDirection.DOWN);
        Vector3 outputPosition = new Vector3((TileEntity)this);
        outputPosition.translate(this.getDirection().getOpposite());
        if (outputPosition.getTileEntity((IBlockAccess)this.field_70331_k) instanceof TileManipulator && ((TileManipulator)outputPosition.getTileEntity((IBlockAccess)this.field_70331_k)).getDirection() == this.getDirection().getOpposite()) {
            return;
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)inputPosition.x, (double)inputPosition.y, (double)inputPosition.z, (double)(inputPosition.x + 1.0), (double)(inputPosition.y + 1.0), (double)(inputPosition.z + 1.0));
        List itemsInBound = this.field_70331_k.func_72872_a(EntityItem.class, bounds);
        for (EntityItem entity : itemsInBound) {
            if (entity.field_70128_L) continue;
            ItemStack remainingStack = entity.func_92059_d().func_77946_l();
            if (this.getFilter() != null && !this.isFiltering(remainingStack)) continue;
            remainingStack = this.invHelper().tryPlaceInPosition(remainingStack, outputUp, ForgeDirection.UP);
            if (remainingStack != null) {
                remainingStack = this.invHelper().tryPlaceInPosition(remainingStack, outputDown, ForgeDirection.DOWN);
            }
            if (remainingStack != null) {
                remainingStack = this.invHelper().tryPlaceInPosition(remainingStack, outputPosition, this.getDirection().getOpposite());
            }
            if (remainingStack != null && remainingStack.field_77994_a > 0) {
                this.invHelper().throwItem(outputPosition, remainingStack);
            }
            entity.func_70106_y();
        }
    }

    public void inject() {
        this.isRedstonePowered = false;
        Vector3 inputUp = new Vector3((TileEntity)this).translate(ForgeDirection.UP);
        Vector3 inputDown = new Vector3((TileEntity)this).translate(ForgeDirection.DOWN);
        Vector3 inputPosition = new Vector3((TileEntity)this).translate(this.getDirection().getOpposite());
        Vector3 outputPosition = new Vector3((TileEntity)this).translate(this.getDirection());
        ItemStack itemStack = this.invHelper().tryGrabFromPosition(inputUp, ForgeDirection.UP, 1);
        if (itemStack == null) {
            itemStack = this.invHelper().tryGrabFromPosition(inputDown, ForgeDirection.DOWN, 1);
        }
        if (itemStack == null) {
            itemStack = this.invHelper().tryGrabFromPosition(inputPosition, this.getDirection().getOpposite(), 1);
        }
        if (itemStack != null && itemStack.field_77994_a > 0) {
            this.invHelper().throwItem(outputPosition, itemStack);
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.isOutput = nbt.func_74767_n("isOutput");
        this.setSelfPulse(nbt.func_74767_n("selfpulse"));
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("isOutput", this.isOutput);
        nbt.func_74757_a("selfpulse", this.isSelfPulse());
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{this.isInverted(), this.isSelfPulse(), this.isOutput()});
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.setInverted(data.readBoolean());
            this.setSelfPulse(data.readBoolean());
            this.setOutput(data.readBoolean());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSelfPulse() {
        return this.selfPulse;
    }

    public void setSelfPulse(boolean selfPulse) {
        this.selfPulse = selfPulse;
    }

    public InternalInventoryHandler invHelper() {
        if (this.invExtractionHelper == null || this.invExtractionHelper.world != this.field_70331_k) {
            this.invExtractionHelper = new InternalInventoryHandler(this.field_70331_k, new Vector3((TileEntity)this), (Set)(this.getFilter() != null ? ItemImprint.getFilters((ItemStack)this.getFilter()) : null), this.isInverted());
        }
        return this.invExtractionHelper;
    }

    public void setFilter(ItemStack filter) {
        super.setFilter(filter);
        this.invHelper().setFilter((Set)(this.getFilter() != null ? ItemImprint.getFilters((ItemStack)this.getFilter()) : null), this.isInverted());
    }

    public boolean isOutput() {
        return this.isOutput;
    }

    public void setOutput(boolean isOutput) {
        this.isOutput = isOutput;
        if (!this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void toggleOutput() {
        this.setOutput(!this.isOutput());
    }
}

