/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.process.crusher;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IRotatable;
import resonant.api.grid.INodeProvider;
import resonant.api.recipe.MachineRecipes;
import resonant.api.recipe.RecipeResource;
import resonant.lib.config.Config;
import resonant.lib.utility.MovementUtility;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.core.ResonantInduction;
import resonantinduction.mechanical.energy.grid.TileMechanical;
import universalelectricity.api.vector.Vector3;

public class TileMechanicalPiston
extends TileMechanical
implements IRotatable {
    @Config
    private static int mechanicalPistonBreakCount = 5;
    private int breakCount = mechanicalPistonBreakCount;
    private boolean markRevolve = false;

    public TileMechanicalPiston() {
        super(Material.field_76233_E);
        this.mechanicalNode = new TileMechanical.PacketMechanicalNode((INodeProvider)this){

            @Override
            protected void revolve() {
                TileMechanicalPiston.this.markRevolve = true;
            }

            @Override
            public boolean canConnect(ForgeDirection from, Object source) {
                return from != TileMechanicalPiston.this.getDirection();
            }
        }.setLoad(0.5);
        this.isOpaqueCube = false;
        this.normalRender = false;
        this.customItemRender = true;
        this.rotationMask = Byte.parseByte("111111", 2);
        this.textureName = "material_steel_dark";
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.markRevolve) {
            Vector3 moveNewPosition;
            Vector3 movePosition = new Vector3((TileEntity)this).translate(this.getDirection());
            if (!this.hitOreBlock(movePosition) && !this.field_70331_k.field_72995_K && this.canMove(movePosition, moveNewPosition = movePosition.clone().translate(this.getDirection()))) {
                this.move(movePosition, moveNewPosition);
            }
            this.markRevolve = false;
        }
    }

    public boolean hitOreBlock(Vector3 blockPos) {
        Block block = Block.field_71973_m[blockPos.getBlockID((IBlockAccess)this.world())];
        if (block != null) {
            ItemStack blockStack = new ItemStack(block);
            RecipeResource[] resources = MachineRecipes.INSTANCE.getOutput(ResonantInduction.RecipeType.CRUSHER.name(), new Object[]{blockStack});
            if (resources.length > 0) {
                if (!this.field_70331_k.field_72995_K) {
                    int breakStatus = (int)((float)(mechanicalPistonBreakCount - this.breakCount) / (float)mechanicalPistonBreakCount * 10.0f);
                    this.world().func_72888_f(0, blockPos.intX(), blockPos.intY(), blockPos.intZ(), breakStatus);
                    if (this.breakCount <= 0) {
                        if (!this.world().field_72995_K) {
                            for (RecipeResource recipe : resources) {
                                if (!(Math.random() <= (double)recipe.getChance())) continue;
                                InventoryUtility.dropItemStack((World)this.world(), (Vector3)blockPos.clone().translate(0.5), (ItemStack)recipe.getItemStack(), (int)10, (float)0.0f);
                            }
                            this.func_70314_l().func_94578_a(blockPos.intX(), blockPos.intY(), blockPos.intZ(), false);
                        }
                        this.breakCount = mechanicalPistonBreakCount;
                    }
                }
                ResonantInduction.proxy.renderBlockParticle(this.field_70331_k, blockPos.clone().translate(0.5), new Vector3((Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0), block.field_71990_ca, 1.0f);
                --this.breakCount;
                return true;
            }
        }
        this.breakCount = mechanicalPistonBreakCount;
        if (!this.field_70331_k.field_72995_K) {
            this.world().func_72888_f(0, blockPos.intX(), blockPos.intY(), blockPos.intZ(), -1);
        }
        return false;
    }

    public void onRemove(int par5, int par6) {
        super.onRemove(par5, par6);
    }

    public boolean canMove(Vector3 from, Vector3 to) {
        TileEntity tileEntity = from.getTileEntity((IBlockAccess)this.field_70331_k);
        if (((Object)((Object)this)).equals(to.getTileEntity((IBlockAccess)this.func_70314_l()))) {
            return false;
        }
        int targetBlockID = to.getBlockID((IBlockAccess)this.field_70331_k);
        return this.field_70331_k.func_72799_c(to.intX(), to.intY(), to.intZ()) || targetBlockID > 0 && Block.field_71973_m[targetBlockID].isBlockReplaceable(this.field_70331_k, to.intX(), to.intY(), to.intZ());
    }

    public void move(Vector3 from, Vector3 to) {
        int blockID = from.getBlockID((IBlockAccess)this.field_70331_k);
        int blockMetadata = from.getBlockMetadata((IBlockAccess)this.field_70331_k);
        TileEntity tileEntity = from.getTileEntity((IBlockAccess)this.field_70331_k);
        NBTTagCompound tileData = new NBTTagCompound();
        if (tileEntity != null) {
            tileEntity.func_70310_b(tileData);
        }
        MovementUtility.setBlockSneaky((World)this.field_70331_k, (Vector3)from, (int)0, (int)0, null);
        if (tileEntity != null && tileData != null) {
            Class<?> multipart;
            boolean isMultipart = tileData.func_74779_i("id").equals("savedMultipart");
            TileEntity newTile = null;
            if (isMultipart) {
                try {
                    multipart = Class.forName("codechicken.multipart.MultipartHelper");
                    Method m = multipart.getMethod("createTileFromNBT", World.class, NBTTagCompound.class);
                    newTile = (TileEntity)m.invoke(null, this.field_70331_k, tileData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                newTile = TileEntity.func_70317_c((NBTTagCompound)tileData);
            }
            MovementUtility.setBlockSneaky((World)this.field_70331_k, (Vector3)to, (int)blockID, (int)blockMetadata, (TileEntity)newTile);
            if (newTile != null && isMultipart) {
                try {
                    multipart = Class.forName("codechicken.multipart.MultipartHelper");
                    multipart.getMethod("sendDescPacket", World.class, TileEntity.class).invoke(null, this.field_70331_k, newTile);
                    Class<?> tileMultipart = Class.forName("codechicken.multipart.TileMultipart");
                    tileMultipart.getMethod("onMoved", new Class[0]).invoke((Object)newTile, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            MovementUtility.setBlockSneaky((World)this.field_70331_k, (Vector3)to, (int)blockID, (int)blockMetadata, null);
        }
        this.notifyChanges(from);
        this.notifyChanges(to);
    }

    public void notifyChanges(Vector3 pos) {
        this.field_70331_k.func_72898_h(pos.intX(), pos.intY(), pos.intZ(), pos.getBlockID((IBlockAccess)this.field_70331_k));
        TileEntity newTile = pos.getTileEntity((IBlockAccess)this.field_70331_k);
        if (newTile != null && Loader.isModLoaded((String)"BuildCraft|Factory")) {
            try {
                Class<?> clazz = Class.forName("buildcraft.factory.TileQuarry");
                if (newTile.equals(clazz)) {
                    ReflectionHelper.setPrivateValue(clazz, (Object)newTile, (Object)true, (String[])new String[]{"isAlive"});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

