/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.process.edit;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.util.EnumSet;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonant.api.IRotatable;
import resonant.lib.content.module.TileBlock;
import resonant.lib.content.module.TileRender;
import resonant.lib.content.module.prefab.TileInventory;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonant.lib.render.RenderItemOverlayUtility;
import resonant.lib.render.RotatedTextureRenderer;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.inventory.InternalInventoryHandler;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.core.ResonantInduction;
import universalelectricity.api.vector.Vector3;

public class TilePlacer
extends TileInventory
implements IRotatable,
IPacketReceiver {
    @SideOnly(value=Side.CLIENT)
    private static Icon iconFront;
    @SideOnly(value=Side.CLIENT)
    private static Icon iconBack;
    private boolean doWork = false;
    private boolean autoPullItems = false;
    private byte placeDelay = 0;
    private InternalInventoryHandler invHandler;

    public TilePlacer() {
        super(Material.field_76246_e);
        this.normalRender = false;
        this.maxSlots = 1;
        this.rotationMask = Byte.parseByte("111111", 2);
    }

    public InternalInventoryHandler getInvHandler() {
        if (this.invHandler == null) {
            this.invHandler = new InternalInventoryHandler((TileEntity)this);
        }
        return this.invHandler;
    }

    public void onAdded() {
        this.work();
    }

    public void onNeighborChanged() {
        this.work();
    }

    public void initiate() {
        super.initiate();
    }

    public void func_70316_g() {
        if (this.autoPullItems && this.ticks % 5L == 0L && this.func_70301_a(0) == null) {
            this.func_70299_a(0, this.getInvHandler().tryGrabFromPosition(this.getDirection().getOpposite(), 1));
        }
        if (this.doWork) {
            if (this.placeDelay < 127) {
                this.placeDelay = (byte)(this.placeDelay + 1);
            }
            if (this.placeDelay >= 5) {
                this.doWork();
                this.doWork = false;
            }
        }
    }

    public void work() {
        if (this.isIndirectlyPowered()) {
            this.doWork = true;
            this.placeDelay = 0;
        }
    }

    public void doWork() {
        int side = 0;
        Vector3 placePos = this.position().translate(this.getDirection());
        ItemStack placeStack = this.func_70301_a(0);
        if (InventoryUtility.placeItemBlock((World)this.world(), (int)placePos.intX(), (int)placePos.intY(), (int)placePos.intZ(), (ItemStack)placeStack, (int)side)) {
            if (placeStack.field_77994_a <= 0) {
                this.func_70299_a(0, null);
            }
            this.markUpdate();
            this.doWork = false;
        }
    }

    protected boolean use(EntityPlayer player, int hitSide, Vector3 hit) {
        this.interactCurrentItem((IInventory)this, 0, player);
        return true;
    }

    protected boolean configure(EntityPlayer player, int side, Vector3 hit) {
        if (player.func_70093_af()) {
            this.autoPullItems = !this.autoPullItems;
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)("AutoExtract: " + this.autoPullItems)));
            return true;
        }
        return super.configure(player, side, hit);
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{nbt});
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.func_70307_a(PacketHandler.readNBTTagCompound((DataInput)data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.autoPullItems = nbt.func_74767_n("autoPull");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("autoPull", this.autoPullItems);
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return side == this.getDirection().getOpposite() && slot == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(IBlockAccess access, int side) {
        int meta = access.func_72805_g(this.x(), this.y(), this.z());
        if (side == meta) {
            return iconFront;
        }
        if (side == (meta ^ 1)) {
            return iconBack;
        }
        return this.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int side, int meta) {
        if (side == (meta ^ 1)) {
            return iconFront;
        }
        if (side == meta) {
            return iconBack;
        }
        return this.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        super.registerIcons(iconRegister);
        iconFront = iconRegister.func_94245_a(this.getTextureName() + "_front");
        iconBack = iconRegister.func_94245_a(this.getTextureName() + "_back");
    }

    @SideOnly(value=Side.CLIENT)
    protected TileRender newRenderer() {
        return new RotatedTextureRenderer((TileBlock)this){

            public boolean renderDynamic(Vector3 position, boolean isItem, float frame) {
                if (TilePlacer.this.world() != null && !isItem) {
                    EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
                    set.remove(TilePlacer.this.getDirection());
                    set.remove(TilePlacer.this.getDirection().getOpposite());
                    GL11.glPushMatrix();
                    RenderItemOverlayUtility.renderItemOnSides((TileEntity)TilePlacer.this.tile(), (ItemStack)TilePlacer.this.func_70301_a(0), (double)position.x, (double)position.y, (double)position.z, (String)LanguageUtility.getLocal((String)"tooltip.noOutput"), set);
                    GL11.glPopMatrix();
                }
                return false;
            }
        };
    }
}

