/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.process.grinder;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IMechanicalNode;
import resonant.api.IRotatable;
import resonant.api.grid.INodeProvider;
import resonant.api.recipe.MachineRecipes;
import resonant.api.recipe.RecipeResource;
import resonant.lib.prefab.vector.Cuboid;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.Timer;
import resonantinduction.mechanical.energy.grid.TileMechanical;
import universalelectricity.api.vector.Vector3;

public class TileGrindingWheel
extends TileMechanical
implements IRotatable {
    public static final int PROCESS_TIME = 400;
    public static final Timer<EntityItem> timer = new Timer();
    public EntityItem grindingItem = null;
    private final long requiredTorque = 1000L;
    private double counter = 0.0;

    public TileGrindingWheel() {
        super(Material.field_76246_e);
        this.mechanicalNode = new TileMechanical.PacketMechanicalNode((INodeProvider)this){

            @Override
            public boolean canConnect(ForgeDirection from, Object source) {
                if (TileGrindingWheel.this.getDirection().ordinal() < 2) {
                    return from.offsetY != 0;
                }
                return TileGrindingWheel.this.getDirection().getRotation(ForgeDirection.UP) == from || TileGrindingWheel.this.getDirection().getRotation(ForgeDirection.DOWN) == from;
            }

            @Override
            public boolean inverseRotation(ForgeDirection dir, IMechanicalNode with) {
                return dir.offsetX <= 0 && dir.offsetZ >= 0 && dir.offsetY >= 0;
            }
        }.setLoad(2.0);
        this.bounds = new Cuboid((double)0.05f, (double)0.05f, (double)0.05f, (double)0.95f, (double)0.95f, (double)0.95f);
        this.isOpaqueCube = false;
        this.normalRender = false;
        this.customItemRender = true;
        this.rotationMask = Byte.parseByte("111111", 2);
        this.textureName = "material_steel_dark";
    }

    public void collide(Entity entity) {
        if (entity instanceof EntityItem) {
            --((EntityItem)entity).field_70292_b;
        }
        if (this.canWork()) {
            if (entity instanceof EntityItem) {
                if (this.canGrind(((EntityItem)entity).func_92059_d())) {
                    if (this.grindingItem == null) {
                        this.grindingItem = (EntityItem)entity;
                    }
                    if (!timer.containsKey((Object)((EntityItem)entity))) {
                        timer.put((Object)((EntityItem)entity), 400);
                    }
                } else {
                    entity.func_70107_b(entity.field_70165_t, entity.field_70163_u - 1.2, entity.field_70161_v);
                }
            } else {
                entity.func_70097_a(DamageSource.field_76367_g, 2.0f);
            }
        }
        if (this.mechanicalNode.getAngularVelocity() != 0.0) {
            ForgeDirection dir = this.getDirection();
            dir = ForgeDirection.getOrientation((int)(dir.ordinal() % 2 != 0 ? dir.ordinal() - 1 : dir.ordinal())).getOpposite();
            double speed = this.mechanicalNode.getAngularVelocity() / 20.0;
            entity.func_70024_g((double)dir.offsetX * speed, Math.random() * speed, (double)dir.offsetZ * speed);
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.counter = Math.max(this.counter + this.mechanicalNode.torque, 0.0);
        this.doWork();
    }

    public boolean canWork() {
        return this.counter >= 1000.0;
    }

    /*
     * Unable to fully structure code
     */
    public void doWork() {
        block11: {
            block12: {
                if (!this.canWork()) break block11;
                didWork = false;
                if (this.grindingItem == null) break block12;
                if (!TileGrindingWheel.timer.containsKey((Object)this.grindingItem) || this.grindingItem.field_70128_L) ** GOTO lbl-1000
                v0 = new Vector3((TileEntity)this);
                if (v0.add(0.5).distance((Entity)this.grindingItem) < 1.0) {
                    timeLeft = TileGrindingWheel.timer.decrease((Object)this.grindingItem);
                    if (timeLeft <= 0) {
                        if (this.doGrind(this.grindingItem)) {
                            if (--this.grindingItem.func_92059_d().field_77994_a <= 0) {
                                this.grindingItem.func_70106_y();
                                TileGrindingWheel.timer.remove((Object)this.grindingItem);
                                this.grindingItem = null;
                            } else {
                                this.grindingItem.func_92058_a(this.grindingItem.func_92059_d());
                                TileGrindingWheel.timer.put((Object)this.grindingItem, 400);
                            }
                        }
                    } else {
                        this.grindingItem.field_70293_c = 20;
                        if (this.grindingItem.func_92059_d().func_77973_b() instanceof ItemBlock) {
                            ResonantInduction.proxy.renderBlockParticle(this.field_70331_k, new Vector3((Entity)this.grindingItem), new Vector3((Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0), ((ItemBlock)this.grindingItem.func_92059_d().func_77973_b()).func_77883_f(), 1.0f);
                        } else {
                            this.field_70331_k.func_72869_a("crit", this.grindingItem.field_70165_t, this.grindingItem.field_70163_u, this.grindingItem.field_70161_v, (Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0);
                        }
                    }
                    didWork = true;
                } else lbl-1000:
                // 2 sources

                {
                    TileGrindingWheel.timer.remove((Object)this.grindingItem);
                    this.grindingItem = null;
                }
            }
            if (didWork) {
                if (this.ticks % 8L == 0L) {
                    this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "resonantinduction:grinder", 0.5f, 1.0f);
                }
                this.counter -= 1000.0;
            }
        }
    }

    public boolean canGrind(ItemStack itemStack) {
        return MachineRecipes.INSTANCE.getOutput(ResonantInduction.RecipeType.GRINDER.name(), new Object[]{itemStack}).length > 0;
    }

    private boolean doGrind(EntityItem entity) {
        RecipeResource[] results;
        ItemStack itemStack = entity.func_92059_d();
        for (RecipeResource resource : results = MachineRecipes.INSTANCE.getOutput(ResonantInduction.RecipeType.GRINDER.name(), new Object[]{itemStack})) {
            ItemStack outputStack = resource.getItemStack();
            if (this.field_70331_k.field_72995_K) continue;
            EntityItem entityItem = new EntityItem(this.field_70331_k, entity.field_70165_t, entity.field_70163_u - 1.2, entity.field_70161_v, outputStack);
            entityItem.field_70293_c = 20;
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            this.field_70331_k.func_72838_d((Entity)entityItem);
        }
        return results.length > 0;
    }

    public ForgeDirection getDirection() {
        if (this.field_70331_k != null) {
            return ForgeDirection.getOrientation((int)this.func_70322_n());
        }
        return ForgeDirection.UNKNOWN;
    }

    public void setDirection(ForgeDirection direction) {
        this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, direction.ordinal(), 3);
    }
}

