/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.client;

import co.uk.flansmods.client.FlansModResourceHandler;
import co.uk.flansmods.common.EnumType;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.ItemPart;
import co.uk.flansmods.common.PartType;
import co.uk.flansmods.common.driveables.DriveableType;
import co.uk.flansmods.common.driveables.mechas.MechaType;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiDriveableCrafting
extends GuiScreen {
    private static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/driveableCrafting.png");
    private InventoryPlayer inventory;
    private Minecraft field_73882_e;
    private World world;
    private int x;
    private int y;
    private int z;
    private static RenderItem itemRenderer = new RenderItem();
    private int guiOriginX;
    private int guiOriginY;
    private static int blueprintsScroll = 0;
    private int recipeScroll = 0;
    private static int selectedBlueprint = 0;
    private float spinner = 0.0f;
    private boolean canCraft = false;

    public GuiDriveableCrafting(InventoryPlayer playerinventory, World w, int i, int j, int k) {
        this.inventory = playerinventory;
        this.field_73882_e = FMLClientHandler.instance().getClient();
        this.world = w;
        this.x = i;
        this.y = j;
        this.z = k;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_73887_h.add(new GuiButton(0, this.field_73880_f / 2 + 22, this.field_73881_g / 2 + 63, 40, 20, "Craft"));
    }

    protected void func_73875_a(GuiButton button) {
        if (button.field_73741_f == 0) {
            FlansMod.proxy.craftDriveable(this.inventory.field_70458_d, DriveableType.types.get(selectedBlueprint));
        }
    }

    public void func_73863_a(int i, int j, float f) {
        ScaledResolution scaledresolution = new ScaledResolution(this.field_73882_e.field_71474_y, this.field_73882_e.field_71443_c, this.field_73882_e.field_71440_d);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.func_73873_v_();
        GL11.glEnable((int)3042);
        this.field_73882_e.field_71446_o.func_110577_a(texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiOriginX = w / 2 - 88;
        this.guiOriginY = h / 2 - 99;
        this.func_73729_b(this.guiOriginX, this.guiOriginY, 0, 0, 176, 198);
        this.func_73731_b(this.field_73886_k, "Vehicle Crafting", this.guiOriginX + 6, this.guiOriginY + 6, 0xFFFFFF);
        this.func_73731_b(this.field_73886_k, "Requires", this.guiOriginX + 6, this.guiOriginY + 125, 0xFFFFFF);
        this.func_73731_b(this.field_73886_k, "Engine", this.guiOriginX + 114, this.guiOriginY + 141, 0xFFFFFF);
        for (int m = 0; m < 2; ++m) {
            for (int n = 0; n < 8; ++n) {
                int blueprintNumber = blueprintsScroll * 8 + 8 * m + n;
                if (blueprintNumber == selectedBlueprint) {
                    this.field_73882_e.field_71446_o.func_110577_a(texture);
                    this.func_73729_b(this.guiOriginX + 8 + n * 18, this.guiOriginY + 18 + m * 18, 213, 11, 16, 16);
                }
                if (blueprintNumber >= DriveableType.types.size()) continue;
                DriveableType type = DriveableType.types.get(blueprintNumber);
                this.drawSlotInventory(new ItemStack(type.item), this.guiOriginX + 8 + n * 18, this.guiOriginY + 18 + m * 18);
            }
        }
        this.spinner += 1.0f;
        if (selectedBlueprint >= DriveableType.types.size()) {
            return;
        }
        this.canCraft = true;
        DriveableType selectedType = DriveableType.types.get(selectedBlueprint);
        if (selectedType != null) {
            GL11.glPushMatrix();
            GL11.glEnable((int)2929);
            GL11.glTranslatef((float)(w / 2 - 46), (float)(h / 2 - 10), (float)100.0f);
            if (selectedType instanceof MechaType) {
                GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
            }
            GL11.glScalef((float)(-50.0f * selectedType.modelScale / selectedType.cameraDistance), (float)(50.0f * selectedType.modelScale / selectedType.cameraDistance), (float)(50.0f * selectedType.modelScale / selectedType.cameraDistance));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(this.spinner / 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.field_73882_e.field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(selectedType));
            selectedType.model.render(selectedType);
            GL11.glDisable((int)2929);
            GL11.glPopMatrix();
            String recipeName = selectedType.name;
            if (recipeName.length() > 16) {
                recipeName = recipeName.substring(0, 15) + "...";
            }
            this.func_73731_b(this.field_73886_k, recipeName, this.guiOriginX + 82, this.guiOriginY + 64, 0xFFFFFF);
            this.func_73731_b(this.field_73886_k, "Cargo Slots : " + selectedType.numCargoSlots, this.guiOriginX + 82, this.guiOriginY + 74, 0xFFFFFF);
            this.func_73731_b(this.field_73886_k, "Bomb Slots : " + selectedType.numBombSlots, this.guiOriginX + 82, this.guiOriginY + 84, 0xFFFFFF);
            this.func_73731_b(this.field_73886_k, "Passengers : " + selectedType.numPassengers, this.guiOriginX + 82, this.guiOriginY + 94, 0xFFFFFF);
            this.func_73731_b(this.field_73886_k, "Guns : " + (selectedType.numPassengerGunners + selectedType.guns.size()), this.guiOriginX + 82, this.guiOriginY + 104, 0xFFFFFF);
            this.func_73731_b(this.field_73886_k, selectedType.numEngines() + "x", this.guiOriginX + 100, this.guiOriginY + 141, 0xFFFFFF);
            InventoryPlayer temporaryInventory = new InventoryPlayer(null);
            temporaryInventory.func_70455_b(this.inventory);
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 4; ++c) {
                    int recipeItemNumber = this.recipeScroll * 4 + r * 4 + c;
                    if (recipeItemNumber >= selectedType.recipe.size()) continue;
                    ItemStack recipeStack = selectedType.recipe.get(recipeItemNumber);
                    int totalAmountFound = 0;
                    for (int n = 0; n < temporaryInventory.func_70302_i_(); ++n) {
                        ItemStack stackInSlot = temporaryInventory.func_70301_a(n);
                        if (stackInSlot == null || stackInSlot.field_77993_c != recipeStack.field_77993_c || stackInSlot.func_77960_j() != recipeStack.func_77960_j()) continue;
                        int amountFound = Math.min(stackInSlot.field_77994_a, recipeStack.field_77994_a - totalAmountFound);
                        stackInSlot.field_77994_a -= amountFound;
                        if (stackInSlot.field_77994_a <= 0) {
                            stackInSlot = null;
                        }
                        temporaryInventory.func_70299_a(n, stackInSlot);
                        if ((totalAmountFound += amountFound) == recipeStack.field_77994_a) break;
                    }
                    if (totalAmountFound < recipeStack.field_77994_a) {
                        this.field_73882_e.field_71446_o.func_110577_a(texture);
                        this.func_73729_b(this.guiOriginX + 8 + c * 18, this.guiOriginY + 138 + r * 18, 195, 11, 16, 16);
                        this.canCraft = false;
                    }
                    this.drawSlotInventory(recipeStack, this.guiOriginX + 8 + c * 18, this.guiOriginY + 138 + r * 18);
                }
            }
            HashMap<PartType, ItemStack> engines = new HashMap<PartType, ItemStack>();
            for (int n = 0; n < temporaryInventory.func_70302_i_(); ++n) {
                ItemStack stackInSlot = temporaryInventory.func_70301_a(n);
                if (stackInSlot == null || !(stackInSlot.func_77973_b() instanceof ItemPart)) continue;
                PartType partType = ((ItemPart)stackInSlot.func_77973_b()).type;
                if (partType.category != 2 || !partType.worksWith.contains((Object)EnumType.getFromObject(selectedType))) continue;
                if (engines.containsKey(partType)) {
                    ((ItemStack)engines.get((Object)partType)).field_77994_a += stackInSlot.field_77994_a;
                    continue;
                }
                engines.put(partType, stackInSlot);
            }
            float bestEngineSpeed = -1.0f;
            ItemStack bestEngineStack = null;
            for (PartType part : engines.keySet()) {
                if (!(part.engineSpeed > bestEngineSpeed) || ((ItemStack)engines.get((Object)part)).field_77994_a < selectedType.numEngines()) continue;
                bestEngineSpeed = part.engineSpeed;
                bestEngineStack = (ItemStack)engines.get(part);
            }
            this.field_73882_e.field_71446_o.func_110577_a(texture);
            if (bestEngineStack == null) {
                this.func_73729_b(this.guiOriginX + 152, this.guiOriginY + 138, 195, 11, 16, 16);
                this.canCraft = false;
            } else {
                this.drawSlotInventory(bestEngineStack, this.guiOriginX + 152, this.guiOriginY + 138);
            }
        }
        if (!this.canCraft) {
            this.field_73882_e.field_71446_o.func_110577_a(texture);
            this.func_73729_b(this.guiOriginX + 108, this.guiOriginY + 160, 176, 28, 44, 24);
            this.func_73731_b(this.field_73886_k, "Craft", this.guiOriginX + 116, this.guiOriginY + 168, 0xA0A0A0);
        } else {
            super.func_73863_a(i, j, f);
        }
    }

    private void drawSlotInventory(ItemStack itemstack, int i, int j) {
        if (itemstack == null || itemstack.field_77993_c == 0 || itemstack.func_77973_b() == null) {
            return;
        }
        itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, itemstack, i, j);
        itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, itemstack, i, j);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    protected void func_73869_a(char c, int i) {
        if (i == 1 || i == this.field_73882_e.field_71474_y.field_74315_B.field_74512_d) {
            this.field_73882_e.field_71439_g.func_71053_j();
        }
    }

    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        int x = i - this.guiOriginX;
        int y = j - this.guiOriginY;
        if (k == 0 || k == 1) {
            DriveableType selectedType;
            for (int m = 0; m < 2; ++m) {
                for (int n = 0; n < 8; ++n) {
                    if (x < 8 + n * 18 || x > 26 + n * 18 || y < 18 + 18 * m || y > 42 + 18 * m) continue;
                    selectedBlueprint = blueprintsScroll * 8 + m * 8 + n;
                }
            }
            if (x >= 157 && x <= 167 && y >= 21 && y <= 31 && blueprintsScroll > 0) {
                --blueprintsScroll;
            }
            if (x >= 157 && x <= 167 && y >= 39 && y <= 49 && blueprintsScroll * 8 + 16 < DriveableType.types.size()) {
                ++blueprintsScroll;
            }
            if (selectedBlueprint >= DriveableType.types.size()) {
                return;
            }
            if (x >= 83 && x <= 93 && y >= 141 && y <= 151 && this.recipeScroll > 0) {
                --this.recipeScroll;
            }
            if (x >= 83 && x <= 93 && y >= 177 && y <= 187 && (selectedType = DriveableType.types.get(selectedBlueprint)) != null && this.recipeScroll * 4 + 12 < selectedType.recipe.size()) {
                ++this.recipeScroll;
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

