/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.guns;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.RotatedAxes;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.guns.EntityDamageSourceGun;
import co.uk.flansmods.common.guns.FlansModExplosion;
import co.uk.flansmods.common.guns.GrenadeType;
import co.uk.flansmods.common.teams.TeamsManager;
import co.uk.flansmods.common.vector.Vector3f;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityGrenade
extends Entity
implements IEntityAdditionalSpawnData {
    public GrenadeType type;
    public EntityLivingBase thrower;
    public RotatedAxes axes = new RotatedAxes();
    public Vector3f angularVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
    public float prevRotationRoll = 0.0f;
    public int smokeTime = 0;
    public boolean smoking = false;
    public boolean stuck = false;
    public int stuckToX;
    public int stuckToY;
    public int stuckToZ;
    public boolean detonated = false;

    public EntityGrenade(World w) {
        super(w);
    }

    public EntityGrenade(World w, GrenadeType g, EntityLivingBase t) {
        this(w);
        this.func_70107_b(t.field_70165_t, t.field_70163_u + (double)t.func_70047_e(), t.field_70161_v);
        this.type = g;
        this.thrower = t;
        this.func_70105_a(g.hitBoxSize, g.hitBoxSize);
        this.axes.setAngles(t.field_70177_z + 90.0f, g.spinWhenThrown ? t.field_70125_A : 0.0f, 0.0f);
        this.field_70126_B = g.spinWhenThrown ? t.field_70177_z + 90.0f : 0.0f;
        this.field_70177_z = this.field_70126_B;
        this.field_70125_A = this.field_70127_C = t.field_70125_A;
        float speed = 0.5f * this.type.throwSpeed;
        this.field_70159_w = this.axes.getXAxis().x * speed;
        this.field_70181_x = this.axes.getXAxis().y * speed;
        this.field_70179_y = this.axes.getXAxis().z * speed;
        if (this.type.spinWhenThrown) {
            this.angularVelocity = new Vector3f(0.0f, 0.0f, 10.0f);
        }
    }

    public void func_70071_h_() {
        List list;
        super.func_70071_h_();
        if (this.type.despawnTime > 0 && this.field_70173_aa > this.type.despawnTime) {
            this.detonated = true;
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.type.trailParticles) {
                this.field_70170_p.func_72869_a(this.type.trailParticleType, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            }
            if (!this.smoking) {
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_72869_a(this.type.trailParticleType, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + this.field_70146_Z.nextGaussian(), this.field_70161_v + this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0);
                }
                --this.smokeTime;
                if (this.smokeTime == 0) {
                    this.func_70106_y();
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa > this.type.fuse && this.type.fuse > 0) {
                this.detonate();
            }
            if (this.type.livingProximityTrigger > 0.0f || this.type.driveableProximityTrigger > 0.0f) {
                float checkRadius = Math.max(this.type.livingProximityTrigger, this.type.driveableProximityTrigger);
                list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)checkRadius, (double)checkRadius, (double)checkRadius));
                for (Object obj : list) {
                    if (obj == this.thrower && this.field_70173_aa < 10) continue;
                    if (obj instanceof EntityLivingBase && this.func_70032_d((Entity)obj) < this.type.livingProximityTrigger) {
                        if (TeamsManager.getInstance() != null && TeamsManager.getInstance().currentGametype != null && obj instanceof EntityPlayerMP && this.thrower instanceof EntityPlayer && !TeamsManager.getInstance().currentGametype.playerAttacked((EntityPlayerMP)obj, (DamageSource)new EntityDamageSourceGun(this.type.shortName, this, (EntityPlayer)this.thrower, this.type))) continue;
                        this.detonate();
                        break;
                    }
                    if (!(obj instanceof EntityDriveable) || !(this.func_70032_d((Entity)obj) < this.type.driveableProximityTrigger)) continue;
                    this.detonate();
                    break;
                }
            }
        }
        if (this.stuck && this.field_70170_p.func_72799_c(this.stuckToX, this.stuckToY, this.stuckToZ)) {
            this.stuck = false;
        }
        if (!this.stuck) {
            this.field_70126_B = this.axes.getYaw();
            this.field_70127_C = this.axes.getPitch();
            this.prevRotationRoll = this.axes.getRoll();
            if (this.angularVelocity.lengthSquared() > 1.0E-8f) {
                this.axes.rotateLocal(this.angularVelocity.length(), this.angularVelocity.normalise(null));
            }
            Vector3f posVec = new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vector3f motVec = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            Vector3f nextPosVec = Vector3f.add(posVec, motVec, null);
            MovingObjectPosition hit = this.field_70170_p.func_72933_a(posVec.toVec3(), nextPosVec.toVec3());
            if (hit != null && hit.field_72313_a == EnumMovingObjectType.TILE) {
                int blockID = this.field_70170_p.func_72798_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                Material mat = this.field_70170_p.func_72803_f(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                if (this.type.detonateOnImpact) {
                    this.detonate();
                } else if (this.type.breaksGlass && mat == Material.field_76264_q && FlansMod.canBreakGlass) {
                    this.field_70170_p.func_94571_i(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                    FlansMod.proxy.playBlockBreakSound(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, blockID);
                } else if (!this.type.penetratesBlocks) {
                    Vector3f hitVec = new Vector3f(hit.field_72307_f);
                    Vector3f preHitMotVec = Vector3f.sub(hitVec, posVec, null);
                    Vector3f postHitMotVec = Vector3f.sub(motVec, preHitMotVec, null);
                    int sideHit = hit.field_72310_e;
                    switch (sideHit) {
                        case 0: 
                        case 1: {
                            postHitMotVec.setY(-postHitMotVec.getY());
                            break;
                        }
                        case 4: 
                        case 5: {
                            postHitMotVec.setX(-postHitMotVec.getX());
                            break;
                        }
                        case 2: 
                        case 3: {
                            postHitMotVec.setZ(-postHitMotVec.getZ());
                        }
                    }
                    float lambda = Math.abs(motVec.lengthSquared()) < 1.0E-8f ? 1.0f : postHitMotVec.length() / motVec.length();
                    postHitMotVec.scale(this.type.bounciness / 2.0f);
                    this.field_70165_t += (double)(preHitMotVec.x + postHitMotVec.x);
                    this.field_70163_u += (double)(preHitMotVec.y + postHitMotVec.y);
                    this.field_70161_v += (double)(preHitMotVec.z + postHitMotVec.z);
                    this.field_70159_w = postHitMotVec.x / lambda;
                    this.field_70181_x = postHitMotVec.y / lambda;
                    this.field_70179_y = postHitMotVec.z / lambda;
                    motVec = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    float randomSpinner = 90.0f;
                    Vector3f.add(this.angularVelocity, new Vector3f(this.field_70146_Z.nextGaussian() * (double)randomSpinner, this.field_70146_Z.nextGaussian() * (double)randomSpinner, this.field_70146_Z.nextGaussian() * (double)randomSpinner), this.angularVelocity);
                    this.angularVelocity.scale(motVec.lengthSquared());
                    if ((double)motVec.lengthSquared() > 0.01) {
                        this.func_85030_a(this.type.bounceSound, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    }
                    if (this.type.sticky) {
                        this.field_70165_t = hitVec.x;
                        this.field_70163_u = hitVec.y;
                        this.field_70161_v = hitVec.z;
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 0.0;
                        this.field_70159_w = 0.0;
                        this.angularVelocity.set(0.0f, 0.0f, 0.0f);
                        float yaw = this.axes.getYaw();
                        switch (hit.field_72310_e) {
                            case 0: {
                                this.axes.setAngles(yaw, 180.0f, 0.0f);
                                break;
                            }
                            case 1: {
                                this.axes.setAngles(yaw, 0.0f, 0.0f);
                                break;
                            }
                            case 2: {
                                this.axes.setAngles(270.0f, 90.0f, 0.0f);
                                this.axes.rotateLocalYaw(yaw);
                                break;
                            }
                            case 3: {
                                this.axes.setAngles(90.0f, 90.0f, 0.0f);
                                this.axes.rotateLocalYaw(yaw);
                                break;
                            }
                            case 4: {
                                this.axes.setAngles(180.0f, 90.0f, 0.0f);
                                this.axes.rotateLocalYaw(yaw);
                                break;
                            }
                            case 5: {
                                this.axes.setAngles(0.0f, 90.0f, 0.0f);
                                this.axes.rotateLocalYaw(yaw);
                            }
                        }
                        this.stuck = true;
                        this.stuckToX = hit.field_72311_b;
                        this.stuckToY = hit.field_72312_c;
                        this.stuckToZ = hit.field_72309_d;
                    }
                }
            } else {
                this.field_70165_t += this.field_70159_w;
                this.field_70163_u += this.field_70181_x;
                this.field_70161_v += this.field_70179_y;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.type.hitEntityDamage > 0 && !this.stuck) {
            Vector3f motVec = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
            for (Object obj : list) {
                if (obj == this.thrower && this.field_70173_aa < 10 || (double)motVec.lengthSquared() < 0.01 || !(obj instanceof EntityLivingBase)) continue;
                System.out.println("Damage: " + (float)this.type.hitEntityDamage * motVec.lengthSquared() * 3.0f);
                ((EntityLivingBase)obj).func_70097_a(this.getGrenadeDamage(), (float)this.type.hitEntityDamage * motVec.lengthSquared() * 3.0f);
            }
        }
        this.field_70181_x -= 0.024525 * (double)this.type.fallSpeed;
    }

    public boolean func_70097_a(DamageSource source, float f) {
        if (this.type.detonateWhenShot) {
            this.detonate();
        }
        return this.type.detonateWhenShot;
    }

    public void detonate() {
        if (this.field_70173_aa < this.type.primeDelay) {
            return;
        }
        if (this.detonated) {
            return;
        }
        this.detonated = true;
        this.func_85030_a(this.type.detonateSound, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        if (!this.field_70170_p.field_72995_K && this.type.explosionRadius > 0.1f) {
            if (this.thrower instanceof EntityPlayer) {
                new FlansModExplosion(this.field_70170_p, this, (EntityPlayer)this.thrower, this.type, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.explosionRadius, FlansMod.explosions && this.type.explosionBreaksBlocks);
            } else {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.explosionRadius, FlansMod.explosions && this.type.explosionBreaksBlocks);
            }
        }
        if (this.type.fireRadius > 0.1f) {
            for (float i = -this.type.fireRadius; i < this.type.fireRadius; i += 1.0f) {
                for (float j = -this.type.fireRadius; j < this.type.fireRadius; j += 1.0f) {
                    for (float k = -this.type.fireRadius; k < this.type.fireRadius; k += 1.0f) {
                        int z;
                        int y;
                        int x = MathHelper.func_76141_d((float)i);
                        if (this.field_70170_p.func_72798_a(x, y = MathHelper.func_76141_d((float)j), z = MathHelper.func_76141_d((float)k)) != 0) continue;
                        this.field_70170_p.func_94575_c(x, y, z, Block.field_72067_ar.field_71990_ca);
                    }
                }
            }
        }
        for (int i = 0; i < this.type.explodeParticles; ++i) {
            this.field_70170_p.func_72869_a(this.type.explodeParticleType, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian());
        }
        if (!this.field_70170_p.field_72995_K && this.type.dropItemOnDetonate != null) {
            String itemName = this.type.dropItemOnDetonate;
            int damage = 0;
            if (itemName.contains(".")) {
                damage = Integer.parseInt(itemName.split("\\.")[1]);
                itemName = itemName.split("\\.")[0];
            }
            ItemStack dropStack = InfoType.getRecipeElement(itemName, damage);
            this.func_70099_a(dropStack, 1.0f);
        }
        if (this.type.smokeTime > 0) {
            this.smoking = true;
            this.smokeTime = this.type.smokeTime;
        } else {
            this.func_70106_y();
        }
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int i) {
    }

    private DamageSource getGrenadeDamage() {
        if (this.thrower instanceof EntityPlayer) {
            return new EntityDamageSourceGun(this.type.shortName, this, (EntityPlayer)this.thrower, this.type).func_76349_b();
        }
        return new EntityDamageSourceIndirect(this.type.shortName, (Entity)this, (Entity)this.thrower).func_76349_b();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tags) {
        this.type = GrenadeType.getGrenade(tags.func_74779_i("Type"));
        this.thrower = this.field_70170_p.func_72924_a(tags.func_74779_i("Thrower"));
        this.field_70177_z = tags.func_74760_g("RotationYaw");
        this.field_70125_A = tags.func_74760_g("RotationPitch");
        this.axes.setAngles(this.field_70177_z, this.field_70125_A, 0.0f);
    }

    protected void func_70014_b(NBTTagCompound tags) {
        tags.func_74778_a("Type", this.type.shortName);
        if (this.thrower != null) {
            tags.func_74778_a("Thrower", this.thrower.func_70023_ak());
        }
        tags.func_74776_a("RotationYaw", this.axes.getYaw());
        tags.func_74776_a("RotationPitch", this.axes.getPitch());
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeUTF(this.type.shortName);
        data.writeInt(this.thrower == null ? 0 : this.thrower.field_70157_k);
        data.writeFloat(this.axes.getYaw());
        data.writeFloat(this.axes.getPitch());
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.type = GrenadeType.getGrenade(data.readUTF());
        this.thrower = (EntityLivingBase)this.field_70170_p.func_73045_a(data.readInt());
        this.func_70101_b(data.readFloat(), data.readFloat());
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.axes.setAngles(this.field_70177_z, this.field_70125_A, 0.0f);
        if (this.type.spinWhenThrown) {
            this.angularVelocity = new Vector3f(0.0f, 0.0f, 10.0f);
        }
    }
}

