/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.guns;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.guns.BulletType;
import co.uk.flansmods.common.guns.EnumFireMode;
import co.uk.flansmods.common.guns.GunType;
import co.uk.flansmods.common.guns.ItemBullet;
import co.uk.flansmods.common.network.PacketMGFire;
import co.uk.flansmods.common.network.PacketMGMount;
import co.uk.flansmods.common.network.PacketPlaySound;
import co.uk.flansmods.common.teams.EntityGunItem;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;

public class EntityMG
extends Entity
implements IEntityAdditionalSpawnData {
    public int blockX;
    public int blockY;
    public int blockZ;
    public int direction;
    public GunType type;
    public ItemStack ammo;
    public int reloadTimer;
    public int soundDelay;
    public int shootDelay;
    public static List<EntityMG> mgs = new ArrayList<EntityMG>();
    public EntityPlayer gunner;
    public boolean isShooting;
    public boolean wasShooting = false;
    public int ticksSinceUsed = 0;

    public EntityMG(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70158_ak = true;
    }

    public EntityMG(World world, int x, int y, int z, int dir, GunType gunType) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
        this.field_70169_q = (double)x + 0.5;
        this.field_70167_r = y;
        this.field_70166_s = (double)z + 0.5;
        this.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
        this.direction = dir;
        this.field_70177_z = 0.0f;
        this.field_70125_A = -60.0f;
        this.type = gunType;
        this.field_70158_ak = true;
        mgs.add(this);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        int slot;
        super.func_70071_h_();
        ++this.ticksSinceUsed;
        if (FlansMod.mgLife > 0 && this.ticksSinceUsed > FlansMod.mgLife * 20) {
            this.func_70106_y();
        }
        if (this.field_70170_p.func_72798_a(this.blockX, this.blockY - 1, this.blockZ) == 0 && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        if (this.gunner != null) {
            this.ticksSinceUsed = 0;
            this.field_70177_z = this.gunner.field_70177_z - (float)(this.direction * 90);
            while (this.field_70177_z < -180.0f) {
                this.field_70177_z += 360.0f;
            }
            while (this.field_70177_z > 180.0f) {
                this.field_70177_z -= 360.0f;
            }
            this.field_70125_A = this.gunner.field_70125_A;
            if (this.field_70177_z > this.type.sideViewLimit) {
                this.field_70126_B = this.field_70177_z = this.type.sideViewLimit;
            }
            if (this.field_70177_z < -this.type.sideViewLimit) {
                this.field_70126_B = this.field_70177_z = -this.type.sideViewLimit;
            }
            float angle = (float)this.direction * 90.0f + this.field_70177_z;
            double dX = (double)this.type.standBackDist * Math.sin(angle * (float)Math.PI / 180.0f);
            double dZ = -((double)this.type.standBackDist * Math.cos(angle * (float)Math.PI / 180.0f));
            this.gunner.func_70107_b((double)this.blockX + 0.5 + dX, (double)this.blockY + this.gunner.func_70033_W() - 0.5, (double)this.blockZ + 0.5 + dZ);
        } else {
            this.field_70125_A -= 1.0f;
        }
        if (this.field_70125_A < this.type.topViewLimit) {
            this.field_70125_A = this.type.topViewLimit;
        }
        if (this.field_70125_A > this.type.bottomViewLimit) {
            this.field_70125_A = this.type.bottomViewLimit;
        }
        if (this.shootDelay > 0) {
            --this.shootDelay;
        }
        if (this.reloadTimer > 0) {
            --this.reloadTimer;
        }
        if (this.ammo != null && this.ammo.func_77960_j() == this.ammo.func_77958_k()) {
            this.ammo = null;
        }
        if (this.ammo == null && this.gunner != null && (slot = this.findAmmo(this.gunner)) >= 0) {
            this.ammo = this.gunner.field_71071_by.func_70301_a(slot);
            if (!this.gunner.field_71075_bZ.field_75098_d) {
                this.gunner.field_71071_by.func_70299_a(slot, null);
            }
            this.reloadTimer = this.type.reloadTime;
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)50.0, (int)this.field_71093_bK, (Packet)PacketPlaySound.buildSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.reloadSound));
        }
        if (this.field_70170_p.field_72995_K && this.gunner != null && this.gunner == FMLClientHandler.instance().getClient().field_71439_g && this.type.mode == EnumFireMode.FULLAUTO) {
            this.checkForShooting();
        }
        if (!this.field_70170_p.field_72995_K && this.isShooting) {
            if (this.gunner == null || this.gunner.field_70128_L) {
                this.isShooting = false;
            }
            if (this.ammo == null || this.reloadTimer > 0 || this.shootDelay > 0) {
                return;
            }
            BulletType bullet = BulletType.getBullet(this.ammo.field_77993_c);
            if (this.gunner != null && !this.gunner.field_71075_bZ.field_75098_d) {
                this.ammo.func_77972_a(1, (EntityLivingBase)this.gunner);
            }
            this.shootDelay = this.type.shootDelay;
            this.field_70170_p.func_72838_d(((ItemBullet)this.ammo.func_77973_b()).getEntity(this.field_70170_p, Vec3.func_72443_a((double)((double)this.blockX + 0.5), (double)((float)this.blockY + this.type.pivotHeight), (double)((double)this.blockZ + 0.5)), (float)this.direction * 90.0f + this.field_70177_z, this.field_70125_A, (EntityLivingBase)this.gunner, this.type.bulletSpread, this.type.damage, this.ammo.func_77960_j(), (InfoType)this.type));
            if (this.soundDelay <= 0) {
                this.soundDelay = this.type.shootSoundLength;
                PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)50.0, (int)this.field_71093_bK, (Packet)PacketPlaySound.buildSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.shootSound, this.type.distortSound));
            }
        }
        if (this.soundDelay > 0) {
            --this.soundDelay;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void checkForShooting() {
        if (Mouse.isButtonDown((int)0) && !this.wasShooting && !FlansMod.proxy.isScreenOpen()) {
            PacketDispatcher.sendPacketToServer((Packet)PacketMGFire.buildMGFirePacket(true));
            this.wasShooting = true;
        } else if (!Mouse.isButtonDown((int)0) && this.wasShooting) {
            PacketDispatcher.sendPacketToServer((Packet)PacketMGFire.buildMGFirePacket(false));
            this.wasShooting = false;
        }
    }

    public void mouseHeld(boolean held) {
        this.isShooting = held;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (damagesource.field_76373_n.equals("player")) {
            Entity player = ((EntityDamageSource)damagesource).func_76346_g();
            if (player == this.gunner) {
                if (this.type.mode == EnumFireMode.FULLAUTO) {
                    return true;
                }
                if (this.ammo == null || this.reloadTimer > 0 || this.shootDelay > 0) {
                    return true;
                }
                BulletType bullet = BulletType.getBullet(this.ammo.field_77993_c);
                if (this.gunner != null && !this.gunner.field_71075_bZ.field_75098_d) {
                    this.ammo.func_77972_a(1, (EntityLivingBase)((EntityLiving)player));
                }
                this.shootDelay = this.type.shootDelay;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d(((ItemBullet)this.ammo.func_77973_b()).getEntity(this.field_70170_p, (EntityLivingBase)player, this.type.bulletSpread, this.type.damage, this.type.bulletSpeed, false, this.ammo.func_77960_j(), this.type));
                }
                if (this.soundDelay <= 0) {
                    float distortion = this.type.distortSound ? 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f) : 1.0f;
                    PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)50.0, (int)this.field_71093_bK, (Packet)PacketPlaySound.buildSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.shootSound, this.type.distortSound));
                    this.soundDelay = this.type.shootSoundLength;
                }
            } else {
                if (this.gunner != null) {
                    return this.gunner.func_70097_a(damagesource, i);
                }
                if (FlansMod.canBreakGuns) {
                    this.func_70106_y();
                }
            }
        }
        return true;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (this.gunner != null && this.gunner instanceof EntityPlayer && this.gunner != player) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            int slot;
            if (this.gunner == player) {
                this.mountGun(player, false);
                PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)100.0, (int)this.field_71093_bK, (Packet)PacketMGMount.buildMGPacket(player, this, false));
                return true;
            }
            if (FlansModPlayerHandler.getPlayerData((EntityPlayer)player).mountingGun != null && !FlansModPlayerHandler.getPlayerData((EntityPlayer)player).mountingGun.field_70128_L) {
                return true;
            }
            this.mountGun(player, true);
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)100.0, (int)this.field_71093_bK, (Packet)PacketMGMount.buildMGPacket(player, this, true));
            if (this.ammo == null && (slot = this.findAmmo(player)) >= 0) {
                this.ammo = player.field_71071_by.func_70301_a(slot);
                player.field_71071_by.func_70299_a(slot, null);
                this.reloadTimer = this.type.reloadTime;
                this.field_70170_p.func_72956_a((Entity)this, this.type.reloadSound, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            }
        }
        return true;
    }

    public void mountGun(EntityPlayer player, boolean mounting) {
        Side side;
        if (player == null) {
            return;
        }
        Side side2 = side = this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER;
        if (mounting) {
            this.gunner = player;
            FlansModPlayerHandler.getPlayerData((EntityPlayer)this.gunner, (Side)side).mountingGun = this;
        } else {
            FlansModPlayerHandler.getPlayerData((EntityPlayer)this.gunner, (Side)side).mountingGun = null;
            this.gunner = null;
        }
    }

    public int findAmmo(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!this.type.isAmmo(stack)) continue;
            return i;
        }
        return -1;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            if (FlansMod.weaponDrops == 2) {
                EntityGunItem gunEntity = new EntityGunItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(this.type.getItem()), Arrays.asList(this.ammo));
                this.field_70170_p.func_72838_d((Entity)gunEntity);
            } else if (FlansMod.weaponDrops == 1) {
                this.func_70025_b(this.type.getItem().field_77779_bT, 1);
                if (this.ammo != null) {
                    this.func_70099_a(this.ammo, 0.5f);
                }
            }
        }
        if (this.gunner != null && FlansModPlayerHandler.getPlayerData(this.gunner) != null) {
            FlansModPlayerHandler.getPlayerData((EntityPlayer)this.gunner).mountingGun = null;
        }
        super.func_70106_y();
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("Type", this.type.shortName);
        if (this.ammo != null) {
            nbttagcompound.func_74777_a("AmmoID", (short)this.ammo.field_77993_c);
            nbttagcompound.func_74777_a("AmmoDamage", (short)this.ammo.func_77960_j());
        }
        nbttagcompound.func_74768_a("BlockX", this.blockX);
        nbttagcompound.func_74768_a("BlockY", this.blockY);
        nbttagcompound.func_74768_a("BlockZ", this.blockZ);
        nbttagcompound.func_74774_a("Dir", (byte)this.direction);
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.type = GunType.getGun(nbttagcompound.func_74779_i("Type"));
        this.blockX = nbttagcompound.func_74762_e("BlockX");
        this.blockY = nbttagcompound.func_74762_e("BlockY");
        this.blockZ = nbttagcompound.func_74762_e("BlockZ");
        this.direction = nbttagcompound.func_74771_c("Dir");
        short ammoID = nbttagcompound.func_74765_d("AmmoID");
        short ammoDamage = nbttagcompound.func_74765_d("AmmoDamage");
        if (ammoID > 0) {
            this.ammo = new ItemStack((int)ammoID, 1, (int)ammoDamage);
        }
    }

    protected void func_70088_a() {
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeUTF(this.type.shortName);
        data.writeInt(this.direction);
        data.writeInt(this.blockX);
        data.writeInt(this.blockY);
        data.writeInt(this.blockZ);
        if (this.ammo != null) {
            data.writeBoolean(true);
            data.writeInt(this.ammo.field_77993_c);
            data.writeInt(this.ammo.func_77960_j());
        } else {
            data.writeBoolean(false);
        }
    }

    public void readSpawnData(ByteArrayDataInput data) {
        try {
            this.type = GunType.getGun(data.readUTF());
            this.direction = data.readInt();
            this.blockX = data.readInt();
            this.blockY = data.readInt();
            this.blockZ = data.readInt();
            if (data.readBoolean()) {
                this.ammo = new ItemStack(data.readInt(), 1, data.readInt());
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to retreive gun type from server.");
            super.func_70106_y();
            e.printStackTrace();
        }
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        ItemStack stack = new ItemStack(this.type.itemID, 1, 0);
        return stack;
    }
}

