/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.network;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.network.FlanPacketCommon;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class PacketSeatUpdates
extends FlanPacketCommon {
    public static final byte packetID = 21;

    public static Packet buildUpdatePacket(EntitySeat seat) {
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = channelFlan;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(21);
            data.writeInt(seat.driveable.field_70157_k);
            data.writeInt(seat.seatInfo.id);
            data.writeFloat(seat.looking.getYaw());
            data.writeFloat(seat.looking.getPitch());
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            data.close();
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packet;
    }

    @Override
    public void interpret(DataInputStream stream, Object[] extradata, Side side) {
        try {
            EntityPlayer player = (EntityPlayer)extradata[0];
            int entityId = stream.readInt();
            EntityDriveable driveable = null;
            for (Object obj : player.field_70170_p.field_72996_f) {
                if (!(obj instanceof EntityDriveable) || ((Entity)obj).field_70157_k != entityId) continue;
                driveable = (EntityDriveable)obj;
                break;
            }
            if (driveable != null) {
                int seatID = stream.readInt();
                float yaw = stream.readFloat();
                float pitch = stream.readFloat();
                if (side == Side.CLIENT && driveable.seats[seatID] != null && driveable.seats[seatID].field_70153_n == player) {
                    return;
                }
                driveable.seats[seatID].prevLooking = driveable.seats[seatID].looking.clone();
                driveable.seats[seatID].looking.setAngles(yaw, pitch, 0.0f);
                if (side == Side.SERVER) {
                    PacketDispatcher.sendPacketToAllAround((double)driveable.field_70165_t, (double)driveable.field_70163_u, (double)driveable.field_70161_v, (double)50.0, (int)driveable.field_71093_bK, (Packet)PacketSeatUpdates.buildUpdatePacket(driveable.seats[seatID]));
                }
            }
        }
        catch (Exception e) {
            FlansMod.log("Error parsing seat updates packet");
            e.printStackTrace();
        }
    }

    @Override
    public byte getPacketID() {
        return 21;
    }
}

