/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.ItemPlane;
import co.uk.flansmods.common.ItemVehicle;
import co.uk.flansmods.common.guns.ItemAAGun;
import co.uk.flansmods.common.teams.EntityTeamItem;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;

public class TileEntitySpawner
extends TileEntity
implements ITeamObject {
    public int spawnDelay = 1200;
    public List<ItemStack> stacksToSpawn = new ArrayList<ItemStack>();
    public List<EntityTeamItem> itemEntities = new ArrayList<EntityTeamItem>();
    public Entity spawnedEntity;
    public ITeamBase base;
    private int baseID = -1;
    private int dimension;
    public int currentDelay;
    private ForgeChunkManager.Ticket chunkTicket;
    private boolean uninitialized = true;
    private int loadDistance = 1;
    private String team;

    public TileEntitySpawner() {
        TeamsManager.getInstance().registerObject(this);
    }

    public Packet func_70319_e() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Team", this.base == null || this.base.getOwner() == null ? "none" : this.base.getOwner().shortName);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tags);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.team = packet.field_73331_e.func_74779_i("Team");
    }

    public void func_70316_g() {
        int i;
        ITeamBase newBase;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.updateChunkLoading();
        if (this.baseID >= 0 && this.base == null && (newBase = TeamsManager.getInstance().getBase(this.baseID)) != null) {
            this.setBase(newBase);
            newBase.addObject(this);
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n) != FlansMod.spawnerID) {
            this.destroy();
            return;
        }
        if (this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n) == 1) {
            return;
        }
        for (i = this.itemEntities.size() - 1; i >= 0; --i) {
            if (!this.itemEntities.get((int)i).field_70128_L) continue;
            this.itemEntities.remove(i);
        }
        if (this.currentDelay > 0 && this.itemEntities.size() == 0) {
            --this.currentDelay;
        }
        if (this.currentDelay == 0) {
            this.currentDelay = this.spawnDelay;
            for (i = 0; i < this.stacksToSpawn.size(); ++i) {
                if (this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n) == 2) {
                    if (this.spawnedEntity != null && !this.spawnedEntity.field_70128_L) continue;
                    ItemStack stack = this.stacksToSpawn.get(i);
                    if (stack != null && stack.func_77973_b() instanceof ItemPlane) {
                        this.spawnedEntity = ((ItemPlane)stack.func_77973_b()).spawnPlane(this.field_70331_k, (float)this.field_70329_l + 0.5f, (float)this.field_70330_m + 0.5f, (float)this.field_70327_n + 0.5f, stack);
                    }
                    if (stack != null && stack.func_77973_b() instanceof ItemVehicle) {
                        this.spawnedEntity = ((ItemVehicle)stack.func_77973_b()).spawnVehicle(this.field_70331_k, (float)this.field_70329_l + 0.5f, (float)this.field_70330_m + 0.5f, (float)this.field_70327_n + 0.5f, stack);
                    }
                    if (stack == null || !(stack.func_77973_b() instanceof ItemAAGun)) continue;
                    this.spawnedEntity = ((ItemAAGun)stack.func_77973_b()).spawnAAGun(this.field_70331_k, (float)this.field_70329_l + 0.5f, this.field_70330_m, (float)this.field_70327_n + 0.5f, stack);
                    continue;
                }
                EntityTeamItem itemEntity = new EntityTeamItem(this, i);
                this.field_70331_k.func_72838_d((Entity)itemEntity);
            }
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("delay", this.spawnDelay);
        nbt.func_74768_a("Base", this.baseID);
        nbt.func_74768_a("dim", this.field_70331_k.field_73011_w.field_76574_g);
        nbt.func_74768_a("numStacks", this.stacksToSpawn.size());
        for (int i = 0; i < this.stacksToSpawn.size(); ++i) {
            NBTTagCompound stackNBT = new NBTTagCompound();
            this.stacksToSpawn.get(i).func_77955_b(stackNBT);
            nbt.func_74766_a("stack" + i, stackNBT);
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.currentDelay = this.spawnDelay = nbt.func_74762_e("delay");
        this.baseID = nbt.func_74762_e("Base");
        this.dimension = nbt.func_74762_e("dim");
        this.setBase(TeamsManager.getInstance().getBase(this.baseID));
        if (this.base != null) {
            this.base.addObject(this);
        }
        for (int i = 0; i < nbt.func_74762_e("numStacks"); ++i) {
            this.stacksToSpawn.add(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("stack" + i)));
        }
    }

    @Override
    public ITeamBase getBase() {
        return this.base;
    }

    public Team getTeam() {
        if (this.field_70331_k.field_72995_K) {
            return Team.getTeam(this.team);
        }
        return this.base == null ? null : this.base.getOwner();
    }

    @Override
    public void onBaseSet(Team newOwners) {
        PacketDispatcher.sendPacketToAllInDimension((Packet)this.func_70319_e(), (int)(this.field_70331_k == null ? this.dimension : this.field_70331_k.field_73011_w.field_76574_g));
    }

    @Override
    public void onBaseCapture(Team newOwners) {
        this.onBaseSet(newOwners);
    }

    @Override
    public void setBase(ITeamBase b) {
        this.base = b;
        if (b != null) {
            this.baseID = b.getID();
        }
        PacketDispatcher.sendPacketToAllInDimension((Packet)this.func_70319_e(), (int)(this.field_70331_k == null ? this.dimension : this.field_70331_k.field_73011_w.field_76574_g));
    }

    @Override
    public void tick() {
    }

    @Override
    public void destroy() {
        this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 5);
    }

    @Override
    public double getPosX() {
        return (float)this.field_70329_l + 0.5f;
    }

    @Override
    public double getPosY() {
        return (float)this.field_70330_m + 0.5f;
    }

    @Override
    public double getPosZ() {
        return (float)this.field_70327_n + 0.5f;
    }

    @Override
    public boolean isSpawnPoint() {
        int metadata = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return metadata == 1;
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        this.chunkTicket = ticket;
        for (ChunkCoordIntPair coord : this.getLoadArea()) {
            FlansMod.log(String.format("Force loading chunk %s in %s", coord, this.field_70331_k.field_73011_w.getClass()));
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)coord);
        }
    }

    public List<ChunkCoordIntPair> getLoadArea() {
        LinkedList<ChunkCoordIntPair> loadArea = new LinkedList<ChunkCoordIntPair>();
        Chunk centerChunk = this.field_70331_k.func_72938_d(this.field_70329_l, this.field_70327_n);
        loadArea.add(new ChunkCoordIntPair(centerChunk.field_76635_g, centerChunk.field_76647_h));
        return loadArea;
    }

    public void updateChunkLoading() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.uninitialized && this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)FlansMod.instance, (World)this.field_70331_k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (this.chunkTicket != null) {
                this.forceChunkLoading(this.chunkTicket);
            }
            this.uninitialized = false;
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
    }
}

