/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Library;

import java.util.ArrayList;
import lumien.randomthings.Items.ModItems;
import lumien.randomthings.Library.PotionIds;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ImbuingRecipe {
    ItemStack[] ingredients;
    ItemStack toImbue;
    ItemStack result;
    int recipeID;
    public static ArrayList<ImbuingRecipe> recipes = new ArrayList();

    protected ImbuingRecipe(ItemStack toImbue, ItemStack result, ItemStack[] ingredients) {
        this.result = result;
        this.toImbue = toImbue;
        this.ingredients = ingredients;
        this.recipeID = recipes.size() - 1;
    }

    public static ImbuingRecipe getRecipe(int id) {
        if (id < 0 || id > recipes.size() - 1) {
            return null;
        }
        return recipes.get(id);
    }

    public static ImbuingRecipe findRecipe(ItemStack toImbue, ItemStack[] ingredients) {
        for (ImbuingRecipe ir : recipes) {
            if (!ir.toImbue.func_77969_a(toImbue)) continue;
            boolean notFound = false;
            for (ItemStack nec : ir.ingredients) {
                if (ImbuingRecipe.containsSimiliarItemStack(ingredients, nec)) continue;
                notFound = true;
                break;
            }
            if (notFound) continue;
            return ir;
        }
        return null;
    }

    private static boolean containsSimiliarItemStack(ItemStack[] array, ItemStack is) {
        for (ItemStack isa : array) {
            if (!isa.func_77969_a(is)) continue;
            return true;
        }
        return false;
    }

    public boolean areStacksValid(ItemStack toImbue, ItemStack[] ingredients) {
        if (!this.toImbue.func_77969_a(toImbue) || ingredients.length < this.ingredients.length) {
            return false;
        }
        for (ItemStack is : this.ingredients) {
            if (ImbuingRecipe.containsSimiliarItemStack(ingredients, is)) continue;
            return false;
        }
        return true;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack[] getIngredients() {
        return this.ingredients;
    }

    public int getID() {
        return this.recipeID;
    }

    public ItemStack toImbue() {
        return this.toImbue;
    }

    static {
        if (ModItems.flasks != null) {
            if (PotionIds.imbuePoisonID > 0) {
                recipes.add(new ImbuingRecipe(new ItemStack((Item)Item.field_77726_bs, 1, 0), new ItemStack(ModItems.flasks), new ItemStack[]{new ItemStack(Item.field_77723_bv), new ItemStack(Item.field_77722_bw), new ItemStack(Item.field_77761_aM)}));
            }
            if (PotionIds.imbueWeaknessID > 0) {
                recipes.add(new ImbuingRecipe(new ItemStack((Item)Item.field_77726_bs, 1, 0), new ItemStack(ModItems.flasks, 1, 1), new ItemStack[]{new ItemStack(Block.field_94339_ct, 1, 1), new ItemStack(Item.field_77722_bw), new ItemStack(Item.field_77737_bm)}));
            }
            if (PotionIds.imbueWitherID > 0) {
                recipes.add(new ImbuingRecipe(new ItemStack((Item)Item.field_77726_bs, 1, 0), new ItemStack(ModItems.flasks, 1, 2), new ItemStack[]{new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 1), new ItemStack(Item.field_77722_bw), new ItemStack(Item.field_77755_aX)}));
            }
        }
        recipes.add(new ImbuingRecipe(new ItemStack(Block.field_71978_w, 1, 0), new ItemStack(Block.field_72087_ao), new ItemStack[]{new ItemStack((Item)Item.field_77726_bs), new ItemStack(Item.field_77690_S)}));
    }
}

