/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration;

import codechicken.lib.vec.BlockCoord;
import java.util.LinkedList;
import java.util.Random;
import mrtjp.projectred.exploration.GeneratorOre;

public class GeneratorMetamorphicCave
extends GeneratorOre {
    LinkedList<GeneratorOre.Evaluation> openList = new LinkedList();
    LinkedList<GeneratorOre.Evaluation> closedList = new LinkedList();
    public static int MAX_DIAMETER = 128;

    public GeneratorMetamorphicCave(int id, int meta, int veinSize) {
        super(id, meta, veinSize);
    }

    @Override
    public boolean a(abw world, Random random, int x, int y, int z) {
        int yIndex;
        if (world.a(x, y, z) != 0) {
            return false;
        }
        for (yIndex = y; yIndex <= MAX_DIAMETER && world.a(x, yIndex, z) != aqz.y.cF; ++yIndex) {
        }
        this.addBlockForEvaluation(x, yIndex, z, 6);
        while (this.openList.size() > 0 && this.veinSize > 0) {
            GeneratorOre.Evaluation eval = this.openList.removeFirst();
            this.checkStoneBlock(world, eval.x, eval.y, eval.z, eval.sides);
        }
        return true;
    }

    private void checkStoneBlock(abw world, int x, int y, int z, int sides) {
        if (world.a(x, y, z) == aqz.y.cF) {
            world.f(x, y, z, this.id, this.meta, 2);
            if (sides > 0) {
                this.evaluateNeighbors(world, x, y, z, sides - 1);
            }
            --this.veinSize;
        }
    }

    private boolean isBlockTouchingAir(abw w, BlockCoord b) {
        for (int i = 0; i < 6; ++i) {
            BlockCoord bc = b.copy().offset(i);
            if (w.a(bc.x, bc.y, bc.z) != 0) continue;
            return true;
        }
        return false;
    }

    private void evaluateNeighbors(abw w, int x, int y, int z, int sides) {
        BlockCoord b = new BlockCoord(x, y, z);
        if (this.isBlockTouchingAir(w, b)) {
            sides = 6;
        }
        for (int i = 0; i < 6; ++i) {
            BlockCoord bc = b.copy().offset(i);
            this.addBlockForEvaluation(bc.x, bc.y, bc.z, sides);
        }
    }

    private void addBlockForEvaluation(int x, int y, int z, int sides) {
        GeneratorOre.Evaluation eval = new GeneratorOre.Evaluation(x, y, z, sides);
        if (this.closedList.contains(eval)) {
            return;
        }
        this.openList.add(eval);
        this.closedList.add(eval);
    }
}

