/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.AbstractPair;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import net.minecraft.tileentity.TileEntity;

public abstract class SignalReceiver
extends AbstractPair {
    protected boolean needsInit = true;

    public SignalReceiver(String name, TileEntity tile, int maxPairings) {
        super(name, tile, maxPairings);
    }

    public SignalController getControllerAt(WorldCoordinate coord) {
        TileEntity con = this.getPairAt(coord);
        if (con != null) {
            return ((IControllerTile)con).getController();
        }
        return null;
    }

    @Override
    protected String getTagName() {
        return "receiver";
    }

    @Override
    public boolean isValidPair(TileEntity tile) {
        if (tile instanceof IControllerTile) {
            SignalController controller = ((IControllerTile)tile).getController();
            return controller.isPairedWith(this.getCoords());
        }
        return false;
    }

    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        ((IReceiverTile)this.tile).onControllerAspectChange(con, aspect);
    }

    protected void registerController(SignalController controller) {
        this.addPairing(controller.getCoords());
    }

    @Deprecated
    public void registerLegacyController(int x, int y, int z) {
        this.pairings.add(new WorldCoordinate(0, x, y, z));
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.needsInit) {
            this.needsInit = false;
            for (WorldCoordinate pair : this.pairings) {
                SignalAspect aspect;
                SignalController controller = this.getControllerAt(pair);
                if (controller == null || (aspect = controller.getAspectFor(this.getCoords())) == null) continue;
                this.onControllerAspectChange(controller, aspect);
            }
        }
    }
}

