/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.VillagerRegistry;
import mods.railcraft.client.gui.GuiBasic;
import mods.railcraft.client.gui.buttons.GuiToggleButtonSmall;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.detector.types.DetectorVillager;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.RevolvingList;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.network.packet.Packet;
import org.lwjgl.opengl.GL11;

public class GuiDetectorVillager
extends GuiBasic {
    private final TileDetector tile;
    private final DetectorVillager detector;
    private final EntityVillager villager;
    private DetectorVillager.Mode mode;
    private GuiToggleButtonSmall any;
    private GuiToggleButtonSmall none;
    private GuiToggleButtonSmall equals;
    private GuiToggleButtonSmall not;
    private RevolvingList professions = new RevolvingList();

    public GuiDetectorVillager(TileDetector t) {
        super(t.func_70303_b(), "railcraft:textures/gui/gui_detector_villager.png", 176, 105);
        this.tile = t;
        this.detector = (DetectorVillager)this.tile.getDetector();
        this.villager = new EntityVillager(this.tile.getWorld());
        this.mode = this.detector.getMode();
        for (int prof = 0; prof < 5; ++prof) {
            this.professions.add(prof);
        }
        this.professions.addAll(VillagerRegistry.getRegisteredVillagers());
        this.professions.setCurrent(this.detector.getProfession());
        this.villager.func_70938_b(((Integer)this.professions.getCurrent()).intValue());
    }

    public void func_73866_w_() {
        if (this.tile == null) {
            return;
        }
        this.field_73887_h.clear();
        int w = (this.field_73880_f - this.xSize) / 2;
        int h = (this.field_73881_g - this.ySize) / 2;
        this.field_73887_h.add(new GuiButton(0, w + 10, h + 25, 30, 20, "<"));
        this.field_73887_h.add(new GuiButton(1, w + 135, h + 25, 30, 20, ">"));
        this.any = new GuiToggleButtonSmall(2, w + 10, h + 55, 45, RailcraftLanguage.translate("gui.detector.villager.any"), this.mode == DetectorVillager.Mode.ANY);
        this.field_73887_h.add(this.any);
        this.none = new GuiToggleButtonSmall(3, w + 10, h + 75, 45, RailcraftLanguage.translate("gui.detector.villager.none"), this.mode == DetectorVillager.Mode.NONE);
        this.field_73887_h.add(this.none);
        this.equals = new GuiToggleButtonSmall(4, w + 122, h + 55, 45, RailcraftLanguage.translate("gui.detector.villager.equals"), this.mode == DetectorVillager.Mode.EQUALS);
        this.field_73887_h.add(this.equals);
        this.not = new GuiToggleButtonSmall(5, w + 122, h + 75, 45, RailcraftLanguage.translate("gui.detector.villager.not"), this.mode == DetectorVillager.Mode.NOT);
        this.field_73887_h.add(this.not);
    }

    @Override
    protected void drawExtras(int x, int y, float f) {
        int guiLeft = (this.field_73880_f - this.xSize) / 2;
        int guiTop = (this.field_73881_g - this.ySize) / 2;
        this.drawVillager(87, 91, 30, (float)(guiLeft + 87) - (float)x, (float)(guiTop + 91 - 50) - (float)y);
    }

    public void drawVillager(int x, int y, int scale, float yaw, float pitch) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)50.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(pitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.villager.field_70761_aq = (float)Math.atan(yaw / 40.0f) * 20.0f;
        this.villager.field_70177_z = (float)Math.atan(yaw / 40.0f) * 40.0f;
        this.villager.field_70125_A = -((float)Math.atan(pitch / 40.0f)) * 20.0f;
        this.villager.field_70759_as = this.villager.field_70177_z;
        GL11.glTranslatef((float)0.0f, (float)this.villager.field_70129_M, (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_78719_a((Entity)this.villager, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glPopAttrib();
    }

    protected void func_73875_a(GuiButton button) {
        if (this.tile == null) {
            return;
        }
        switch (button.field_73741_f) {
            case 0: {
                this.professions.rotateLeft();
                break;
            }
            case 1: {
                this.professions.rotateRight();
                break;
            }
            case 2: {
                this.mode = DetectorVillager.Mode.ANY;
                break;
            }
            case 3: {
                this.mode = DetectorVillager.Mode.NONE;
                break;
            }
            case 4: {
                this.mode = DetectorVillager.Mode.EQUALS;
                break;
            }
            case 5: {
                this.mode = DetectorVillager.Mode.NOT;
            }
        }
        this.any.active = this.mode == DetectorVillager.Mode.ANY;
        this.none.active = this.mode == DetectorVillager.Mode.NONE;
        this.equals.active = this.mode == DetectorVillager.Mode.EQUALS;
        this.not.active = this.mode == DetectorVillager.Mode.NOT;
        this.villager.func_70938_b(((Integer)this.professions.getCurrent()).intValue());
    }

    public void func_73874_b() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.detector.setProfession((Integer)this.professions.getCurrent());
            this.detector.setMode(this.mode);
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendPacketToServer((Packet)pkt.getPacket());
        }
    }
}

