/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.cube;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.cube.ItemCube;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.misc.MicroBlockPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class BlockCube
extends Block {
    private static BlockCube instance;
    @SideOnly(value=Side.CLIENT)
    private RenderFakeBlock.RenderInfo override;

    public static BlockCube getBlock() {
        return instance;
    }

    public static void registerBlock() {
        int id;
        if (instance == null && (id = RailcraftConfig.getBlockId("block.cube")) > 0) {
            instance = new BlockCube(id);
            GameRegistry.registerBlock((Block)instance, ItemCube.class, (String)instance.func_71917_a());
            EntityTunnelBore.addMineableBlock(id);
            MinecraftForge.setBlockHarvestLevel((Block)instance, (int)EnumCube.COKE_BLOCK.ordinal(), (String)"pickaxe", (int)1);
            MinecraftForge.setBlockHarvestLevel((Block)instance, (int)EnumCube.ABYSSAL_STONE.ordinal(), (String)"pickaxe", (int)1);
            MinecraftForge.setBlockHarvestLevel((Block)instance, (int)EnumCube.STEEL_BLOCK.ordinal(), (String)"pickaxe", (int)2);
            MinecraftForge.setBlockHarvestLevel((Block)instance, (int)EnumCube.CONCRETE_BLOCK.ordinal(), (String)"pickaxe", (int)1);
            MinecraftForge.setBlockHarvestLevel((Block)instance, (int)EnumCube.CONCRETE_BLOCK.ordinal(), (String)"crowbar", (int)0);
            MinecraftForge.setBlockHarvestLevel((Block)instance, (int)EnumCube.CREOSOTE_BLOCK.ordinal(), (String)"axe", (int)0);
            MinecraftForge.setBlockHarvestLevel((Block)instance, (int)EnumCube.CREOSOTE_BLOCK.ordinal(), (String)"crowbar", (int)0);
            MinecraftForge.setBlockHarvestLevel((Block)instance, (int)EnumCube.CRUSHED_OBSIDIAN.ordinal(), (String)"shovel", (int)3);
            ForestryPlugin.addBackpackItem("miner", EnumCube.COKE_BLOCK.getItem());
            ForestryPlugin.addBackpackItem("builder", EnumCube.CONCRETE_BLOCK.getItem());
            ForestryPlugin.addBackpackItem("builder", EnumCube.CREOSOTE_BLOCK.getItem());
            ForestryPlugin.addBackpackItem("digger", EnumCube.ABYSSAL_STONE.getItem());
            ForestryPlugin.addBackpackItem("digger", EnumCube.QUARRIED_STONE.getItem());
            MicroBlockPlugin.addMicroBlockCandidate(instance, EnumCube.CONCRETE_BLOCK.ordinal());
            MicroBlockPlugin.addMicroBlockCandidate(instance, EnumCube.CREOSOTE_BLOCK.ordinal());
            MicroBlockPlugin.addMicroBlockCandidate(instance, EnumCube.STEEL_BLOCK.ordinal());
            MicroBlockPlugin.addMicroBlockCandidate(instance, EnumCube.ABYSSAL_STONE.ordinal());
            MicroBlockPlugin.addMicroBlockCandidate(instance, EnumCube.QUARRIED_STONE.ordinal());
        }
    }

    public BlockCube(int id) {
        super(id, Material.field_76246_e);
        this.func_71864_b("railcraft.cube");
        this.func_71894_b(20.0f);
        this.func_71848_c(5.0f);
        this.func_71884_a(RailcraftSound.getInstance());
        this.func_71849_a(CreativePlugin.TAB);
    }

    public float func_71934_m(World world, int i, int j, int k) {
        int meta = world.func_72805_g(i, j, k);
        return EnumCube.fromOrdinal(meta).getHardness();
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        for (EnumCube cube : EnumCube.VALUES) {
            if (!cube.isEnabled() || cube == EnumCube.CONCRETE_BLOCK || cube == EnumCube.CREOSOTE_BLOCK) continue;
            cube.setIcon(iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(cube.getTag())));
        }
        EnumCube.CONCRETE_BLOCK.setIcon(iconRegister.func_94245_a("railcraft:concrete"));
        EnumCube.CREOSOTE_BLOCK.setIcon(iconRegister.func_94245_a("railcraft:post.wood"));
    }

    @SideOnly(value=Side.CLIENT)
    public void setTextureOveride(RenderFakeBlock.RenderInfo info) {
        this.override = info;
    }

    public Icon func_71858_a(int side, int meta) {
        if (this.override != null) {
            return this.override.getBlockTextureFromSide(side);
        }
        Icon icon = EnumCube.fromOrdinal(meta).getIcon();
        if (icon == null) {
            return EnumCube.CONCRETE_BLOCK.getIcon();
        }
        return icon;
    }

    public static String getBlockNameFromMetadata(int meta) {
        return EnumCube.fromOrdinal(meta).getTag();
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        int meta = world.func_72805_g(x, y, z);
        EnumCube.fromOrdinal(meta).getBlock().onNeighborBlockChange(world, x, y, z, id);
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        EnumCube.fromOrdinal(meta).getBlock().updateTick(world, x, y, z, rand);
    }

    public void func_85105_g(World world, int i, int j, int k, int meta) {
        EnumCube.fromOrdinal(meta).getBlock().onBlockPlaced(world, i, j, k);
    }

    public void func_71862_a(World world, int i, int j, int k, Random rand) {
        int meta = world.func_72805_g(i, j, k);
        EnumCube.fromOrdinal(meta).getBlock().randomDisplayTick(world, i, j, k, rand);
    }

    public void func_71861_g(World world, int i, int j, int k) {
        int meta = world.func_72805_g(i, j, k);
        EnumCube.fromOrdinal(meta).getBlock().onBlockAdded(world, i, j, k);
    }

    public void func_71852_a(World world, int i, int j, int k, int id, int meta) {
        EnumCube.fromOrdinal(meta).getBlock().onBlockRemoval(world, i, j, k);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int i, int j, int k) {
        int meta = world.func_72805_g(i, j, k);
        return EnumCube.fromOrdinal(meta).getBlock().removeBlockByPlayer(world, player, i, j, k);
    }

    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        if (this.override != null) {
            return true;
        }
        return super.func_71877_c(world, x, y, z, side);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int i, int j, int k) {
        int meta = world.func_72805_g(i, j, k);
        return EnumCube.fromOrdinal(meta).getBlock().canCreatureSpawn(type, world, i, j, k);
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumCube type : EnumCube.getCreativeList()) {
            if (!type.isEnabled()) continue;
            list.add(type.getItem());
        }
    }

    public float getExplosionResistance(Entity exploder, World world, int i, int j, int k, double srcX, double srcY, double srcZ) {
        int meta = world.func_72805_g(i, j, k);
        return EnumCube.fromOrdinal(meta).getResistance() * 3.0f / 5.0f;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        return EnumCube.fromOrdinal(metadata).getBlock().getFireSpreadSpeed(world, x, y, z, metadata, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return EnumCube.fromOrdinal(metadata).getBlock().getFlammability(world, x, y, z, metadata, face);
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return EnumCube.fromOrdinal(metadata).getBlock().isFlammable(world, x, y, z, metadata, face);
    }
}

