/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.lamp;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.common.blocks.aesthetics.lamp.EnumStoneLamp;
import mods.railcraft.common.blocks.aesthetics.lamp.ItemStoneLamp;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockStoneLamp
extends Block {
    public static boolean useCandleIcon = false;
    private static final float SELECT = 0.125f;
    private static BlockStoneLamp instance;
    private final int renderId;
    public Icon candleIcon;

    public static BlockStoneLamp getBlock() {
        return instance;
    }

    public static void registerBlock() {
        int id;
        if (instance == null && (id = RailcraftConfig.getBlockId("block.stonelamp")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            instance = new BlockStoneLamp(id, renderId);
            instance.func_71864_b("railcraft.stonelamp");
            GameRegistry.registerBlock((Block)instance, ItemStoneLamp.class, (String)instance.func_71917_a());
            for (EnumStoneLamp lamp : EnumStoneLamp.VALUES) {
                MinecraftForge.setBlockHarvestLevel((Block)instance, (int)lamp.ordinal(), (String)"pickaxe", (int)0);
                RailcraftLanguage.instance().registerItemName(lamp.getItem(), lamp.getTag());
                ItemRegistry.registerItemStack(lamp.getTag(), lamp.getItem());
                ForestryPlugin.addBackpackItem("builder", lamp.getItem());
            }
        }
    }

    protected BlockStoneLamp(int id, int renderId) {
        super(id, Material.field_76263_r);
        this.renderId = renderId;
        this.func_71884_a(Block.field_71976_h);
        this.func_71849_a(CreativePlugin.TAB);
        this.func_71848_c(5.0f);
        this.func_71894_b(15.0f);
        BlockStoneLamp.field_71970_n[id] = false;
        BlockStoneLamp.field_71971_o[id] = 0;
        this.func_71900_a(0.9375f);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return new ItemStack((Block)this, 1, meta);
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumStoneLamp lamp : EnumStoneLamp.creativeList) {
            if (!lamp.isEnabled()) continue;
            list.add(lamp.getItem());
        }
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.125f), (double)((float)y + 0.125f), (double)((float)z + 0.125f), (double)((float)(x + 1) - 0.125f), (double)((float)y + 1.0f - 0.0625f), (double)((float)(z + 1) - 0.125f));
    }

    public void func_71862_a(World world, int x, int y, int z, Random par5Random) {
        double dx = (float)x + 0.5f;
        double dy = (float)y + 0.65f;
        double dz = (float)z + 0.5f;
        world.func_72869_a("smoke", dx, dy, dz, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", dx, dy, dz, 0.0, 0.0, 0.0);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public int func_71857_b() {
        return this.renderId;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (useCandleIcon) {
            return this.candleIcon;
        }
        return EnumStoneLamp.fromOrdinal(meta).getTexture(side);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addBlockHitEffects(worldObj, instance, target, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addBlockDestroyEffects(worldObj, instance, x, y, z, meta, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.candleIcon = iconRegister.func_94245_a("railcraft:stonelamp.candle");
    }
}

