/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.stairs;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.aesthetics.stairs.EnumStair;
import mods.railcraft.common.blocks.aesthetics.stairs.ItemStair;
import mods.railcraft.common.blocks.aesthetics.stairs.TileStair;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.IBlockSoundProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.StepSound;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockRailcraftStairs
extends BlockStairs
implements IBlockSoundProvider {
    private static BlockRailcraftStairs instance;
    private final int renderId;
    public static int currentRenderPass;

    public static BlockRailcraftStairs getBlock() {
        return instance;
    }

    public static void registerBlock() {
        int id;
        if (instance == null && (id = RailcraftConfig.getBlockId("block.stair")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            instance = new BlockRailcraftStairs(id, renderId);
            instance.func_71864_b("railcraft.stair");
            GameRegistry.registerBlock((Block)instance, ItemStair.class, (String)instance.func_71917_a());
            GameRegistry.registerTileEntity(TileStair.class, (String)"RCStairTile");
            block6: for (EnumStair stair : EnumStair.VALUES) {
                switch (stair) {
                    case SNOW: {
                        MinecraftForge.setBlockHarvestLevel((Block)instance, (int)stair.ordinal(), (String)"shovel", (int)0);
                        break;
                    }
                    default: {
                        MinecraftForge.setBlockHarvestLevel((Block)instance, (int)stair.ordinal(), (String)"pickaxe", (int)0);
                    }
                }
                RailcraftLanguage.instance().registerItemName(stair.getItem(), stair.getTag());
                ItemRegistry.registerItemStack(stair.getTag(), stair.getItem());
                switch (stair) {
                    case SNOW: 
                    case ICE: {
                        continue block6;
                    }
                    default: {
                        ForestryPlugin.addBackpackItem("builder", stair.getItem());
                    }
                }
            }
        }
    }

    protected BlockRailcraftStairs(int id, int renderId) {
        super(id, Block.field_72007_bm, 0);
        this.renderId = renderId;
        this.func_71884_a(RailcraftSound.getInstance());
        this.func_71849_a(CreativePlugin.TAB);
        BlockRailcraftStairs.field_71982_s[id] = true;
        this.field_72025_cg = true;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileStair) {
            return new ItemStack((Block)this, 1, ((TileStair)tile).getStair().ordinal());
        }
        return null;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumStair stair : EnumStair.creativeList) {
            if (!stair.isEnabled()) continue;
            list.add(stair.getItem());
        }
    }

    public ArrayList getBlockDropped(World world, int i, int j, int k, int md, int fortune) {
        TileEntity tile = world.func_72796_p(i, j, k);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tile instanceof TileStair) {
            items.add(new ItemStack((Block)this, 1, ((TileStair)tile).getStair().ordinal()));
        }
        return items;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_71860_a(world, x, y, z, entity, stack);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileStair) {
            ((TileStair)tile).setStair(EnumStair.fromOrdinal(stack.func_77960_j()));
        }
    }

    public void func_71893_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71064_a(StatList.field_75934_C[this.field_71990_ca], 1);
        player.func_71020_j(0.025f);
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            this.func_71897_c(world, x, y, z, 0, 0);
        }
        return world.func_94571_i(x, y, z);
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        super.func_71852_a(world, x, y, z, par5, par6);
        world.func_72932_q(x, y, z);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileStair();
    }

    public float func_71934_m(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileStair) {
            return ((TileStair)tile).getStair().getBlockHardness(world, x, y, z);
        }
        return super.func_71934_m(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileStair) {
            return ((TileStair)tile).getStair().getExplosionResistance(entity);
        }
        return super.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public int func_71857_b() {
        return this.renderId;
    }

    public int func_71856_s_() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        currentRenderPass = pass;
        return pass == 0 || pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return EnumStair.fromOrdinal(meta).getIcon(side);
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileStair) {
            return ((TileStair)tile).getTexture(side);
        }
        return super.func_71895_b(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addBlockHitEffects(worldObj, (Block)instance, target, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addBlockDestroyEffects(worldObj, (Block)instance, x, y, z, meta, effectRenderer, null);
    }

    @Override
    public StepSound getSound(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileStair) {
            return ((TileStair)tile).getStair().getSound();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
    }
}

