/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.stairs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.aesthetics.IDerivedBlock;
import mods.railcraft.common.blocks.aesthetics.brick.BlockBrick;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.stairs.BlockRailcraftStairs;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.StepSound;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public enum EnumStair implements IDerivedBlock
{
    SANDY_BRICK,
    INFERNAL_BRICK,
    CONCRETE,
    SNOW,
    ICE,
    IRON,
    GOLD,
    DIAMOND,
    FROSTBOUND_BRICK,
    QUARRIED_BRICK,
    BLEACHEDBONE_BRICK,
    BLOODSTAINED_BRICK,
    ABYSSAL_BRICK,
    SANDY_FITTED,
    INFERNAL_FITTED,
    FROSTBOUND_FITTED,
    QUARRIED_FITTED,
    BLEACHEDBONE_FITTED,
    BLOODSTAINED_FITTED,
    ABYSSAL_FITTED,
    NETHER_FITTED,
    SANDY_BLOCK,
    INFERNAL_BLOCK,
    FROSTBOUND_BLOCK,
    QUARRIED_BLOCK,
    BLEACHEDBONE_BLOCK,
    BLOODSTAINED_BLOCK,
    ABYSSAL_BLOCK,
    NETHER_BLOCK,
    SANDY_COBBLE,
    INFERNAL_COBBLE,
    FROSTBOUND_COBBLE,
    QUARRIED_COBBLE,
    BLEACHEDBONE_COBBLE,
    BLOODSTAINED_COBBLE,
    ABYSSAL_COBBLE,
    NETHER_COBBLE,
    CREOSOTE;

    public static final EnumStair[] VALUES;
    public static final Map NAMES;
    public static final List creativeList;
    private StepSound sound;
    private Block source;
    private int sourceMeta = 0;

    public static void initialize() {
        EnumStair.INFERNAL_BRICK.source = BlockBrick.infernal;
        EnumStair.SANDY_BRICK.source = BlockBrick.sandy;
        EnumStair.FROSTBOUND_BRICK.source = BlockBrick.frostbound;
        EnumStair.QUARRIED_BRICK.source = BlockBrick.quarried;
        EnumStair.BLEACHEDBONE_BRICK.source = BlockBrick.bleachedbone;
        EnumStair.BLOODSTAINED_BRICK.source = BlockBrick.bloodstained;
        EnumStair.ABYSSAL_BRICK.source = BlockBrick.abyssal;
        EnumStair.SANDY_FITTED.source = BlockBrick.sandy;
        EnumStair.SANDY_FITTED.sourceMeta = 1;
        EnumStair.INFERNAL_FITTED.source = BlockBrick.infernal;
        EnumStair.INFERNAL_FITTED.sourceMeta = 1;
        EnumStair.FROSTBOUND_FITTED.source = BlockBrick.frostbound;
        EnumStair.FROSTBOUND_FITTED.sourceMeta = 1;
        EnumStair.QUARRIED_FITTED.source = BlockBrick.quarried;
        EnumStair.QUARRIED_FITTED.sourceMeta = 1;
        EnumStair.BLEACHEDBONE_FITTED.source = BlockBrick.bleachedbone;
        EnumStair.BLEACHEDBONE_FITTED.sourceMeta = 1;
        EnumStair.BLOODSTAINED_FITTED.source = BlockBrick.bloodstained;
        EnumStair.BLOODSTAINED_FITTED.sourceMeta = 1;
        EnumStair.ABYSSAL_FITTED.source = BlockBrick.abyssal;
        EnumStair.ABYSSAL_FITTED.sourceMeta = 1;
        EnumStair.NETHER_FITTED.source = BlockBrick.nether;
        EnumStair.NETHER_FITTED.sourceMeta = 1;
        EnumStair.SANDY_BLOCK.source = BlockBrick.sandy;
        EnumStair.SANDY_BLOCK.sourceMeta = 2;
        EnumStair.INFERNAL_BLOCK.source = BlockBrick.infernal;
        EnumStair.INFERNAL_BLOCK.sourceMeta = 2;
        EnumStair.FROSTBOUND_BLOCK.source = BlockBrick.frostbound;
        EnumStair.FROSTBOUND_BLOCK.sourceMeta = 2;
        EnumStair.QUARRIED_BLOCK.source = BlockBrick.quarried;
        EnumStair.QUARRIED_BLOCK.sourceMeta = 2;
        EnumStair.BLEACHEDBONE_BLOCK.source = BlockBrick.bleachedbone;
        EnumStair.BLEACHEDBONE_BLOCK.sourceMeta = 2;
        EnumStair.BLOODSTAINED_BLOCK.source = BlockBrick.bloodstained;
        EnumStair.BLOODSTAINED_BLOCK.sourceMeta = 2;
        EnumStair.ABYSSAL_BLOCK.source = BlockBrick.abyssal;
        EnumStair.ABYSSAL_BLOCK.sourceMeta = 2;
        EnumStair.NETHER_BLOCK.source = BlockBrick.nether;
        EnumStair.NETHER_BLOCK.sourceMeta = 2;
        EnumStair.SANDY_COBBLE.source = BlockBrick.sandy;
        EnumStair.SANDY_COBBLE.sourceMeta = 5;
        EnumStair.INFERNAL_COBBLE.source = BlockBrick.infernal;
        EnumStair.INFERNAL_COBBLE.sourceMeta = 5;
        EnumStair.FROSTBOUND_COBBLE.source = BlockBrick.frostbound;
        EnumStair.FROSTBOUND_COBBLE.sourceMeta = 5;
        EnumStair.QUARRIED_COBBLE.source = BlockBrick.quarried;
        EnumStair.QUARRIED_COBBLE.sourceMeta = 5;
        EnumStair.BLEACHEDBONE_COBBLE.source = BlockBrick.bleachedbone;
        EnumStair.BLEACHEDBONE_COBBLE.sourceMeta = 5;
        EnumStair.BLOODSTAINED_COBBLE.source = BlockBrick.bloodstained;
        EnumStair.BLOODSTAINED_COBBLE.sourceMeta = 5;
        EnumStair.ABYSSAL_COBBLE.source = BlockBrick.abyssal;
        EnumStair.ABYSSAL_COBBLE.sourceMeta = 5;
        EnumStair.NETHER_COBBLE.source = BlockBrick.nether;
        EnumStair.NETHER_COBBLE.sourceMeta = 5;
        EnumStair.CONCRETE.source = BlockCube.getBlock();
        EnumStair.CONCRETE.sourceMeta = EnumCube.CONCRETE_BLOCK.ordinal();
        EnumStair.CREOSOTE.source = BlockCube.getBlock();
        EnumStair.CREOSOTE.sourceMeta = EnumCube.CREOSOTE_BLOCK.ordinal();
        EnumStair.SNOW.source = Block.field_72039_aU;
        EnumStair.ICE.source = Block.field_72036_aT;
        EnumStair.IRON.source = Block.field_72083_ai;
        EnumStair.GOLD.source = Block.field_72105_ah;
        EnumStair.DIAMOND.source = Block.field_72071_ax;
        for (EnumStair stair : VALUES) {
            NAMES.put(stair.name(), stair);
            switch (stair) {
                case CONCRETE: {
                    stair.sound = Block.field_71976_h;
                    break;
                }
                case CREOSOTE: {
                    stair.sound = Block.field_71967_e;
                    break;
                }
                default: {
                    stair.sound = stair.source.field_72020_cn;
                }
            }
            if (stair.sound == RailcraftSound.getInstance()) {
                throw new RuntimeException("Invalid Sound Defined!");
            }
            if (!stair.isEnabled() || stair.source == null) continue;
            CraftingPlugin.addShapedRecipe(stair.getItem(4), "S  ", "SS ", "SSS", Character.valueOf('S'), stair.getSourceItem());
            IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(stair.getItem(), true, false);
            recipe.addOutput(stair.getSourceItem(), 1.0f);
        }
        EnumStair.addRockCrusherRecipe(BlockBrick.abyssal.getItemStack(BlockBrick.BrickVariant.COBBLE, 1), ABYSSAL_BLOCK, ABYSSAL_BRICK, ABYSSAL_COBBLE, ABYSSAL_FITTED);
        EnumStair.addRockCrusherRecipe(BlockBrick.bleachedbone.getItemStack(BlockBrick.BrickVariant.COBBLE, 1), BLEACHEDBONE_BLOCK, BLEACHEDBONE_BRICK, BLEACHEDBONE_COBBLE, BLEACHEDBONE_FITTED);
        EnumStair.addRockCrusherRecipe(BlockBrick.bloodstained.getItemStack(BlockBrick.BrickVariant.COBBLE, 1), BLOODSTAINED_BLOCK, BLOODSTAINED_BRICK, BLOODSTAINED_COBBLE, BLOODSTAINED_FITTED);
        EnumStair.addRockCrusherRecipe(BlockBrick.frostbound.getItemStack(BlockBrick.BrickVariant.COBBLE, 1), FROSTBOUND_BLOCK, FROSTBOUND_BRICK, FROSTBOUND_COBBLE, FROSTBOUND_FITTED);
        EnumStair.addRockCrusherRecipe(BlockBrick.infernal.getItemStack(BlockBrick.BrickVariant.COBBLE, 1), INFERNAL_BLOCK, INFERNAL_BRICK, INFERNAL_COBBLE, INFERNAL_FITTED);
        EnumStair.addRockCrusherRecipe(BlockBrick.nether.getItemStack(BlockBrick.BrickVariant.COBBLE, 1), NETHER_BLOCK, NETHER_COBBLE, NETHER_FITTED);
        EnumStair.addRockCrusherRecipe(BlockBrick.quarried.getItemStack(BlockBrick.BrickVariant.COBBLE, 1), QUARRIED_BLOCK, QUARRIED_BRICK, QUARRIED_COBBLE, QUARRIED_FITTED);
        EnumStair.addRockCrusherRecipe(BlockBrick.sandy.getItemStack(BlockBrick.BrickVariant.COBBLE, 1), SANDY_BLOCK, SANDY_BRICK, SANDY_COBBLE, SANDY_FITTED);
        creativeList.add(SNOW);
        creativeList.add(ICE);
        creativeList.add(IRON);
        creativeList.add(GOLD);
        creativeList.add(DIAMOND);
        creativeList.add(CONCRETE);
        creativeList.add(CREOSOTE);
        creativeList.add(ABYSSAL_BRICK);
        creativeList.add(ABYSSAL_FITTED);
        creativeList.add(ABYSSAL_BLOCK);
        creativeList.add(ABYSSAL_COBBLE);
        creativeList.add(INFERNAL_BRICK);
        creativeList.add(INFERNAL_FITTED);
        creativeList.add(INFERNAL_BLOCK);
        creativeList.add(INFERNAL_COBBLE);
        creativeList.add(BLOODSTAINED_BRICK);
        creativeList.add(BLOODSTAINED_FITTED);
        creativeList.add(BLOODSTAINED_BLOCK);
        creativeList.add(BLOODSTAINED_COBBLE);
        creativeList.add(SANDY_BRICK);
        creativeList.add(SANDY_FITTED);
        creativeList.add(SANDY_BLOCK);
        creativeList.add(SANDY_COBBLE);
        creativeList.add(BLEACHEDBONE_BRICK);
        creativeList.add(BLEACHEDBONE_FITTED);
        creativeList.add(BLEACHEDBONE_BLOCK);
        creativeList.add(BLEACHEDBONE_COBBLE);
        creativeList.add(NETHER_FITTED);
        creativeList.add(NETHER_BLOCK);
        creativeList.add(NETHER_COBBLE);
        creativeList.add(QUARRIED_BRICK);
        creativeList.add(QUARRIED_FITTED);
        creativeList.add(QUARRIED_BLOCK);
        creativeList.add(QUARRIED_COBBLE);
        creativeList.add(FROSTBOUND_BRICK);
        creativeList.add(FROSTBOUND_FITTED);
        creativeList.add(FROSTBOUND_BLOCK);
        creativeList.add(FROSTBOUND_COBBLE);
    }

    private static void addRockCrusherRecipe(ItemStack output, EnumStair ... stairs) {
        for (EnumStair stair : stairs) {
            IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack(stair.source, 1, stair.sourceMeta), true, false);
            recipe.addOutput(output, 1.0f);
        }
    }

    public static EnumStair fromOrdinal(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public static EnumStair fromName(String name) {
        EnumStair stair = (EnumStair)NAMES.get(name);
        if (stair != null) {
            return stair;
        }
        return SANDY_BRICK;
    }

    public Icon getIcon(int side) {
        return this.getSourceBlock().func_71858_a(side, this.sourceMeta);
    }

    @Override
    public Block getSourceBlock() {
        if (this.source == null) {
            return Block.field_72007_bm;
        }
        return this.source;
    }

    @Override
    public int getSourceMeta() {
        return this.sourceMeta;
    }

    public Block getBlock() {
        return BlockRailcraftStairs.getBlock();
    }

    public StepSound getSound() {
        return this.sound;
    }

    public ItemStack getSourceItem() {
        if (this.source == null) {
            return null;
        }
        return new ItemStack(this.source, 1, this.sourceMeta);
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public String getTag() {
        return "railcraft.stair." + this.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && this.getBlock() != null;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        switch (this) {
            case CONCRETE: {
                return EnumCube.CONCRETE_BLOCK.getHardness();
            }
        }
        Block block = this.getSourceBlock();
        if (block == null) {
            return Block.field_72081_al.func_71934_m(world, x, y, z);
        }
        return block.func_71934_m(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity) {
        switch (this) {
            case CONCRETE: {
                return EnumCube.CONCRETE_BLOCK.getResistance() * 3.0f / 5.0f;
            }
        }
        Block block = this.getSourceBlock();
        if (block == null) {
            return Block.field_72081_al.func_71904_a(entity);
        }
        return block.func_71904_a(entity);
    }

    static {
        VALUES = EnumStair.values();
        NAMES = new HashMap();
        creativeList = new ArrayList();
    }
}

