/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.detector.Detector;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.gui.EnumGui;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class DetectorVillager
extends Detector {
    private int profession;
    private Mode mode = Mode.ANY;

    @Override
    public EnumDetector getType() {
        return EnumDetector.VILLAGER;
    }

    private boolean cartHasVillager(List carts) {
        for (EntityMinecart cart : carts) {
            if (!(cart.field_70153_n instanceof EntityVillager)) continue;
            return true;
        }
        return false;
    }

    private boolean cartHasProfesion(List carts) {
        for (EntityMinecart cart : carts) {
            EntityVillager villager;
            if (!(cart.field_70153_n instanceof EntityVillager) || (villager = (EntityVillager)cart.field_70153_n).func_70946_n() != this.profession) continue;
            return true;
        }
        return false;
    }

    @Override
    public int testCarts(List carts) {
        switch (this.mode) {
            case ANY: {
                return this.cartHasVillager(carts) ? 15 : 0;
            }
            case NONE: {
                return !this.cartHasVillager(carts) ? 15 : 0;
            }
            case EQUALS: {
                return this.cartHasProfesion(carts) ? 15 : 0;
            }
            case NOT: {
                return !this.cartHasProfesion(carts) ? 15 : 0;
            }
        }
        return 0;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        this.openGui(EnumGui.DETECTOR_VILLAGER, player);
        return true;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setProfession(int profession) {
        this.profession = profession;
    }

    public int getProfession() {
        return this.profession;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("profession", this.profession);
        data.func_74774_a("mode", (byte)this.mode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.profession = data.func_74762_e("profession");
        this.mode = Mode.values()[data.func_74771_c("mode")];
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.profession);
        data.writeByte((byte)this.mode.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.profession = data.readInt();
        this.mode = Mode.values()[data.readByte()];
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeInt(this.profession);
        data.writeByte(this.mode.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.profession = data.readInt();
        this.mode = Mode.values()[data.readByte()];
    }

    public static enum Mode {
        ANY,
        NONE,
        NOT,
        EQUALS;

    }
}

