/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.hidden;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.hidden.BlockHidden;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.nbt.NBTTagCompound;

public class TileHidden
extends RailcraftTileEntity {
    public WorldCoordinate lastMarker;
    public long colorSeed;
    public long timestamp = -1L;

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            if (this.lastMarker != null && EffectManager.instance.isTrackingAuraActive()) {
                EffectManager.instance.trailEffect(this.lastMarker.x, this.lastMarker.y, this.lastMarker.z, this, this.colorSeed);
            }
            return;
        }
        if (this.timestamp == -1L) {
            return;
        }
        if (this.clock % 64 == 0) {
            boolean timeElapsed;
            if (BlockHidden.getBlock() == null) {
                this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.field_70331_k.func_72932_q(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                return;
            }
            int blockId = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (blockId != BlockHidden.getBlock().field_71990_ca) {
                this.field_70331_k.func_72932_q(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                return;
            }
            long hour = TimeUnit.MILLISECONDS.convert(20L, TimeUnit.MINUTES);
            boolean bl = timeElapsed = System.currentTimeMillis() - this.timestamp >= hour;
            if (timeElapsed) {
                this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 6);
                this.field_70331_k.func_72932_q(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        if (this.lastMarker != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("dim", this.lastMarker.dimension);
            nbt.func_74768_a("x", this.lastMarker.x);
            nbt.func_74768_a("y", this.lastMarker.y);
            nbt.func_74768_a("z", this.lastMarker.z);
            data.func_74766_a("last", nbt);
        }
        data.func_74772_a("seed", this.colorSeed);
        data.func_74772_a("time", this.timestamp);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        if (data.func_74764_b("last")) {
            NBTTagCompound nbt = data.func_74775_l("last");
            int dim = nbt.func_74762_e("dim");
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            this.lastMarker = new WorldCoordinate(dim, x, y, z);
        }
        this.colorSeed = data.func_74763_f("seed");
        this.timestamp = data.func_74763_f("time");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeLong(this.colorSeed);
        data.writeBoolean(this.lastMarker != null);
        if (this.lastMarker != null) {
            data.writeInt(this.lastMarker.dimension);
            data.writeInt(this.lastMarker.x);
            data.writeInt(this.lastMarker.y);
            data.writeInt(this.lastMarker.z);
        }
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.colorSeed = data.readLong();
        if (data.readBoolean()) {
            int dim = data.readInt();
            int x = data.readInt();
            int y = data.readInt();
            int z = data.readInt();
            this.lastMarker = new WorldCoordinate(dim, x, y, z);
        }
    }

    @Override
    public String func_70303_b() {
        return "";
    }

    @Override
    public short getId() {
        return 111;
    }
}

