/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.IMachineProxy;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockMachine
extends BlockContainer {
    private final IMachineProxy proxy;
    private final boolean opaque;
    private final int renderId;
    private final int[] metaOpacity;

    public BlockMachine(int blockID, int renderId, IMachineProxy proxy, boolean opaque, int[] metaOpacity) {
        super(blockID, Material.field_76246_e);
        this.func_71894_b(4.5f);
        this.func_71848_c(2.0f);
        this.func_71884_a(field_71976_h);
        this.func_71907_b(true);
        this.proxy = proxy;
        this.opaque = opaque;
        this.renderId = renderId;
        this.metaOpacity = metaOpacity;
        this.func_71849_a(CreativePlugin.TAB);
        BlockMachine.field_71970_n[blockID] = opaque;
        BlockMachine.field_71971_o[blockID] = opaque ? 255 : 0;
    }

    public int func_71857_b() {
        return this.renderId;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_71888_h(IBlockAccess world, int x, int y, int z) {
        return 1.0f;
    }

    public IMachineProxy getMachineProxy() {
        return this.proxy;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.proxy.registerIcons(iconRegister);
    }

    public Icon func_71895_b(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getIcon(side);
        }
        int meta = world.func_72805_g(i, j, k);
        return this.func_71858_a(side, meta);
    }

    public Icon func_71858_a(int side, int meta) {
        return this.proxy.getTexture(meta, side);
    }

    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).colorMultiplier();
        }
        return super.func_71920_b(world, x, y, z);
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).recolourBlock(colour);
        }
        return false;
    }

    public int func_71885_a(int meta, Random random, int j) {
        return this.field_71990_ca;
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public boolean func_71903_a(World world, int i, int j, int k, EntityPlayer player, int side, float u1, float u2, float u3) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).blockActivated(player, side);
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).rotateBlock(axis);
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getValidRotations();
        }
        return super.getValidRotations(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int i, int j, int k, Random random) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).randomDisplayTick(random);
        }
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).isBlockSolidOnSide(side);
        }
        return true;
    }

    public void func_71893_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71064_a(StatList.field_75934_C[this.field_71990_ca], 1);
        player.func_71020_j(0.025f);
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            if (this.canSilkHarvest(world, player, x, y, z, 0) && EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
                ArrayList drops = this.getBlockDroppedSilkTouch(world, x, y, z, 0, 0);
                for (ItemStack stack : drops) {
                    this.func_71929_a(world, x, y, z, stack);
                }
            } else {
                this.func_71897_c(world, x, y, z, 0, 0);
            }
        }
        return world.func_94571_i(x, y, z);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getBlockDropped(fortune);
        }
        return super.getBlockDropped(world, x, y, z, metadata, fortune);
    }

    public ArrayList getBlockDroppedSilkTouch(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getBlockDroppedSilkTouch(fortune);
        }
        return super.getBlockDropped(world, x, y, z, metadata, fortune);
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).canSilkHarvest(player);
        }
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ArrayList drops = this.getBlockDroppedSilkTouch(world, x, y, z, 0, 0);
        return (ItemStack)drops.get(0);
    }

    public boolean func_71853_i() {
        return true;
    }

    public int func_71865_a(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).isPoweringTo(side) ? 15 : 0;
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).canConnectRedstone(dir);
        }
        return false;
    }

    public void initFromItem(World world, int i, int j, int k, ItemStack stack) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).initFromItem(stack);
        }
    }

    public void func_71860_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).onBlockPlacedBy(entityliving);
        }
    }

    public void func_71863_a(World world, int i, int j, int k, int id) {
        try {
            TileEntity tile = world.func_72796_p(i, j, k);
            if (tile instanceof TileMachineBase) {
                ((TileMachineBase)tile).onNeighborBlockChange(id);
            }
        }
        catch (StackOverflowError error) {
            Game.logError(Level.SEVERE, 10, "Error in BlockMachine.onNeighborBlockChange()", error);
            throw error;
        }
    }

    public void func_71861_g(World world, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).onBlockAdded();
        }
    }

    public void func_71852_a(World world, int x, int y, int z, int id, int meta) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).onBlockRemoval();
        }
        super.func_71852_a(world, x, y, z, id, meta);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return this.proxy.getTileEntity(metadata);
    }

    public TileEntity func_72274_a(World var1) {
        return null;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getLightValue();
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (IEnumMachine type : this.proxy.getCreativeList()) {
            if (!type.isAvaliable()) continue;
            list.add(type.getItem());
        }
    }

    public final boolean func_71926_d() {
        return this.opaque;
    }

    public int getLightOpacity(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.metaOpacity[meta];
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double srcX, double srcY, double srcZ) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getResistance(exploder) * 3.0f / 5.0f;
        }
        return super.getExplosionResistance(exploder, world, x, y, z, this.field_72026_ch, this.field_72023_ci, this.field_72024_cj);
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).canCreatureSpawn(type);
        }
        return super.canCreatureSpawn(type, world, x, y, z);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getHardness();
        }
        return super.func_71934_m(world, x, y, z);
    }
}

