/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import buildcraft.api.gates.IAction;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import mods.railcraft.common.blocks.machine.TileMultiBlockInventory;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumSkyBlock;

public abstract class TileMultiBlockOven
extends TileMultiBlockInventory
implements INeedsFuel,
IHasWork {
    protected int cookTime;
    protected boolean cooking;
    private boolean wasBurning;
    protected boolean paused = false;
    private final Set actions = new HashSet();

    public TileMultiBlockOven(String name, int invNum, List patterns) {
        super(name, invNum, patterns);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.getPatternMarker() == 'W' && this.clock % 4 == 0) {
            this.updateLighting();
        }
        if (Game.isHost(this.field_70331_k) && this.isMaster && this.clock % 16 == 0) {
            this.processActions();
        }
    }

    protected void updateLighting() {
        boolean b = this.isBurning();
        if (this.wasBurning != b) {
            this.wasBurning = b;
            this.field_70331_k.func_72936_c(EnumSkyBlock.Block, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.markBlockForUpdate();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random random) {
        this.updateLighting();
        if (this.getPatternMarker() == 'W' && this.isStructureValid() && random.nextInt(100) < 20 && this.isBurning()) {
            float f = (float)this.field_70329_l + 0.5f;
            float f1 = (float)this.field_70330_m + 0.4375f + random.nextFloat() * 3.0f / 16.0f;
            float f2 = (float)this.field_70327_n + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            this.field_70331_k.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            this.field_70331_k.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            this.field_70331_k.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            this.field_70331_k.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("cookTime", this.cookTime);
        data.func_74757_a("cooking", this.cooking);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.cookTime = data.func_74762_e("cookTime");
        this.cooking = data.func_74767_n("cooking");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.cookTime);
        data.writeBoolean(this.cooking);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.cookTime = data.readInt();
        this.cooking = data.readBoolean();
    }

    public int getCookTime() {
        TileMultiBlockOven masterOven = (TileMultiBlockOven)this.getMasterBlock();
        if (masterOven != null) {
            return masterOven.cookTime;
        }
        return -1;
    }

    public boolean isCooking() {
        TileMultiBlockOven masterOven = (TileMultiBlockOven)this.getMasterBlock();
        if (masterOven != null) {
            return masterOven.cooking;
        }
        return false;
    }

    public boolean isBurning() {
        return this.isCooking();
    }

    public void setCooking(boolean c) {
        if (this.cooking != c) {
            this.cooking = c;
            this.sendUpdateToClient();
        }
    }

    public void setCookTime(int i) {
        this.cookTime = i;
    }

    public abstract int getTotalCookTime();

    public int getCookProgressScaled(int i) {
        if (this.cookTime == 0 || this.getTotalCookTime() == 0) {
            return 0;
        }
        int scale = this.cookTime * i / this.getTotalCookTime();
        scale = Math.min(scale, i);
        scale = Math.max(scale, 0);
        return scale;
    }

    public abstract int getBurnProgressScaled(int var1);

    @Override
    public int getLightValue() {
        if (this.getPatternMarker() == 'W' && this.isStructureValid() && this.isBurning()) {
            return 13;
        }
        return 0;
    }

    private void processActions() {
        this.paused = false;
        for (IAction action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public boolean hasWork() {
        return this.isCooking();
    }

    @Override
    public void actionActivated(IAction action) {
        TileMultiBlockOven mBlock = (TileMultiBlockOven)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.actions.add(action);
        }
    }
}

